/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.utils.SystemPropertyUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CourgetteFeatureRunner {
    private Map<String, List<String>> runnerArgs;
    private Boolean output;
    private static Logger Log = Logger.getLogger((String)CourgetteFeatureRunner.class.getName());

    public CourgetteFeatureRunner(Map<String, List<String>> runnerArgs, Boolean output) {
        this.runnerArgs = runnerArgs;
        this.output = output;
    }

    public int run() {
        Process process = null;
        try {
            ProcessBuilder builder = new Builder().buildProcess();
            Log.debug((Object)("Builder: " + builder));
            process = builder.start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return process != null ? process.exitValue() : -1;
    }

    class Builder {
        Builder() {
        }

        ProcessBuilder buildProcess() {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            if (CourgetteFeatureRunner.this.output.booleanValue()) {
                builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            }
            builder.redirectErrorStream(true);
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("java");
            SystemPropertyUtils.splitAndAddPropertyToList("courgette.vmoptions", commands);
            if (this.isJava8()) {
                commands.add("-cp");
                commands.add("\"" + this.getClassPath() + "\"");
            } else {
                commands.add("-p");
                commands.add("jrt");
            }
            commands.addAll(this.getSystemProperties());
            commands.add("cucumber.api.cli.Main");
            CourgetteFeatureRunner.this.runnerArgs.forEach((key, value) -> commands.addAll((Collection<String>)value));
            builder.command(commands);
            return builder;
        }

        private boolean isJava8() {
            return System.getProperty("java.version").startsWith("1.8");
        }

        private String getClassPath() {
            StringBuffer classPathBuilder = new StringBuffer();
            URL[] classPathUrls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
            Arrays.asList(classPathUrls).forEach(url -> classPathBuilder.append(String.format("%s%s", url.getPath().replace("file:", ""), File.pathSeparator)));
            return classPathBuilder.toString();
        }

        private List<String> getSystemProperties() {
            ArrayList<String> systemPropertyList = new ArrayList<String>();
            System.getProperties().keySet().forEach(property -> systemPropertyList.add(String.format("-D%s=%s", property, System.getProperty(property.toString()))));
            systemPropertyList.removeIf(systemProperty -> systemProperty.startsWith("-Dcucumber.options"));
            return systemPropertyList;
        }
    }
}

