/*
 * Decompiled with CFR 0.152.
 */
package courgette.api.testng;

import courgette.api.CourgetteRunLevel;
import courgette.runtime.CourgetteLoader;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunOptions;
import courgette.runtime.CourgetteRunner;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.CourgetteTestFailureException;
import cucumber.runtime.model.CucumberFeature;
import gherkin.pickles.PickleLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class TestNGCourgette {
    private CourgetteProperties courgetteProperties;
    private List<CourgetteRunnerInfo> runnerInfoList;
    private static Logger Log = Logger.getLogger((String)TestNGCourgette.class.getName());

    @BeforeClass(alwaysRun=true)
    public void initialize() {
        CourgetteRunOptions courgetteOptions = new CourgetteRunOptions(this.getClass());
        this.courgetteProperties = new CourgetteProperties(courgetteOptions, this.createSessionId(), courgetteOptions.threads());
        CourgetteLoader courgetteFeatureLoader = new CourgetteLoader(this.courgetteProperties, this.getClass().getClassLoader());
        List<CucumberFeature> cucumberFeatures = courgetteFeatureLoader.getCucumberFeatures();
        this.runnerInfoList = new ArrayList<CourgetteRunnerInfo>();
        if (courgetteOptions.runLevel().equals((Object)CourgetteRunLevel.FEATURE)) {
            cucumberFeatures.forEach(feature -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (CucumberFeature)feature, null)));
        } else {
            Map<PickleLocation, CucumberFeature> scenarios = courgetteFeatureLoader.getCucumberScenarios();
            scenarios.keySet().forEach(location -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (CucumberFeature)scenarios.get(location), location.getLine())));
        }
    }

    @Test
    public void parallelRun() {
        CourgetteRunner courgetteRunner = new CourgetteRunner(this.runnerInfoList, this.courgetteProperties);
        if (courgetteRunner.canRunFeatures()) {
            courgetteRunner.run();
            courgetteRunner.createReport();
            courgetteRunner.createCourgetteReport();
        }
        if (courgetteRunner.hasFailures()) {
            courgetteRunner.createRerunFile();
            throw new CourgetteTestFailureException("There were failing tests. Refer to the Courgette html report for more details.");
        }
    }

    private String createSessionId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

