/*
 * Decompiled with CFR 0.152.
 */
package courgette.api.junit;

import courgette.api.CourgetteRunLevel;
import courgette.runtime.CourgetteCallbacks;
import courgette.runtime.CourgetteLoader;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunOptions;
import courgette.runtime.CourgetteRunner;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.CourgetteTestFailureException;
import cucumber.runner.EventBus;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runtime.BackendModuleBackendSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.model.CucumberFeature;
import gherkin.pickles.PickleLocation;
import io.cucumber.core.options.RunnerOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class Courgette
extends ParentRunner<FeatureRunner> {
    private final CourgetteLoader courgetteLoader;
    private final CourgetteProperties courgetteProperties;
    private final List<CucumberFeature> cucumberFeatures;
    private final List<CourgetteRunnerInfo> runnerInfoList;
    private final CourgetteCallbacks callbacks;

    public Courgette(Class clazz) throws InitializationError {
        super(clazz);
        CourgetteRunOptions courgetteOptions = new CourgetteRunOptions(clazz);
        this.courgetteProperties = new CourgetteProperties(courgetteOptions, this.createSessionId(), courgetteOptions.threads());
        this.callbacks = new CourgetteCallbacks(clazz);
        this.courgetteLoader = new CourgetteLoader(this.courgetteProperties, clazz.getClassLoader());
        this.cucumberFeatures = this.courgetteLoader.getCucumberFeatures();
        this.runnerInfoList = new ArrayList<CourgetteRunnerInfo>();
        if (courgetteOptions.runLevel().equals((Object)CourgetteRunLevel.FEATURE)) {
            this.cucumberFeatures.forEach(feature -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (CucumberFeature)feature, null)));
        } else {
            Map<PickleLocation, CucumberFeature> scenarios = this.courgetteLoader.getCucumberScenarios();
            scenarios.keySet().forEach(location -> this.runnerInfoList.add(new CourgetteRunnerInfo(this.courgetteProperties, (CucumberFeature)scenarios.get(location), location.getLine())));
        }
    }

    public List<FeatureRunner> getChildren() {
        RuntimeOptions runtimeOptions = this.courgetteLoader.getRuntimeOptions();
        EventBus eventBus = this.courgetteLoader.getEventBus();
        ResourceLoader resourceLoader = this.courgetteLoader.getResourceLoader();
        ClassFinder classFinder = this.courgetteLoader.getClassFinder();
        Filters filters = this.courgetteLoader.getFilters();
        JUnitOptions jUnitOptions = new JUnitOptions(runtimeOptions.isStrict(), runtimeOptions.getJunitOptions());
        BackendModuleBackendSupplier backendSupplier = new BackendModuleBackendSupplier(resourceLoader, classFinder, (RunnerOptions)runtimeOptions);
        ThreadLocalRunnerSupplier runnerSupplier = new ThreadLocalRunnerSupplier((RunnerOptions)runtimeOptions, eventBus, (BackendSupplier)backendSupplier);
        ArrayList<FeatureRunner> children = new ArrayList<FeatureRunner>();
        this.cucumberFeatures.forEach(cucumberFeature -> {
            try {
                FeatureRunner runner = new FeatureRunner(cucumberFeature, filters, runnerSupplier, jUnitOptions);
                runner.getDescription();
                children.add(runner);
            }
            catch (InitializationError error) {
                error.printStackTrace();
            }
        });
        return children;
    }

    protected Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    public void run(RunNotifier notifier) {
        CourgetteRunner courgetteRunner = new CourgetteRunner(this.runnerInfoList, this.courgetteProperties);
        try {
            this.callbacks.beforeAll();
            if (courgetteRunner.canRunFeatures()) {
                courgetteRunner.run();
                courgetteRunner.createReport();
                courgetteRunner.createCourgetteReport();
            }
            if (courgetteRunner.hasFailures()) {
                courgetteRunner.createRerunFile();
                throw new CourgetteTestFailureException("There were failing tests. Refer to the Courgette html report for more details.");
            }
        }
        finally {
            this.callbacks.afterAll();
        }
    }

    private String createSessionId() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
}

