/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.health;

import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.protobuf.services.HealthStatusManager;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lognet.springboot.grpc.GRpcService;
import org.lognet.springboot.grpc.health.ManagedHealthStatusService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;

@GRpcService
@Configuration
@ConditionalOnMissingBean(value={ManagedHealthStatusService.class})
public class DefaultHealthStatusService
extends ManagedHealthStatusService {
    private final HealthStatusManager healthStatusManager = new HealthStatusManager();
    private final HealthGrpc.HealthImplBase service = (HealthGrpc.HealthImplBase)this.healthStatusManager.getHealthService();
    private final Map<String, HealthCheckResponse.ServingStatus> statusMap = new ConcurrentHashMap<String, HealthCheckResponse.ServingStatus>();
    private final Map<String, HealthCheckResponse.ServingStatus> unmodifiableStatusMap = Collections.unmodifiableMap(this.statusMap);

    @Override
    public void onShutdown() {
        this.healthStatusManager.enterTerminalState();
    }

    @Override
    public void setStatus(String service, HealthCheckResponse.ServingStatus status) {
        this.statusMap.put(service, status);
        this.healthStatusManager.setStatus(service, status);
    }

    @Override
    public Map<String, HealthCheckResponse.ServingStatus> statuses() {
        return this.unmodifiableStatusMap;
    }

    public void check(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        this.service.check(request, responseObserver);
    }

    public void watch(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        this.service.watch(request, responseObserver);
    }
}

