/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.coreprogress;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import io.github.lizhangqu.coreprogress.ProgressListener;

public abstract class ProgressUIListener
extends ProgressListener {
    private Handler mHandler;
    private static final int WHAT_START = 1;
    private static final int WHAT_UPDATE = 2;
    private static final int WHAT_FINISH = 3;
    private static final String CURRENT_BYTES = "numBytes";
    private static final String TOTAL_BYTES = "totalBytes";
    private static final String PERCENT = "percent";
    private static final String SPEED = "speed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHandler() {
        if (this.mHandler != null) {
            return;
        }
        Class<ProgressUIListener> clazz = ProgressUIListener.class;
        synchronized (ProgressUIListener.class) {
            if (this.mHandler == null) {
                this.mHandler = new Handler(Looper.getMainLooper()){

                    public void handleMessage(Message msg) {
                        if (msg == null) {
                            return;
                        }
                        switch (msg.what) {
                            case 1: {
                                Bundle startData = msg.getData();
                                if (startData == null) {
                                    return;
                                }
                                ProgressUIListener.this.onUIProgressStart(startData.getLong(ProgressUIListener.TOTAL_BYTES));
                                break;
                            }
                            case 2: {
                                Bundle updateData = msg.getData();
                                if (updateData == null) {
                                    return;
                                }
                                long numBytes = updateData.getLong(ProgressUIListener.CURRENT_BYTES);
                                long totalBytes = updateData.getLong(ProgressUIListener.TOTAL_BYTES);
                                float percent = updateData.getFloat(ProgressUIListener.PERCENT);
                                float speed = updateData.getFloat(ProgressUIListener.SPEED);
                                ProgressUIListener.this.onUIProgressChanged(numBytes, totalBytes, percent, speed);
                                break;
                            }
                            case 3: {
                                ProgressUIListener.this.onUIProgressFinish();
                                break;
                            }
                        }
                    }
                };
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public final void onProgressChanged(long numBytes, long totalBytes, float percent, float speed) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.onUIProgressChanged(numBytes, totalBytes, percent, speed);
            return;
        }
        this.ensureHandler();
        Message message = this.mHandler.obtainMessage();
        message.what = 2;
        Bundle data = new Bundle();
        data.putLong(CURRENT_BYTES, numBytes);
        data.putLong(TOTAL_BYTES, totalBytes);
        data.putFloat(PERCENT, percent);
        data.putFloat(SPEED, speed);
        message.setData(data);
        this.mHandler.sendMessage(message);
    }

    @Override
    public final void onProgressStart(long totalBytes) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.onUIProgressStart(totalBytes);
            return;
        }
        this.ensureHandler();
        Message message = this.mHandler.obtainMessage();
        message.what = 1;
        Bundle data = new Bundle();
        data.putLong(TOTAL_BYTES, totalBytes);
        message.setData(data);
        this.mHandler.sendMessage(message);
    }

    @Override
    public final void onProgressFinish() {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.onUIProgressFinish();
            return;
        }
        this.ensureHandler();
        Message message = this.mHandler.obtainMessage();
        message.what = 3;
        this.mHandler.sendMessage(message);
    }

    public abstract void onUIProgressChanged(long var1, long var3, float var5, float var6);

    public void onUIProgressStart(long totalBytes) {
    }

    public void onUIProgressFinish() {
    }
}

