/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.coreprogress;

import io.github.lizhangqu.coreprogress.ProgressCallback;
import io.github.lizhangqu.coreprogress.ProgressOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

class ProgressRequestBody
extends RequestBody {
    private final RequestBody mRequestBody;
    private final ProgressCallback progressListener;

    ProgressRequestBody(RequestBody requestBody, ProgressCallback progressListener) {
        this.mRequestBody = requestBody;
        this.progressListener = progressListener;
    }

    public MediaType contentType() {
        return this.mRequestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.mRequestBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.progressListener == null) {
            this.mRequestBody.writeTo(sink);
            return;
        }
        ProgressOutputStream progressOutputStream = new ProgressOutputStream(sink.outputStream(), this.progressListener, this.contentLength());
        BufferedSink progressSink = Okio.buffer((Sink)Okio.sink((OutputStream)progressOutputStream));
        this.mRequestBody.writeTo(progressSink);
        progressSink.flush();
    }
}

