/*
 * Decompiled with CFR 0.152.
 */
package io.github.lizhangqu.coreprogress;

import io.github.lizhangqu.coreprogress.ProgressCallback;

public abstract class ProgressListener
implements ProgressCallback {
    boolean started;
    long lastRefreshTime = 0L;
    long lastBytesWritten = 0L;
    int minTime = 100;

    @Override
    public final void onProgressChanged(long numBytes, long totalBytes, float percent) {
        if (!this.started) {
            this.onProgressStart(totalBytes);
            this.started = true;
        }
        if (numBytes == -1L && totalBytes == -1L && percent == -1.0f) {
            this.onProgressChanged(-1L, -1L, -1.0f, -1.0f);
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRefreshTime >= (long)this.minTime || numBytes == totalBytes || percent >= 1.0f) {
            long intervalTime = currentTime - this.lastRefreshTime;
            if (intervalTime == 0L) {
                ++intervalTime;
            }
            long updateBytes = numBytes - this.lastBytesWritten;
            long networkSpeed = updateBytes / intervalTime;
            this.onProgressChanged(numBytes, totalBytes, percent, networkSpeed);
            this.lastRefreshTime = System.currentTimeMillis();
            this.lastBytesWritten = numBytes;
        }
        if (numBytes == totalBytes || percent >= 1.0f) {
            this.onProgressFinish();
        }
    }

    public abstract void onProgressChanged(long var1, long var3, float var5, float var6);

    public void onProgressStart(long totalBytes) {
    }

    public void onProgressFinish() {
    }
}

