/*
 * Decompiled with CFR 0.152.
 */
package com.orion.web.servlet.web;

import com.orion.lang.utils.time.Dates;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookiesExt {
    public static final int SESSION = -1;
    public static final int NO_SAVE = 0;
    public static final int ONE_HOUR = 3600;
    public static final int ONE_DAY = 86400;
    public static final int ONE_WEEK = 604800;

    private CookiesExt() {
    }

    public static String get(HttpServletRequest request, String key) {
        return CookiesExt.get(request, key, null);
    }

    public static String get(HttpServletRequest request, String key, String def) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return def;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(key)) continue;
            return cookie.getValue();
        }
        return def;
    }

    public static Map<String, String> gets(HttpServletRequest request, String ... keys) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return map;
        }
        for (Cookie cookie : cookies) {
            for (String key : keys) {
                if (!key.equals(cookie.getName())) continue;
                map.put(key, cookie.getValue());
            }
        }
        return map;
    }

    public static Map<String, String> list(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return map;
        }
        for (Cookie cookie : cookies) {
            map.put(cookie.getName(), cookie.getValue());
        }
        return map;
    }

    public static int getCount(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        return cookies == null ? 0 : cookies.length;
    }

    public static void set(HttpServletResponse response, String key, String value) {
        CookiesExt.set(response, key, value, 86400, null, null);
    }

    public static void set(HttpServletResponse response, String key, String value, int expire) {
        CookiesExt.set(response, key, value, expire, null, null);
    }

    public static void set(HttpServletResponse response, String key, String value, int expire, String path) {
        CookiesExt.set(response, key, value, expire, path, null);
    }

    public static void set(HttpServletResponse response, String key, String value, int expire, String path, String domain) {
        Cookie cookie = new Cookie(key, value);
        cookie.setMaxAge(Math.max(expire, -1));
        if (path != null) {
            cookie.setPath(path);
        } else {
            cookie.setPath("/");
        }
        if (domain != null && !"localhost".equals(domain)) {
            cookie.setDomain(domain);
        }
        response.addCookie(cookie);
    }

    public static void set(HttpServletResponse response, String key, String value, Date expire) {
        CookiesExt.set(response, key, value, expire, null, null);
    }

    public static void set(HttpServletResponse response, String key, String value, Date expire, String path) {
        CookiesExt.set(response, key, value, expire, path, null);
    }

    public static void set(HttpServletResponse response, String key, String value, Date expire, String path, String domain) {
        CookiesExt.set(response, key, value, (int)(Dates.intervalMs((Date)expire, (Date)new Date()) / 1000L), path, domain);
    }

    public static void sets(HttpServletResponse response, Map<String, String> map) {
        CookiesExt.sets(response, map, 86400, null, null);
    }

    public static void sets(HttpServletResponse response, Map<String, String> map, int expire) {
        CookiesExt.sets(response, map, expire, null, null);
    }

    public static void sets(HttpServletResponse response, Map<String, String> map, int expire, String path) {
        CookiesExt.sets(response, map, expire, path, null);
    }

    public static void sets(HttpServletResponse response, Map<String, String> map, Date expire) {
        CookiesExt.sets(response, map, expire, null, null);
    }

    public static void sets(HttpServletResponse response, Map<String, String> map, Date expire, String path) {
        CookiesExt.sets(response, map, expire, path, null);
    }

    public static void sets(HttpServletResponse response, Map<String, String> map, Date expire, String path, String domain) {
        CookiesExt.sets(response, map, (int)(Dates.intervalMs((Date)expire, (Date)new Date()) / 1000L), path, domain);
    }

    public static void sets(HttpServletResponse response, Map<String, String> map, int expire, String path, String domain) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            CookiesExt.set(response, entry.getKey(), entry.getValue(), expire, path, domain);
        }
    }

    public static void delete(HttpServletResponse response, String key) {
        Cookie cookie = new Cookie(key, null);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static void delete(HttpServletResponse response, String ... keys) {
        for (String key : keys) {
            Cookie cookie = new Cookie(key, null);
            cookie.setMaxAge(0);
            cookie.setPath("/");
            response.addCookie(cookie);
        }
    }
}

