/*
 * Decompiled with CFR 0.152.
 */
package com.orion.web.servlet.filter;

import com.orion.lang.utils.Xsses;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssFilter
implements Filter {
    private String applicationContext;
    private final Map<String, String> ignoreFields;

    public XssFilter(String applicationContext) {
        this.applicationContext = applicationContext;
        this.ignoreFields = new HashMap<String, String>();
    }

    public void setApplicationContext(String applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void addIgnoreField(String url, String field) {
        this.ignoreFields.put(url, field);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url = ((HttpServletRequest)request).getRequestURI();
        if (this.ignoreFields.get(url = url.replace(this.applicationContext, "")) != null) {
            chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper((HttpServletRequest)request, this.ignoreFields.get(url)), response);
        } else {
            chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper((HttpServletRequest)request), response);
        }
    }

    public void destroy() {
    }

    static class XssHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final Set<String> currentIgnoreField;

        XssHttpServletRequestWrapper(HttpServletRequest servletRequest) {
            super(servletRequest);
            this.currentIgnoreField = Collections.emptySet();
        }

        XssHttpServletRequestWrapper(HttpServletRequest servletRequest, String field) {
            super(servletRequest);
            String[] fieldArr;
            this.currentIgnoreField = new HashSet<String>();
            for (String f : fieldArr = field.split(",")) {
                this.currentIgnoreField.add(f.trim());
            }
        }

        public String[] getParameterValues(String parameter) {
            String[] values = super.getParameterValues(parameter);
            if (values == null) {
                return null;
            }
            int count = values.length;
            String[] encodedValues = new String[count];
            for (int i = 0; i < count; ++i) {
                encodedValues[i] = this.currentIgnoreField.contains(parameter) ? Xsses.clean((String)values[i]) : values[i];
            }
            return encodedValues;
        }

        public String getParameter(String parameter) {
            String value = super.getParameter(parameter);
            if (value == null) {
                return null;
            }
            if (this.currentIgnoreField.contains(parameter)) {
                return Xsses.clean((String)value);
            }
            return value;
        }

        public String getHeader(String name) {
            String value = super.getHeader(name);
            if (value == null) {
                return null;
            }
            return Xsses.clean((String)value);
        }
    }
}

