/*
 * Decompiled with CFR 0.152.
 */
package com.orion.spring;

import com.orion.lang.define.Console;
import com.orion.lang.define.collect.MutableHashMap;
import com.orion.lang.define.collect.MutableHashSet;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.ext.PropertiesExt;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;

public class EnvProperties {
    private static PropertiesExt propertiesExt;

    private EnvProperties() {
    }

    public static String getValue(String key) {
        return propertiesExt.getValue(key);
    }

    public static String getValue(String key, String def) {
        return propertiesExt.getValue(key, def);
    }

    public static MutableHashMap<Object, Object> getValues() {
        return propertiesExt.getValues();
    }

    public static MutableHashSet<Object> getKeys() {
        return propertiesExt.getKeys();
    }

    public static void setValue(String key, String value) {
        propertiesExt.setValue(key, value);
    }

    public static Properties getProperties() {
        return propertiesExt.getProperties();
    }

    public static PropertiesExt setProperties(Properties properties) {
        return propertiesExt.setProperties(properties);
    }

    public static PropertiesExt getPropertiesExt() {
        return propertiesExt;
    }

    public static PropertiesExt setPropertiesExt(PropertiesExt propertiesExt) {
        EnvProperties.propertiesExt = propertiesExt;
        return EnvProperties.propertiesExt;
    }

    private static class InitializeProperties
    implements InitializingBean {
        private final String propertiesPath;

        public InitializeProperties(String propertiesPath) {
            this.propertiesPath = propertiesPath;
            Console.log((Object)("EnvProperties: load env properties file: " + propertiesPath));
        }

        public void afterPropertiesSet() {
            try {
                propertiesExt = new PropertiesExt(this.propertiesPath);
                Console.log((Object)"EnvProperties: load env properties success...");
            }
            catch (Exception e) {
                Console.error((Object)"EnvProperties: load env properties fail...");
                throw Exceptions.init((Throwable)e);
            }
        }
    }
}

