/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.time.cron;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.time.Dates;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;

public class Cron
implements Serializable {
    private static final long serialVersionUID = -1403493223L;
    protected static final int SECOND = 0;
    protected static final int MINUTE = 1;
    protected static final int HOUR = 2;
    protected static final int DAY_OF_MONTH = 3;
    protected static final int MONTH = 4;
    protected static final int DAY_OF_WEEK = 5;
    protected static final int YEAR = 6;
    protected static final int ALL_SPEC_INT = 99;
    protected static final int NO_SPEC_INT = 98;
    protected static final Integer ALL_SPEC = 99;
    protected static final Integer NO_SPEC = 98;
    protected static final Map<String, Integer> MONTH_MAP = new HashMap<String, Integer>(16);
    protected static final Map<String, Integer> WEEK_DAY_MAP = new HashMap<String, Integer>(16);
    private final String cronExpression;
    private TimeZone timeZone;
    protected transient TreeSet<Integer> seconds;
    protected transient TreeSet<Integer> minutes;
    protected transient TreeSet<Integer> hours;
    protected transient TreeSet<Integer> daysOfMonth;
    protected transient TreeSet<Integer> months;
    protected transient TreeSet<Integer> daysOfWeek;
    protected transient TreeSet<Integer> years;
    protected transient boolean lastDayOfWeek;
    protected transient int nthDayOfWeek;
    protected transient boolean lastDayOfMonth;
    protected transient boolean nearestWeekday;
    protected transient int lastDayOffset;
    protected transient boolean expressionParsed;
    public static final int MAX_YEAR;

    public Cron(String cronExpression) {
        Valid.notBlank(cronExpression, "cron expression not be empty", new Object[0]);
        this.cronExpression = cronExpression.trim().toUpperCase(Locale.US);
        this.buildExpression(this.cronExpression);
    }

    public static Cron of(String cronExpression) {
        return new Cron(cronExpression);
    }

    public boolean isSatisfiedBy(Date date) {
        Calendar testDateCal = Calendar.getInstance(this.getTimeZone());
        testDateCal.setTime(date);
        testDateCal.set(14, 0);
        Date originalDate = testDateCal.getTime();
        testDateCal.add(13, -1);
        Date timeAfter = this.getTimeAfter(testDateCal.getTime());
        return timeAfter != null && timeAfter.equals(originalDate);
    }

    public Date getNextValidTimeAfter(Date date) {
        return this.getTimeAfter(date);
    }

    public Date getNextInvalidTimeAfter(Date date) {
        Date newDate;
        long difference = 1000L;
        Calendar adjustCal = Calendar.getInstance(this.getTimeZone());
        adjustCal.setTime(date);
        adjustCal.set(14, 0);
        Date lastDate = adjustCal.getTime();
        while (difference == 1000L && (newDate = this.getTimeAfter(lastDate)) != null) {
            difference = newDate.getTime() - lastDate.getTime();
            if (difference != 1000L) continue;
            lastDate = newDate;
        }
        return new Date(lastDate.getTime() + 1000L);
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getExpressionSummary() {
        return "seconds: " + this.getExpressionSetSummary(this.seconds) + "\n" + "minutes: " + this.getExpressionSetSummary(this.minutes) + "\n" + "hours: " + this.getExpressionSetSummary(this.hours) + "\n" + "daysOfMonth: " + this.getExpressionSetSummary(this.daysOfMonth) + "\n" + "months: " + this.getExpressionSetSummary(this.months) + "\n" + "daysOfWeek: " + this.getExpressionSetSummary(this.daysOfWeek) + "\n" + "lastDayOfWeek: " + this.lastDayOfWeek + "\n" + "nearestWeekday: " + this.nearestWeekday + "\n" + "nthDayOfWeek: " + this.nthDayOfWeek + "\n" + "lastDayOfMonth: " + this.lastDayOfMonth + "\n" + "years: " + this.getExpressionSetSummary(this.years) + "\n";
    }

    public String toString() {
        return this.cronExpression;
    }

    protected void buildExpression(String expression) {
        this.expressionParsed = true;
        try {
            boolean dayOfWSpec;
            int exprOn;
            if (this.seconds == null) {
                this.seconds = new TreeSet();
            }
            if (this.minutes == null) {
                this.minutes = new TreeSet();
            }
            if (this.hours == null) {
                this.hours = new TreeSet();
            }
            if (this.daysOfMonth == null) {
                this.daysOfMonth = new TreeSet();
            }
            if (this.months == null) {
                this.months = new TreeSet();
            }
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new TreeSet();
            }
            if (this.years == null) {
                this.years = new TreeSet();
            }
            StringTokenizer exprTokens = new StringTokenizer(expression, " \t", false);
            for (exprOn = 0; exprTokens.hasMoreTokens() && exprOn <= 6; ++exprOn) {
                String expr = exprTokens.nextToken().trim();
                if (exprOn == 3 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.contains(",")) {
                    throw Exceptions.parseCron("support for specifying 'L' and 'LW' with other days of the month is not implemented");
                }
                if (exprOn == 5 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.contains(",")) {
                    throw Exceptions.parseCron("support for specifying 'L' with other days of the week is not implemented");
                }
                if (exprOn == 5 && expr.indexOf(35) != -1 && expr.indexOf(35, expr.indexOf(35) + 1) != -1) {
                    throw Exceptions.parseCron("support for specifying multiple \"nth\" days is not implemented.");
                }
                StringTokenizer vTok = new StringTokenizer(expr, ",");
                while (vTok.hasMoreTokens()) {
                    String v = vTok.nextToken();
                    this.storeExpressionVal(0, v, exprOn);
                }
            }
            if (exprOn <= 5) {
                throw Exceptions.parseCron("unexpected end of expression.", expression.length());
            }
            if (exprOn <= 6) {
                this.storeExpressionVal(0, "*", 6);
            }
            TreeSet<Integer> dow = this.getSet(5);
            TreeSet<Integer> dom = this.getSet(3);
            boolean dayOfMSpec = !dom.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !dow.contains(NO_SPEC);
            if (!(dayOfMSpec && !dayOfWSpec || dayOfWSpec && !dayOfMSpec)) {
                throw Exceptions.parseCron("support for specifying both a day of week AND a day-of-month parameter is not implemented.", 0);
            }
        }
        catch (Exception e) {
            throw Exceptions.parseCron("illegal cron expression format (" + e.toString() + ")", 0);
        }
    }

    protected int storeExpressionVal(int pos, String s, int type) {
        int val;
        int incr = 0;
        int i = this.skipWhiteSpace(pos, s);
        if (i >= s.length()) {
            return i;
        }
        char c = s.charAt(i);
        if (!(c < 'A' || c > 'Z' || s.equals("L") || s.equals("LW") || s.matches("^L-[0-9]*[W]?"))) {
            int eval;
            int sval;
            block42: {
                String sub = s.substring(i, i + 3);
                sval = -1;
                eval = -1;
                if (type == 4) {
                    sval = this.getMonthNumber(sub) + 1;
                    if (sval <= 0) {
                        throw Exceptions.parseCron("invalid month value: '" + sub + "'", i);
                    }
                    if (s.length() > i + 3 && (c = s.charAt(i + 3)) == '-' && (eval = this.getMonthNumber(sub = s.substring(i += 4, i + 3)) + 1) <= 0) {
                        throw Exceptions.parseCron("invalid month value: '" + sub + "'", i);
                    }
                } else if (type == 5) {
                    sval = this.getDayOfWeekNumber(sub);
                    if (sval < 0) {
                        throw Exceptions.parseCron("invalid day of week value: '" + sub + "'", i);
                    }
                    if (s.length() > i + 3) {
                        c = s.charAt(i + 3);
                        if (c == '-') {
                            if ((eval = this.getDayOfWeekNumber(sub = s.substring(i += 4, i + 3))) < 0) {
                                throw Exceptions.parseCron("invalid day of week value: '" + sub + "'", i);
                            }
                        } else {
                            if (c == '#') {
                                try {
                                    this.nthDayOfWeek = Integer.parseInt(s.substring(i += 4));
                                    if (this.nthDayOfWeek < 1 || this.nthDayOfWeek > 5) {
                                        throw Exceptions.runtime();
                                    }
                                    break block42;
                                }
                                catch (Exception e) {
                                    throw Exceptions.parseCron("A numeric value between 1 and 5 must follow the '#' option", i);
                                }
                            }
                            if (c == 'L') {
                                this.lastDayOfWeek = true;
                                ++i;
                            }
                        }
                    }
                } else {
                    throw Exceptions.parseCron("illegal characters for this position: '" + sub + "'", i);
                }
            }
            if (eval != -1) {
                incr = 1;
            }
            this.addToSet(sval, eval, incr, type);
            return i + 3;
        }
        if (c == '?') {
            int val2;
            if (++i + 1 < s.length() && s.charAt(i) != ' ' && s.charAt(i + 1) != '\t') {
                throw Exceptions.parseCron("Illegal character after '?': " + s.charAt(i), i);
            }
            if (type != 5 && type != 3) {
                throw Exceptions.parseCron("'?' can only be specified for Day-of-Month or day of week.", i);
            }
            if (type == 5 && !this.lastDayOfMonth && (val2 = this.daysOfMonth.last().intValue()) == 98) {
                throw Exceptions.parseCron("'?' can only be specified for Day-of-Month -OR- day of week.", i);
            }
            this.addToSet(98, -1, 0, type);
            return i;
        }
        if (c == '*' || c == '/') {
            if (c == '*' && i + 1 >= s.length()) {
                this.addToSet(99, -1, incr, type);
                return i + 1;
            }
            if (c == '/' && (i + 1 >= s.length() || s.charAt(i + 1) == ' ' || s.charAt(i + 1) == '\t')) {
                throw Exceptions.parseCron("'/' must be followed by an integer.", i);
            }
            if (c == '*') {
                ++i;
            }
            if ((c = s.charAt(i)) == '/') {
                if (++i >= s.length()) {
                    throw Exceptions.parseCron("unexpected end of string.", i);
                }
                incr = this.getNumericValue(s, i);
                ++i;
                if (incr > 10) {
                    ++i;
                }
                this.checkIncrementRange(incr, type, i);
            } else {
                incr = 1;
            }
            this.addToSet(99, -1, incr, type);
            return i;
        }
        if (c == 'L') {
            ++i;
            if (type == 3) {
                this.lastDayOfMonth = true;
            }
            if (type == 5) {
                this.addToSet(7, 7, 0, type);
            }
            if (type == 3 && s.length() > i) {
                c = s.charAt(i);
                if (c == '-') {
                    ValueSet vs = this.getValue(0, s, i + 1);
                    this.lastDayOffset = vs.value;
                    if (this.lastDayOffset > 30) {
                        throw Exceptions.parseCron("Offset from last day must be <= 30", i + 1);
                    }
                    i = vs.pos;
                }
                if (s.length() > i && (c = s.charAt(i)) == 'W') {
                    this.nearestWeekday = true;
                    ++i;
                }
            }
            return i;
        }
        if (c >= '0' && c <= '9') {
            val = Integer.parseInt(String.valueOf(c));
            if (++i < s.length()) {
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(val, s, i);
                    val = vs.value;
                    i = vs.pos;
                }
                i = this.checkNext(i, s, val, type);
                return i;
            }
        } else {
            throw Exceptions.parseCron("unexpected character: " + c, i);
        }
        this.addToSet(val, -1, -1, type);
        return i;
    }

    private void checkIncrementRange(int incr, int type, int idxPos) {
        if (incr > 59 && (type == 0 || type == 1)) {
            throw Exceptions.parseCron("increment > 60 : " + incr, idxPos);
        }
        if (incr > 23 && type == 2) {
            throw Exceptions.parseCron("increment > 24 : " + incr, idxPos);
        }
        if (incr > 31 && type == 3) {
            throw Exceptions.parseCron("increment > 31 : " + incr, idxPos);
        }
        if (incr > 7 && type == 5) {
            throw Exceptions.parseCron("increment > 7 : " + incr, idxPos);
        }
        if (incr > 12 && type == 4) {
            throw Exceptions.parseCron("increment > 12 : " + incr, idxPos);
        }
    }

    protected int checkNext(int pos, String s, int val, int type) {
        int end = -1;
        int i = pos;
        if (i >= s.length()) {
            this.addToSet(val, end, -1, type);
            return i;
        }
        char c = s.charAt(pos);
        if (c == 'L') {
            if (type == 5) {
                if (val < 1 || val > 7) {
                    throw Exceptions.parseCron("day of week values must be between 1 and 7", -1);
                }
            } else {
                throw Exceptions.parseCron("'L' option is not valid here. (pos=" + i + ")", i);
            }
            this.lastDayOfWeek = true;
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == 'W') {
            if (type != 3) {
                throw Exceptions.parseCron("'W' option is not valid here. (pos=" + i + ")", i);
            }
            this.nearestWeekday = true;
            if (val > 31) {
                throw Exceptions.parseCron("'W' option does not make sense with values larger than 31 (max number of days in a month)", i);
            }
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == '#') {
            if (type != 5) {
                throw Exceptions.parseCron("'#' option is not valid here. (pos=" + i + ")", i);
            }
            ++i;
            try {
                this.nthDayOfWeek = Integer.parseInt(s.substring(i));
                if (this.nthDayOfWeek < 1 || this.nthDayOfWeek > 5) {
                    throw Exceptions.runtime();
                }
            }
            catch (Exception e) {
                throw Exceptions.parseCron("a numeric value between 1 and 5 must follow the '#' option", i);
            }
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == '-') {
            int v;
            c = s.charAt(++i);
            end = v = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.addToSet(val, end, 1, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = this.getValue(v, s, i);
                end = vs.value;
                i = vs.pos;
            }
            if (i < s.length() && (c = s.charAt(i)) == '/') {
                c = s.charAt(++i);
                int v2 = Integer.parseInt(String.valueOf(c));
                if (++i >= s.length()) {
                    this.addToSet(val, end, v2, type);
                    return i;
                }
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(v2, s, i);
                    int v3 = vs.value;
                    this.addToSet(val, end, v3, type);
                    i = vs.pos;
                    return i;
                }
                this.addToSet(val, end, v2, type);
                return i;
            }
            this.addToSet(val, end, 1, type);
            return i;
        }
        if (c == '/') {
            if (i + 1 >= s.length() || s.charAt(i + 1) == ' ' || s.charAt(i + 1) == '\t') {
                throw Exceptions.parseCron("'/' must be followed by an integer.", i);
            }
            c = s.charAt(++i);
            int v2 = Integer.parseInt(String.valueOf(c));
            if (++i >= s.length()) {
                this.checkIncrementRange(v2, type, i);
                this.addToSet(val, end, v2, type);
                return i;
            }
            c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = this.getValue(v2, s, i);
                int v3 = vs.value;
                this.checkIncrementRange(v3, type, i);
                this.addToSet(val, end, v3, type);
                i = vs.pos;
                return i;
            }
            throw Exceptions.parseCron("unexpected character '" + c + "' after '/'", i);
        }
        this.addToSet(val, end, 0, type);
        return ++i;
    }

    protected String getExpressionSetSummary(Set<Integer> set) {
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Integer> itr = set.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    protected String getExpressionSetSummary(List<Integer> list) {
        if (list.contains(NO_SPEC)) {
            return "?";
        }
        if (list.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Integer> itr = list.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    protected int skipWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t')) {
            ++i;
        }
        return i;
    }

    protected int findNextWhiteSpace(int i, String s) {
        while (i < s.length() && (s.charAt(i) != ' ' || s.charAt(i) != '\t')) {
            ++i;
        }
        return i;
    }

    protected void addToSet(int val, int end, int incr, int type) {
        TreeSet<Integer> set = this.getSet(type);
        if (type == 0 || type == 1) {
            if ((val < 0 || val > 59 || end > 59) && val != 99) {
                throw Exceptions.parseCron("minute and second values must be between 0 and 59", -1);
            }
        } else if (type == 2) {
            if ((val < 0 || val > 23 || end > 23) && val != 99) {
                throw Exceptions.parseCron("hour values must be between 0 and 23", -1);
            }
        } else if (type == 3) {
            if ((val < 1 || val > 31 || end > 31) && val != 99 && val != 98) {
                throw Exceptions.parseCron("day of month values must be between 1 and 31", -1);
            }
        } else if (type == 4) {
            if ((val < 1 || val > 12 || end > 12) && val != 99) {
                throw Exceptions.parseCron("month values must be between 1 and 12", -1);
            }
        } else if (type == 5 && (val == 0 || val > 7 || end > 7) && val != 99 && val != 98) {
            throw Exceptions.parseCron("day of week values must be between 1 and 7", -1);
        }
        if ((incr == 0 || incr == -1) && val != 99) {
            if (val != -1) {
                set.add(val);
            } else {
                set.add(NO_SPEC);
            }
            return;
        }
        int startAt = val;
        int stopAt = end;
        if (val == 99 && incr <= 0) {
            incr = 1;
            set.add(ALL_SPEC);
        }
        if (type == 0 || type == 1) {
            if (stopAt == -1) {
                stopAt = 59;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 2) {
            if (stopAt == -1) {
                stopAt = 23;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 3) {
            if (stopAt == -1) {
                stopAt = 31;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 4) {
            if (stopAt == -1) {
                stopAt = 12;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 5) {
            if (stopAt == -1) {
                stopAt = 7;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 6) {
            if (stopAt == -1) {
                stopAt = MAX_YEAR;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1970;
            }
        }
        int max = -1;
        if (stopAt < startAt) {
            switch (type) {
                case 0: {
                    max = 60;
                    break;
                }
                case 1: {
                    max = 60;
                    break;
                }
                case 2: {
                    max = 24;
                    break;
                }
                case 4: {
                    max = 12;
                    break;
                }
                case 5: {
                    max = 7;
                    break;
                }
                case 3: {
                    max = 31;
                    break;
                }
                case 6: {
                    throw Exceptions.argument("start year must be less than stop year");
                }
                default: {
                    throw Exceptions.argument("unexpected type encountered");
                }
            }
            stopAt += max;
        }
        for (int i = startAt; i <= stopAt; i += incr) {
            if (max == -1) {
                set.add(i);
                continue;
            }
            int i2 = i % max;
            if (i2 == 0 && (type == 4 || type == 5 || type == 3)) {
                i2 = max;
            }
            set.add(i2);
        }
    }

    TreeSet<Integer> getSet(int type) {
        switch (type) {
            case 0: {
                return this.seconds;
            }
            case 1: {
                return this.minutes;
            }
            case 2: {
                return this.hours;
            }
            case 3: {
                return this.daysOfMonth;
            }
            case 4: {
                return this.months;
            }
            case 5: {
                return this.daysOfWeek;
            }
            case 6: {
                return this.years;
            }
        }
        return null;
    }

    protected ValueSet getValue(int v, String s, int i) {
        char c = s.charAt(i);
        StringBuilder s1 = new StringBuilder(String.valueOf(v));
        while (c >= '0' && c <= '9') {
            s1.append(c);
            if (++i >= s.length()) break;
            c = s.charAt(i);
        }
        ValueSet val = new ValueSet();
        val.pos = i < s.length() ? i : i + 1;
        val.value = Integer.parseInt(s1.toString());
        return val;
    }

    protected int getNumericValue(String s, int i) {
        int endOfVal = this.findNextWhiteSpace(i, s);
        String val = s.substring(i, endOfVal);
        return Integer.parseInt(val);
    }

    protected int getMonthNumber(String s) {
        Integer integer = MONTH_MAP.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    protected int getDayOfWeekNumber(String s) {
        Integer integer = WEEK_DAY_MAP.get(s);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    public Date getTimeAfter(Date afterTime) {
        GregorianCalendar cl = new GregorianCalendar(this.getTimeZone());
        afterTime = new Date(afterTime.getTime() + 1000L);
        cl.setTime(afterTime);
        cl.set(14, 0);
        boolean gotOne = false;
        while (!gotOne) {
            boolean dayOfWSpec;
            if (cl.get(1) > 2999) {
                return null;
            }
            int t = 0;
            int sec = cl.get(13);
            int min = cl.get(12);
            SortedSet<Integer> st = this.seconds.tailSet(sec);
            if (st.size() != 0) {
                sec = st.first();
            } else {
                sec = this.seconds.first();
                cl.set(12, ++min);
            }
            cl.set(13, sec);
            min = cl.get(12);
            int hr = cl.get(11);
            t = -1;
            st = this.minutes.tailSet(min);
            if (st.size() != 0) {
                t = min;
                min = st.first();
            } else {
                min = this.minutes.first();
                ++hr;
            }
            if (min != t) {
                cl.set(13, 0);
                cl.set(12, min);
                this.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(12, min);
            hr = cl.get(11);
            int day = cl.get(5);
            t = -1;
            st = this.hours.tailSet(hr);
            if (st.size() != 0) {
                t = hr;
                hr = st.first();
            } else {
                hr = this.hours.first();
                ++day;
            }
            if (hr != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(5, day);
                this.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(11, hr);
            day = cl.get(5);
            int mon = cl.get(2) + 1;
            t = -1;
            int tmon = mon;
            boolean dayOfMSpec = !this.daysOfMonth.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !this.daysOfWeek.contains(NO_SPEC);
            if (dayOfMSpec && !dayOfWSpec) {
                int dow;
                int ldom;
                st = this.daysOfMonth.tailSet(day);
                if (this.lastDayOfMonth) {
                    if (!this.nearestWeekday) {
                        t = day;
                        day = this.getLastDayOfMonth(mon, cl.get(1));
                        if (t > (day -= this.lastDayOffset)) {
                            if (++mon > 12) {
                                mon = 1;
                                tmon = 3333;
                                ((Calendar)cl).add(1, 1);
                            }
                            day = 1;
                        }
                    } else {
                        t = day;
                        day = this.getLastDayOfMonth(mon, cl.get(1));
                        Calendar tcal = Calendar.getInstance(this.getTimeZone());
                        tcal.set(13, 0);
                        tcal.set(12, 0);
                        tcal.set(11, 0);
                        tcal.set(5, day -= this.lastDayOffset);
                        tcal.set(2, mon - 1);
                        tcal.set(1, cl.get(1));
                        ldom = this.getLastDayOfMonth(mon, cl.get(1));
                        dow = tcal.get(7);
                        if (dow == 7 && day == 1) {
                            day += 2;
                        } else if (dow == 7) {
                            --day;
                        } else if (dow == 1 && day == ldom) {
                            day -= 2;
                        } else if (dow == 1) {
                            ++day;
                        }
                        tcal.set(13, sec);
                        tcal.set(12, min);
                        tcal.set(11, hr);
                        tcal.set(5, day);
                        tcal.set(2, mon - 1);
                        Date nTime = tcal.getTime();
                        if (nTime.before(afterTime)) {
                            day = 1;
                            ++mon;
                        }
                    }
                } else if (this.nearestWeekday) {
                    t = day;
                    day = this.daysOfMonth.first();
                    Calendar tcal = Calendar.getInstance(this.getTimeZone());
                    tcal.set(13, 0);
                    tcal.set(12, 0);
                    tcal.set(11, 0);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    tcal.set(1, cl.get(1));
                    ldom = this.getLastDayOfMonth(mon, cl.get(1));
                    dow = tcal.get(7);
                    if (dow == 7 && day == 1) {
                        day += 2;
                    } else if (dow == 7) {
                        --day;
                    } else if (dow == 1 && day == ldom) {
                        day -= 2;
                    } else if (dow == 1) {
                        ++day;
                    }
                    tcal.set(13, sec);
                    tcal.set(12, min);
                    tcal.set(11, hr);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    Date nTime = tcal.getTime();
                    if (nTime.before(afterTime)) {
                        day = this.daysOfMonth.first();
                        ++mon;
                    }
                } else if (st.size() != 0) {
                    int lastDay;
                    t = day;
                    day = st.first();
                    if (day > (lastDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        day = this.daysOfMonth.first();
                        ++mon;
                    }
                } else {
                    day = this.daysOfMonth.first();
                    ++mon;
                }
                if (day != t || mon != tmon) {
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    cl.set(5, day);
                    cl.set(2, mon - 1);
                    continue;
                }
            } else if (dayOfWSpec && !dayOfMSpec) {
                int daysToAdd;
                int cDow;
                if (this.lastDayOfWeek) {
                    int lDay;
                    int dow = this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    }
                    if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    while (day + daysToAdd + 7 <= lDay) {
                        daysToAdd += 7;
                    }
                    day += daysToAdd;
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else if (this.nthDayOfWeek != 0) {
                    int dow = this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    } else if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    boolean dayShifted = false;
                    if (daysToAdd > 0) {
                        dayShifted = true;
                    }
                    int weekOfMonth = (day += daysToAdd) / 7;
                    if (day % 7 > 0) {
                        ++weekOfMonth;
                    }
                    if ((daysToAdd = (this.nthDayOfWeek - weekOfMonth) * 7) < 0 || (day += daysToAdd) > this.getLastDayOfMonth(mon, cl.get(1))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0 || dayShifted) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else {
                    int lDay;
                    int cDow2 = cl.get(7);
                    int dow = this.daysOfWeek.first();
                    st = this.daysOfWeek.tailSet(cDow2);
                    if (st.size() > 0) {
                        dow = st.first();
                    }
                    daysToAdd = 0;
                    if (cDow2 < dow) {
                        daysToAdd = dow - cDow2;
                    }
                    if (cDow2 > dow) {
                        daysToAdd = dow + (7 - cDow2);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day + daysToAdd);
                        cl.set(2, mon - 1);
                        continue;
                    }
                }
            } else {
                throw Exceptions.unsupported("support for specifying both a day of week AND a day-of-month parameter is not implemented.");
            }
            cl.set(5, day);
            mon = cl.get(2) + 1;
            int year = cl.get(1);
            t = -1;
            if (year > MAX_YEAR) {
                return null;
            }
            st = this.months.tailSet(mon);
            if (st.size() != 0) {
                t = mon;
                mon = st.first();
            } else {
                mon = this.months.first();
                ++year;
            }
            if (mon != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, mon - 1);
                cl.set(1, year);
                continue;
            }
            cl.set(2, mon - 1);
            year = cl.get(1);
            t = -1;
            st = this.years.tailSet(year);
            if (st.size() == 0) {
                return null;
            }
            t = year;
            year = st.first();
            if (year != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, 0);
                cl.set(1, year);
                continue;
            }
            cl.set(1, year);
            gotOne = true;
        }
        return cl.getTime();
    }

    protected void setCalendarHour(Calendar cal, int hour) {
        cal.set(11, hour);
        if (cal.get(11) != hour && hour != 24) {
            cal.set(11, hour + 1);
        }
    }

    protected int getLastDayOfMonth(int monthNum, int year) {
        return Dates.getMonthLastDay(year, monthNum);
    }

    static {
        MONTH_MAP.put("JAN", 0);
        MONTH_MAP.put("FEB", 1);
        MONTH_MAP.put("MAR", 2);
        MONTH_MAP.put("APR", 3);
        MONTH_MAP.put("MAY", 4);
        MONTH_MAP.put("JUN", 5);
        MONTH_MAP.put("JUL", 6);
        MONTH_MAP.put("AUG", 7);
        MONTH_MAP.put("SEP", 8);
        MONTH_MAP.put("OCT", 9);
        MONTH_MAP.put("NOV", 10);
        MONTH_MAP.put("DEC", 11);
        WEEK_DAY_MAP.put("SUN", 1);
        WEEK_DAY_MAP.put("MON", 2);
        WEEK_DAY_MAP.put("TUE", 3);
        WEEK_DAY_MAP.put("WED", 4);
        WEEK_DAY_MAP.put("THU", 5);
        WEEK_DAY_MAP.put("FRI", 6);
        WEEK_DAY_MAP.put("SAT", 7);
        MAX_YEAR = Calendar.getInstance().get(1) + 100;
    }

    static class ValueSet {
        public int value;
        public int pos;

        ValueSet() {
        }
    }
}

