/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.time.ago;

import com.orion.lang.utils.time.DateStream;
import com.orion.lang.utils.time.Dates;
import com.orion.lang.utils.time.ago.Ago;
import com.orion.lang.utils.time.ago.DateAgoHint;
import java.util.Date;

public class DateAgo1
extends Ago {
    private boolean strict;

    public DateAgo1(Date target) {
        super(target);
    }

    public DateAgo1(Date source, Date target) {
        super(source, target);
    }

    public DateAgo1(Date target, DateAgoHint hint) {
        super(target, hint);
    }

    public DateAgo1(Date source, Date target, DateAgoHint hint) {
        super(source, target, hint);
    }

    public static DateAgo1 of(Date target) {
        return new DateAgo1(target);
    }

    public static DateAgo1 of(Date source, Date target) {
        return new DateAgo1(source, target);
    }

    public DateAgo1 strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    @Override
    public String ago() {
        if (this.hint == null) {
            this.hint = new DateAgoHint();
        }
        DateStream ss = Dates.stream(this.source);
        int sYear = ss.getYear();
        int sMonth = ss.getMonth();
        int sDay = ss.getDay();
        int sHour = ss.getHour();
        int sMinute = ss.getMinute();
        int sSecond = ss.getSecond();
        DateStream ts = Dates.stream(this.target);
        int tYear = ts.getYear();
        int tMonth = ts.getMonth();
        int tDay = ts.getDay();
        int tHour = ts.getHour();
        int tMinute = ts.getMinute();
        int tSecond = ts.getSecond();
        if (this.target.before(this.source)) {
            if (sYear > tYear) {
                if (sYear - tYear > 10) {
                    return this.hint.longAgo;
                }
                if (sYear - tYear == 1) {
                    if (this.strict) {
                        if (sMonth > tMonth) {
                            return 1 + this.hint.yearAgo;
                        }
                        if (sMonth == tMonth) {
                            if (sDay > tDay) {
                                return 1 + this.hint.yearAgo;
                            }
                            return 11 + this.hint.monthAgo;
                        }
                        return 12 - tMonth + sMonth + this.hint.monthAgo;
                    }
                    return this.hint.lastYear;
                }
                return sYear - tYear + this.hint.yearAgo;
            }
            if (sMonth > tMonth) {
                if (sMonth - tMonth == 1 && this.strict) {
                    if (sDay >= tDay) {
                        return 1 + this.hint.monthAgo;
                    }
                    return Dates.getMonthLastDay(sYear, sMonth) - (tDay - sDay) + this.hint.dayAgo;
                }
                return sMonth - tMonth + this.hint.monthAgo;
            }
            if (sDay > tDay) {
                if (this.strict) {
                    if (sDay - tDay == 1) {
                        if (sHour >= tHour) {
                            return this.hint.yesterday;
                        }
                        return 24 - tHour + sHour + this.hint.hourAgo;
                    }
                    if (sDay - tDay == 2) {
                        return this.hint.beforeYesterday;
                    }
                    return sDay - tDay + this.hint.dayAgo;
                }
                if (sDay - tDay == 1) {
                    return this.hint.yesterday;
                }
                if (sDay - tDay == 2) {
                    return this.hint.beforeYesterday;
                }
                return sDay - tDay + this.hint.dayAgo;
            }
            if (sHour > tHour) {
                if (sHour - tHour == 1 && this.strict) {
                    if (sMinute >= tMinute) {
                        return 1 + this.hint.hourAgo;
                    }
                    return 60 - tMinute + sMinute + this.hint.minuteAgo;
                }
                return sHour - tHour + this.hint.hourAgo;
            }
            if (sMinute > tMinute) {
                return sMinute - tMinute + this.hint.minuteAgo;
            }
            if (this.strict) {
                return sSecond - tSecond + this.hint.secondAgo;
            }
            return this.hint.justNow;
        }
        if (this.target.after(this.source)) {
            if (sYear < tYear) {
                if (tYear - sYear > 10) {
                    return this.hint.longFuture;
                }
                if (tYear - sYear == 1) {
                    if (this.strict) {
                        if (sMonth > tMonth) {
                            return 12 + tMonth - sMonth + this.hint.monthFuture;
                        }
                        if (sMonth == tMonth) {
                            if (tDay > sDay) {
                                return 1 + this.hint.yearFuture;
                            }
                            return 11 + this.hint.monthFuture;
                        }
                        return 1 + this.hint.yearFuture;
                    }
                    return this.hint.nextYear;
                }
                return tYear - sYear + this.hint.yearFuture;
            }
            if (sMonth < tMonth) {
                if (tMonth - sMonth == 1 && this.strict) {
                    if (sDay >= tDay) {
                        return Dates.getMonthLastDay(sYear, sMonth) + (tDay - sDay) + this.hint.dayFuture;
                    }
                    return 1 + this.hint.monthFuture;
                }
                return tMonth - sMonth + this.hint.monthFuture;
            }
            if (sDay < tDay) {
                if (tDay - sDay == 1 && this.strict) {
                    if (tHour < sHour) {
                        return 24 - sHour + tHour + this.hint.hourFuture;
                    }
                    return this.hint.tomorrow;
                }
                if (tDay - sDay == 1) {
                    return this.hint.tomorrow;
                }
                if (tDay - sDay == 2) {
                    return this.hint.afterTomorrow;
                }
                return tDay - sDay + this.hint.dayFuture;
            }
            if (sHour < tHour) {
                if (tHour - sHour == 1 && this.strict) {
                    if (tMinute < sMinute) {
                        return 60 - sMinute + tMinute + this.hint.minuteFuture;
                    }
                    return 1 + this.hint.hourFuture;
                }
                return tHour - sHour + this.hint.hourFuture;
            }
            if (sMinute < tMinute) {
                return tMinute - sMinute + this.hint.minuteFuture;
            }
            if (this.strict) {
                return tSecond - sSecond + this.hint.secondFuture;
            }
            return this.hint.moment;
        }
        return this.strict ? 0 + this.hint.secondAgo : this.hint.now;
    }
}

