/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.time;

import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.convert.Converts;
import com.orion.lang.utils.time.BaseDates;
import com.orion.lang.utils.time.DateStream;
import com.orion.lang.utils.time.Dates8;
import com.orion.lang.utils.time.ago.DateAgo;
import com.orion.lang.utils.time.format.FastDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Dates
extends BaseDates {
    private Dates() {
    }

    public static Date date() {
        return new Date();
    }

    public static Date date(int ms) {
        return new Date((long)ms * 1000L);
    }

    public static Date date(long ms) {
        return new Date(ms);
    }

    public static Date date(Object o) {
        block16: {
            if (o == null) {
                return null;
            }
            if (o instanceof Integer) {
                return Dates.date((long)((Integer)o).intValue() * 1000L);
            }
            if (o instanceof Long) {
                long l = (Long)o;
                if (Dates.isMilli(l)) {
                    return Dates.date(l);
                }
                return Dates.date(l * 1000L);
            }
            if (o instanceof byte[] || o instanceof Byte[] || o instanceof short[] || o instanceof Short[] || o instanceof int[] || o instanceof Integer[] || o instanceof long[] || o instanceof Long[] || o instanceof float[] || o instanceof Float[] || o instanceof double[] || o instanceof Double[] || o instanceof char[] || o instanceof Character[] || o instanceof String[]) {
                try {
                    int[] analysis = Converts.toInts(o);
                    if (analysis.length == 3) {
                        return Dates.build(analysis[0], analysis[1], analysis[2]);
                    }
                    if (analysis.length == 6) {
                        return Dates.build(analysis[0], analysis[1], analysis[2], analysis[3], analysis[4], analysis[5]);
                    }
                    if (analysis.length == 7) {
                        return Dates.build(analysis[0], analysis[1], analysis[2], analysis[3], analysis[4], analysis[5], analysis[6]);
                    }
                    break block16;
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (o instanceof Date) {
                return (Date)o;
            }
            if (o instanceof Calendar) {
                return ((Calendar)o).getTime();
            }
            if (o instanceof String) {
                return Dates.parse((String)o);
            }
            if (o instanceof LocalDate) {
                return Dates8.date((LocalDate)o);
            }
            if (o instanceof LocalDateTime) {
                return Dates8.date((LocalDateTime)o);
            }
            if (o instanceof Instant) {
                return Dates8.date((Instant)o);
            }
        }
        return null;
    }

    public static Calendar calendar() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static Calendar calendar(long milliSecond) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(milliSecond);
        return c;
    }

    public static Calendar calendar(Object o) {
        Date date = Dates.date(o);
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static int[] analysis(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return new int[]{c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14)};
    }

    public static Date build(int year, int month, int day) {
        return Dates.build(year, month, day, 0, 0, 0, 0);
    }

    public static Date build(int year, int month, int day, int h, int m, int s) {
        return Dates.build(year, month, day, h, m, s, 0);
    }

    public static Date build(int year, int month, int day, int h, int m, int s, int ms) {
        Calendar c = Dates.calendar();
        c.set(year, month - 1, day, h, m, s);
        if (ms != 0) {
            c.set(14, ms);
        }
        return c.getTime();
    }

    public static String current() {
        return FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public static String current(String pattern) {
        return FastDateFormat.getInstance(pattern).format(new Date());
    }

    public static Date clearHms() {
        return Dates.clearHms(Dates.calendar());
    }

    public static Date clearHms(Date d) {
        return Dates.clearHms(Dates.calendar(d));
    }

    public static Date clearHms(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date dayEnd() {
        return Dates.dayEnd(Dates.calendar());
    }

    public static Date dayEnd(Date d) {
        return Dates.dayEnd(Dates.calendar(d));
    }

    public static Date dayEnd(Calendar c) {
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Date monthFirstDay() {
        return Dates.monthFirstDay(Dates.calendar(), false);
    }

    public static Date monthFirstDay(Date d) {
        return Dates.monthFirstDay(Dates.calendar(d), false);
    }

    public static Date monthFirstDay(Calendar c) {
        return Dates.monthFirstDay(c, false);
    }

    public static Date monthFirstDayHms() {
        return Dates.monthFirstDay(Dates.calendar(), true);
    }

    public static Date monthFirstDayHms(Date d) {
        return Dates.monthFirstDay(Dates.calendar(d), true);
    }

    public static Date monthFirstDayHms(Calendar c) {
        return Dates.monthFirstDay(c, true);
    }

    public static Date monthFirstDay(Date d, boolean clearHms) {
        return Dates.monthFirstDay(Dates.calendar(d), clearHms);
    }

    public static Date monthFirstDay(Calendar c, boolean clearHms) {
        c.set(5, 1);
        if (clearHms) {
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
        }
        return c.getTime();
    }

    public static Date monthLastDay() {
        return Dates.monthLastDay(new Date(), false);
    }

    public static Date monthLastDay(Date d) {
        return Dates.monthLastDay(d, false);
    }

    public static Date monthLastDay(Calendar c) {
        return Dates.monthLastDay(c, false);
    }

    public static Date monthLastDayHms() {
        return Dates.monthLastDay(new Date(), true);
    }

    public static Date monthLastDayHms(Date d) {
        return Dates.monthLastDay(d, true);
    }

    public static Date monthLastDayHms(Calendar c) {
        return Dates.monthLastDay(c, true);
    }

    public static Date monthLastDay(Date d, boolean dayEnd) {
        return Dates.monthLastDay(Dates.calendar(d), dayEnd);
    }

    public static Date monthLastDay(Calendar c, boolean dayEnd) {
        c.set(5, Dates.getMonthLastDay(c.get(1), c.get(2) + 1));
        if (dayEnd) {
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 999);
        }
        return c.getTime();
    }

    public static Date[] getIncrementDayDates(int incr, int times) {
        return Dates.getIncrementDates(null, 5, incr, times);
    }

    public static Date[] getIncrementDayDates(Date d, int incr, int times) {
        return Dates.getIncrementDates(d, 5, incr, times);
    }

    public static Date[] getIncrementHourDates(int incr, int times) {
        return Dates.getIncrementDates(null, 11, incr, times);
    }

    public static Date[] getIncrementHourDates(Date d, int incr, int times) {
        return Dates.getIncrementDates(d, 11, incr, times);
    }

    public static Date[] getIncrementDates(int field, int incr, int times) {
        return Dates.getIncrementDates(null, field, incr, times);
    }

    public static Date[] getIncrementDates(Date d, int field, int incr, int times) {
        Date[] dates = new Date[times];
        Calendar c = Dates.calendar();
        if (d != null) {
            c.setTime(d);
        }
        dates[0] = c.getTime();
        for (int i = 0; i < times - 1; ++i) {
            c.add(field, incr);
            dates[i + 1] = c.getTime();
        }
        return dates;
    }

    public static String format(Date d) {
        return FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss").format(d);
    }

    public static String format(Date d, String pattern) {
        return d == null ? null : FastDateFormat.getInstance(pattern).format(d);
    }

    public static String format(Date d, Locale locale) {
        return FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss", locale).format(d);
    }

    public static String format(Date d, String pattern, Locale locale) {
        return d == null ? null : FastDateFormat.getInstance(pattern, locale).format(d);
    }

    public static String format(Date d, TimeZone timeZone) {
        return FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss", timeZone).format(d);
    }

    public static String format(Date d, String pattern, TimeZone timeZone) {
        return d == null ? null : FastDateFormat.getInstance(pattern, timeZone).format(d);
    }

    public static String format(Date d, TimeZone timeZone, Locale locale) {
        return FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss", timeZone, locale).format(d);
    }

    public static String format(Date d, String pattern, TimeZone timeZone, Locale locale) {
        return d == null ? null : FastDateFormat.getInstance(pattern, timeZone, locale).format(d);
    }

    public static Date parse(String d) {
        if (Strings.isBlank(d)) {
            return null;
        }
        String pattern = null;
        if (d.contains("-")) {
            for (String s : PARSE_PATTERN_GROUP1) {
                if (d.length() != s.length()) continue;
                pattern = s;
                break;
            }
            if (pattern != null) {
                return Dates.parse(d, pattern);
            }
        } else if (d.contains("/")) {
            for (String s : PARSE_PATTERN_GROUP2) {
                if (d.length() != s.length()) continue;
                pattern = s;
                break;
            }
            if (pattern != null) {
                return Dates.parse(d, pattern);
            }
        } else if (Strings.isNumber(d)) {
            for (String s : PARSE_PATTERN_GROUP3) {
                if (d.length() != s.length()) continue;
                pattern = s;
                break;
            }
            if (pattern != null) {
                return Dates.parse(d, pattern);
            }
        } else if (d.split(" ").length == 6) {
            return Dates.parse(d, "EEE MMM dd HH:mm:ss z yyyy", Locale.US);
        }
        return null;
    }

    public static Date parse(String d, String pattern) {
        try {
            return FastDateFormat.getInstance(pattern).parse(d);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parse(String d, String ... patterns) {
        for (String pattern : patterns) {
            Date parse = Dates.parse(d, pattern);
            if (parse == null) continue;
            return parse;
        }
        return null;
    }

    public static Date parse(String d, String pattern, Locale locale) {
        try {
            return FastDateFormat.getInstance(pattern, locale).parse(d);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parse(String d, Locale locale, String ... patterns) {
        for (String pattern : patterns) {
            Date parse = Dates.parse(d, pattern, locale);
            if (parse == null) continue;
            return parse;
        }
        return null;
    }

    public static Date parse(String d, String pattern, TimeZone timeZone) {
        try {
            return FastDateFormat.getInstance(pattern, timeZone).parse(d);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parse(String d, TimeZone timeZone, String ... patterns) {
        for (String pattern : patterns) {
            Date parse = Dates.parse(d, pattern, timeZone);
            if (parse == null) continue;
            return parse;
        }
        return null;
    }

    public static Date parse(String d, String pattern, TimeZone timeZone, Locale locale) {
        try {
            return FastDateFormat.getInstance(pattern, timeZone, locale).parse(d);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parse(String d, TimeZone timeZone, Locale locale, String ... patterns) {
        for (String pattern : patterns) {
            Date parse = Dates.parse(d, pattern, timeZone, locale);
            if (parse == null) continue;
            return parse;
        }
        return null;
    }

    public static Date world(String s) {
        return Dates.parse(s, "EEE MMM dd HH:mm:ss z yyyy", Locale.US);
    }

    public static String hourType() {
        return Dates.hourType(Dates.calendar());
    }

    public static String hourType(Date d) {
        return Dates.hourType(Dates.calendar(d));
    }

    public static String hourType(Calendar c) {
        return Dates.hourType(c.get(11));
    }

    public static String ago(Date target) {
        return Dates.ago(new Date(), target, false, false);
    }

    public static String ago(Date target, boolean vague) {
        return Dates.ago(new Date(), target, vague, false);
    }

    public static String ago(Date target, boolean vague, boolean useWeek) {
        return Dates.ago(new Date(), target, vague, useWeek);
    }

    public static String ago(Date source, Date target) {
        return Dates.ago(source, target, false, false);
    }

    public static String ago(Date source, Date target, boolean vague) {
        return Dates.ago(source, target, vague, false);
    }

    public static String ago(Date source, Date target, boolean vague, boolean useWeek) {
        return new DateAgo(source, target).vague(vague).useWeek(useWeek).ago();
    }

    public static String interval(Date date1, Date date2) {
        return Dates.interval(Dates.intervalMs(date1, date2), false, null, null, null, null);
    }

    public static String interval(Date date1, Date date2, boolean full) {
        return Dates.interval(Dates.intervalMs(date1, date2), full, null, null, null, null);
    }

    public static String interval(Date date1, Date date2, String day, String hour, String minute, String second) {
        return Dates.interval(Dates.intervalMs(date1, date2), false, day, hour, minute, second);
    }

    public static String interval(Date date1, Date date2, boolean full, String day, String hour, String minute, String second) {
        return Dates.interval(Dates.intervalMs(date1, date2), full, day, hour, minute, second);
    }

    public static long intervalMs(Date date1, Date date2) {
        return Math.abs(date1.getTime() - date2.getTime());
    }

    public static long[] intervalAnalysis(Date date1, Date date2) {
        return Dates.intervalAnalysis(Dates.intervalMs(date1, date2));
    }

    public static String convert(String d, String n) {
        Date parse = Dates.parse(d);
        if (parse == null) {
            return "";
        }
        return Dates.format(parse, n);
    }

    public static String convert(String d, String before, String after) {
        return Dates.format(Dates.parse(d, before), after);
    }

    public static boolean isLeapYear() {
        return Dates.isLeapYear(Dates.calendar());
    }

    public static boolean isLeapYear(Date d) {
        return Dates.isLeapYear(Dates.calendar(d));
    }

    public static boolean isLeapYear(Calendar c) {
        return Dates.isLeapYear(c.get(1));
    }

    public static int getMonthLastDay() {
        return Dates.getMonthLastDay(Dates.calendar());
    }

    public static int getMonthLastDay(Date d) {
        return Dates.getMonthLastDay(Dates.calendar(d));
    }

    public static int getMonthLastDay(Calendar c) {
        return Dates.getMonthLastDay(c.get(1), c.get(2) + 1);
    }

    public static int getQuarter() {
        return Dates.getQuarter(Dates.calendar());
    }

    public static int getQuarter(Date d) {
        return Dates.getQuarter(Dates.calendar(d));
    }

    public static int getQuarter(Calendar c) {
        return Dates.getQuarter(c.get(2) + 1);
    }

    public static boolean isAm() {
        return Dates.isAm(Dates.calendar());
    }

    public static boolean isAm(Date d) {
        return Dates.isAm(Dates.calendar(d));
    }

    public static boolean isAm(Calendar c) {
        return 0 == c.get(9);
    }

    public static boolean isPm() {
        return Dates.isPm(Dates.calendar());
    }

    public static boolean isPm(Date d) {
        return Dates.isPm(Dates.calendar(d));
    }

    public static boolean isPm(Calendar c) {
        return 1 == c.get(9);
    }

    public static boolean inFuture(Date date) {
        return Dates.inFuture(date.getTime());
    }

    public static DateStream stream() {
        return new DateStream(new Date());
    }

    public static DateStream stream(TimeZone timeZone) {
        Valid.notNull(timeZone);
        return new DateStream(new Date(), timeZone);
    }

    public static DateStream stream(Locale locale) {
        Valid.notNull(locale);
        return new DateStream(new Date(), locale);
    }

    public static DateStream stream(TimeZone timeZone, Locale locale) {
        Valid.notNull(timeZone);
        Valid.notNull(locale);
        return new DateStream(new Date(), timeZone, locale);
    }

    public static DateStream stream(Date date) {
        Valid.notNull(date);
        return new DateStream(date);
    }

    public static DateStream stream(Date date, TimeZone timeZone) {
        Valid.notNull(date);
        Valid.notNull(timeZone);
        return new DateStream(date, timeZone);
    }

    public static DateStream stream(Date date, Locale locale) {
        Valid.notNull(date);
        Valid.notNull(locale);
        return new DateStream(date, locale);
    }

    public static DateStream stream(Date date, TimeZone timeZone, Locale locale) {
        Valid.notNull(date);
        Valid.notNull(timeZone);
        Valid.notNull(locale);
        return new DateStream(date, timeZone, locale);
    }

    public static DateStream stream(Calendar c) {
        Valid.notNull(c);
        return new DateStream(c);
    }
}

