/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.time;

import com.orion.lang.define.support.CloneSupport;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.time.DateRanges;
import com.orion.lang.utils.time.Dates;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateStream
extends CloneSupport<DateStream>
implements Serializable {
    private static final long serialVersionUID = -21831208940539450L;
    private final Calendar c;

    public DateStream() {
        this.c = Dates.calendar();
    }

    public DateStream(Date date) {
        Valid.notNull(date, "date is null", new Object[0]);
        this.c = Dates.calendar(date);
    }

    public DateStream(Date date, TimeZone timeZone) {
        Valid.notNull(date, "date is null", new Object[0]);
        Valid.notNull(timeZone, "time zone is null", new Object[0]);
        this.c = Calendar.getInstance(timeZone);
        this.c.setTime(date);
    }

    public DateStream(Date date, Locale locale) {
        Valid.notNull(date, "date is null", new Object[0]);
        Valid.notNull(locale, "locale is null", new Object[0]);
        this.c = Calendar.getInstance(locale);
        this.c.setTime(date);
    }

    public DateStream(Date date, TimeZone timeZone, Locale locale) {
        Valid.notNull(date, "date is null", new Object[0]);
        Valid.notNull(timeZone, "time zone is null", new Object[0]);
        Valid.notNull(locale, "locale is null", new Object[0]);
        this.c = Calendar.getInstance(timeZone, locale);
        this.c.setTime(date);
    }

    public DateStream(Calendar c) {
        this.c = c;
    }

    public static DateStream of(Object o) {
        return new DateStream(Dates.date(o));
    }

    public static DateStream of(Object o, TimeZone timeZone) {
        return new DateStream(Dates.date(o), timeZone);
    }

    public static DateStream of(Object o, Locale locale) {
        return new DateStream(Dates.date(o), locale);
    }

    public static DateStream of(Object o, TimeZone timeZone, Locale locale) {
        return new DateStream(Dates.date(o), timeZone, locale);
    }

    public DateStream addYear(int y) {
        this.c.add(1, y);
        return this;
    }

    public DateStream subYear(int y) {
        this.c.add(1, -y);
        return this;
    }

    public DateStream setYear(int y) {
        this.c.set(1, y);
        return this;
    }

    public DateStream addMonth(int m) {
        this.c.add(2, m);
        return this;
    }

    public DateStream subMonth(int m) {
        this.c.add(2, -m);
        return this;
    }

    public DateStream setMonth(int m) {
        this.c.set(2, m - 1);
        return this;
    }

    public DateStream addWeek(int w) {
        this.c.add(4, w);
        return this;
    }

    public DateStream subWeek(int w) {
        this.c.add(4, -w);
        return this;
    }

    public DateStream setWeek(int w) {
        this.c.set(4, w);
        return this;
    }

    public DateStream addDay(int d) {
        this.c.add(5, d);
        return this;
    }

    public DateStream subDay(int d) {
        this.c.add(5, -d);
        return this;
    }

    public DateStream setDay(int d) {
        this.c.set(5, d);
        return this;
    }

    public DateStream addHour(int h) {
        this.c.add(11, h);
        return this;
    }

    public DateStream subHour(int h) {
        this.c.add(11, -h);
        return this;
    }

    public DateStream setHour(int h) {
        this.c.set(11, h);
        return this;
    }

    public DateStream addMinute(int m) {
        this.c.add(12, m);
        return this;
    }

    public DateStream subMinute(int m) {
        this.c.add(12, -m);
        return this;
    }

    public DateStream setMinute(int m) {
        this.c.set(12, m);
        return this;
    }

    public DateStream addSecond(int s) {
        this.c.add(13, s);
        return this;
    }

    public DateStream subSecond(int s) {
        this.c.add(13, -s);
        return this;
    }

    public DateStream setSecond(int s) {
        this.c.set(13, s);
        return this;
    }

    public DateStream addMilliSecond(int ms) {
        this.c.add(14, ms);
        return this;
    }

    public DateStream subMilliSecond(int ms) {
        this.c.add(14, -ms);
        return this;
    }

    public DateStream setMilliSecond(int ms) {
        this.c.set(14, ms);
        return this;
    }

    public DateStream add(int type, int v) {
        this.c.add(type, v);
        return this;
    }

    public DateStream subtract(int type, int v) {
        this.c.add(type, -v);
        return this;
    }

    public DateStream set(int type, int v) {
        this.c.set(type, v);
        return this;
    }

    public DateStream clearHms() {
        Dates.clearHms(this.c);
        return this;
    }

    public DateStream dayEnd() {
        Dates.dayEnd(this.c);
        return this;
    }

    public DateStream monthFirstDay() {
        Dates.monthFirstDay(this.c, false);
        return this;
    }

    public DateStream monthFirstDayHms() {
        Dates.monthFirstDay(this.c, true);
        return this;
    }

    public DateStream monthFirstDay(boolean clearHms) {
        Dates.monthFirstDay(this.c, clearHms);
        return this;
    }

    public DateStream monthLastDay() {
        Dates.monthLastDay(this.c, false);
        return this;
    }

    public DateStream monthLastDayHms() {
        Dates.monthLastDay(this.c, true);
        return this;
    }

    public DateStream monthLastDay(boolean dayEnd) {
        Dates.monthLastDay(this.c, dayEnd);
        return this;
    }

    public String format() {
        return Dates.format(this.c.getTime());
    }

    public String format(String pattern) {
        return Dates.format(this.c.getTime(), pattern);
    }

    public String format(Locale locale) {
        return Dates.format(this.c.getTime(), locale);
    }

    public String format(String pattern, Locale locale) {
        return Dates.format(this.c.getTime(), pattern, locale);
    }

    public String format(TimeZone timeZone) {
        return Dates.format(this.c.getTime(), timeZone);
    }

    public String format(String pattern, TimeZone timeZone) {
        return Dates.format(this.c.getTime(), pattern, timeZone);
    }

    public String format(TimeZone timeZone, Locale locale) {
        return Dates.format(this.c.getTime(), timeZone, locale);
    }

    public String format(String pattern, TimeZone timeZone, Locale locale) {
        return Dates.format(this.c.getTime(), pattern, timeZone, locale);
    }

    public boolean inRange(Date start, Date end) {
        return DateRanges.inRange(start, end, this.c.getTime());
    }

    public boolean notInRange(Date start, Date end) {
        return DateRanges.notInRange(start, end, this.c.getTime());
    }

    public boolean before(Date d) {
        return DateRanges.before(this.c.getTime(), d);
    }

    public boolean after(Date d) {
        return DateRanges.after(this.c.getTime(), d);
    }

    public boolean inFuture() {
        return Dates.inFuture(this.c.getTimeInMillis());
    }

    public boolean isLeapYear() {
        return Dates.isLeapYear(this.c);
    }

    public int getMonthLastDay() {
        return Dates.getMonthLastDay(this.c);
    }

    public int getYear() {
        return this.c.get(1);
    }

    public int getMonth() {
        return this.c.get(2) + 1;
    }

    public int getWeek() {
        return this.c.get(4);
    }

    public int getDay() {
        return this.c.get(5);
    }

    public int getHour() {
        return this.c.get(11);
    }

    public int getMinute() {
        return this.c.get(12);
    }

    public int getSecond() {
        return this.c.get(13);
    }

    public int getMilliSecond() {
        return this.c.get(14);
    }

    public boolean isAm() {
        return 1 == this.c.get(9);
    }

    public boolean isPm() {
        return 0 == this.c.get(9);
    }

    public int getField(int type) {
        return this.c.get(type);
    }

    public Date get() {
        return this.c.getTime();
    }

    public Date date() {
        return this.c.getTime();
    }

    public long milliSecond() {
        return this.c.getTimeInMillis();
    }

    public Calendar calendar() {
        return this.c;
    }

    public String toString() {
        return this.c.toString();
    }
}

