/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.reflect;

import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Urls;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.reflect.Annotations;
import com.orion.lang.utils.reflect.Classes;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageScanner {
    private final Set<Class<?>> classes = new LinkedHashSet();
    private final Set<String> packages = new LinkedHashSet<String>();
    private final Set<URL> resources = new LinkedHashSet<URL>();
    private ClassLoader classLoader = Classes.getCurrentClassLoader();
    private boolean scanAll;

    public PackageScanner(String ... packages) {
        if (Arrays1.isEmpty(packages)) {
            this.scanAll = true;
        } else {
            for (String packageName : packages) {
                if (Strings.isBlank(packageName)) continue;
                this.packages.add(packageName);
            }
        }
    }

    public PackageScanner addPackage(String ... packageName) {
        if (Arrays1.isEmpty(packageName)) {
            return this;
        }
        for (String p : packageName) {
            if (Strings.isBlank(p)) continue;
            this.packages.add(p);
        }
        return this;
    }

    public PackageScanner addResource(URL ... resource) {
        if (Arrays1.isEmpty(resource)) {
            return this;
        }
        for (URL r : resource) {
            if (r == null) continue;
            this.resources.add(r);
        }
        return this;
    }

    public PackageScanner with(Class<?> resourceClass) {
        Valid.notNull(resourceClass, "resourceClass is null", new Object[0]);
        URL r1 = resourceClass.getClassLoader().getResource("");
        URL r2 = resourceClass.getProtectionDomain().getCodeSource().getLocation();
        if (r1 != null) {
            this.resources.add(r1);
        }
        if (r2 != null) {
            this.resources.add(r2);
        }
        return this;
    }

    public PackageScanner all() {
        this.scanAll = true;
        return this;
    }

    public PackageScanner classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public PackageScanner scan() {
        if (this.resources.isEmpty()) {
            throw Exceptions.init("not set scan resources");
        }
        for (URL resource : this.resources) {
            LinkedHashSet<String> classNameSet;
            block6: {
                String protocol;
                block4: {
                    block5: {
                        protocol = resource.getProtocol();
                        classNameSet = new LinkedHashSet<String>();
                        if (!this.scanAll) break block4;
                        if (!"file".equals(protocol)) break block5;
                        this.scanFile(resource, "", classNameSet);
                        break block6;
                    }
                    if (!"jar".equals(protocol)) break block6;
                    this.scanJar(resource, "", classNameSet);
                    break block6;
                }
                for (String p : this.packages) {
                    if ("file".equals(protocol)) {
                        this.scanFile(resource, p, classNameSet);
                        continue;
                    }
                    if (!"jar".equals(protocol)) continue;
                    this.scanJar(resource, p, classNameSet);
                }
            }
            this.loadClasses(classNameSet);
        }
        return this;
    }

    private void scanFile(URL resource, String packageName, Set<String> classNameSet) {
        boolean all = packageName.endsWith(".*");
        if (all) {
            packageName = packageName.substring(0, packageName.length() - 2);
        }
        String packagePath = resource.getPath() + "/" + packageName.replaceAll("\\.", "/");
        this.addFileClass(Files1.getPath(Urls.decode(packagePath)), packageName, all || this.scanAll, classNameSet);
    }

    private void scanJar(URL resource, String packageName, Set<String> classNameSet) {
        boolean all = packageName.endsWith(".*");
        if (all) {
            packageName = packageName.substring(0, packageName.length() - 2);
        }
        try {
            JarURLConnection connection = (JarURLConnection)resource.openConnection();
            if (connection == null) {
                return;
            }
            JarFile jarFile = connection.getJarFile();
            if (jarFile != null) {
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.endsWith(".class") || !this.scanAll && !this.checkJarEntry(packageName, jarEntryName, all)) continue;
                    classNameSet.add(jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", "."));
                }
            }
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime("scan jar file error", e);
        }
    }

    private void addFileClass(String packagePath, String basePackage, boolean all, Set<String> set) {
        File[] files = new File(packagePath).listFiles(file -> file.isFile() && file.getName().endsWith(".class") || all && file.isDirectory());
        if (Arrays1.isEmpty(files)) {
            return;
        }
        for (File file2 : files) {
            String fileName = file2.getName();
            if (file2.isFile()) {
                String className = fileName.substring(0, fileName.lastIndexOf("."));
                if (Strings.isNotEmpty(basePackage)) {
                    className = basePackage + "." + className;
                }
                set.add(className);
                continue;
            }
            String subPackagePath = fileName;
            if (Strings.isNotEmpty(packagePath)) {
                subPackagePath = packagePath + "/" + subPackagePath;
            }
            String subPackageName = fileName;
            if (Strings.isNotEmpty(basePackage)) {
                subPackageName = basePackage + "." + subPackageName;
            }
            this.addFileClass(subPackagePath, subPackageName, all, set);
        }
    }

    private boolean checkJarEntry(String packageName, String entryName, boolean all) {
        if (Strings.isBlank(packageName)) {
            return true;
        }
        if (entryName.startsWith((packageName = packageName.replaceAll("\\.", "/")) + "/") && all) {
            return true;
        }
        return entryName.substring(0, entryName.lastIndexOf("/")).equals(packageName);
    }

    private void loadClasses(Set<String> classNames) {
        for (String className : classNames) {
            Class<?> c = null;
            try {
                c = Class.forName(className, false, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (c == null) continue;
            this.classes.add(c);
        }
    }

    public Set<Class<?>> getImplClass(Class<?> superClass) {
        Valid.notNull(superClass, "super class is null", new Object[0]);
        if (superClass.equals(Object.class)) {
            return this.classes;
        }
        LinkedHashSet impl = new LinkedHashSet();
        for (Class<?> c : this.classes) {
            if (c.equals(superClass) || !Classes.isImplClass(superClass, c)) continue;
            impl.add(c);
        }
        return impl;
    }

    @SafeVarargs
    public final Set<Class<?>> getAnnotatedClass(Class<? extends Annotation> ... annotatedClasses) {
        Valid.notEmpty(annotatedClasses, "annotated classes length is 0", new Object[0]);
        LinkedHashSet annotatedClass = new LinkedHashSet();
        for (Class<?> c : this.classes) {
            if (!Annotations.present(c, annotatedClasses)) continue;
            annotatedClass.add(c);
        }
        return annotatedClass;
    }

    @SafeVarargs
    public final Map<Class<?>, Set<Constructor<?>>> getAnnotatedConstructor(Class<? extends Annotation> ... annotatedClasses) {
        Valid.notEmpty(annotatedClasses, "annotated classes length is 0", new Object[0]);
        HashMap annotatedClass = new HashMap(16);
        for (Class<?> c : this.classes) {
            LinkedHashSet constructors = null;
            for (Constructor<?> constructor : c.getDeclaredConstructors()) {
                if (!Annotations.present(constructor, annotatedClasses)) continue;
                if (constructors == null) {
                    constructors = new LinkedHashSet();
                }
                constructors.add(constructor);
            }
            if (constructors == null) continue;
            annotatedClass.put(c, constructors);
        }
        return annotatedClass;
    }

    @SafeVarargs
    public final Map<Class<?>, Set<Constructor<?>>> getAnnotatedConstructorByAnnotatedClass(Class<? extends Annotation> classAnnotatedClass, Class<? extends Annotation> ... constructorAnnotateClasses) {
        Valid.notNull(classAnnotatedClass, "class annotated class is null", new Object[0]);
        Valid.notEmpty(constructorAnnotateClasses, "constructor annotate classes length is 0", new Object[0]);
        HashMap annotatedClass = new HashMap(16);
        for (Class<?> c : this.classes) {
            boolean hasAnnotated = Annotations.present(c, classAnnotatedClass);
            if (!hasAnnotated) continue;
            LinkedHashSet constructors = null;
            for (Constructor<?> constructor : c.getDeclaredConstructors()) {
                if (!Annotations.present(constructor, constructorAnnotateClasses)) continue;
                if (constructors == null) {
                    constructors = new LinkedHashSet();
                }
                constructors.add(constructor);
            }
            if (constructors == null) continue;
            annotatedClass.put(c, constructors);
        }
        return annotatedClass;
    }

    @SafeVarargs
    public final Map<Class<?>, Set<Method>> getAnnotatedMethod(Class<? extends Annotation> ... annotatedClasses) {
        Valid.notEmpty(annotatedClasses, "annotated classes length is 0", new Object[0]);
        HashMap annotatedClass = new HashMap(16);
        for (Class<?> c : this.classes) {
            LinkedHashSet<Method> methods = null;
            for (Method method : c.getDeclaredMethods()) {
                if (!Annotations.present(method, annotatedClasses)) continue;
                if (methods == null) {
                    methods = new LinkedHashSet<Method>();
                }
                methods.add(method);
            }
            if (methods == null) continue;
            annotatedClass.put(c, methods);
        }
        return annotatedClass;
    }

    @SafeVarargs
    public final Map<Class<?>, Set<Method>> getAnnotatedMethodByAnnotatedClass(Class<? extends Annotation> classAnnotatedClass, Class<? extends Annotation> ... methodAnnotateClasses) {
        Valid.notNull(classAnnotatedClass, "class annotated class is null", new Object[0]);
        Valid.notEmpty(methodAnnotateClasses, "method annotated classes length is 0", new Object[0]);
        HashMap annotatedClass = new HashMap(16);
        for (Class<?> c : this.classes) {
            boolean hasAnnotated = Annotations.present(c, classAnnotatedClass);
            if (!hasAnnotated) continue;
            LinkedHashSet<Method> methods = null;
            for (Method method : c.getDeclaredMethods()) {
                if (!Annotations.present(method, methodAnnotateClasses)) continue;
                if (methods == null) {
                    methods = new LinkedHashSet<Method>();
                }
                methods.add(method);
            }
            if (methods == null) continue;
            annotatedClass.put(c, methods);
        }
        return annotatedClass;
    }

    @SafeVarargs
    public final Map<Class<?>, Set<Field>> getAnnotatedField(Class<? extends Annotation> ... annotatedClasses) {
        Valid.notEmpty(annotatedClasses, "annotated classes length is 0", new Object[0]);
        HashMap annotatedClass = new HashMap(16);
        for (Class<?> c : this.classes) {
            LinkedHashSet<Field> fields = null;
            for (Field field : c.getDeclaredFields()) {
                if (!Annotations.present(field, annotatedClasses)) continue;
                if (fields == null) {
                    fields = new LinkedHashSet<Field>();
                }
                fields.add(field);
            }
            if (fields == null) continue;
            annotatedClass.put(c, fields);
        }
        return annotatedClass;
    }

    @SafeVarargs
    public final Map<Class<?>, Set<Field>> getAnnotatedFieldByAnnotatedClass(Class<? extends Annotation> classAnnotatedClass, Class<? extends Annotation> ... fieldAnnotatedClasses) {
        Valid.notNull(classAnnotatedClass, "class annotated class is null", new Object[0]);
        Valid.notEmpty(fieldAnnotatedClasses, "field annotated classes length is 0", new Object[0]);
        HashMap annotatedClass = new HashMap(16);
        for (Class<?> c : this.classes) {
            boolean hasAnnotated = Annotations.present(c, classAnnotatedClass);
            if (!hasAnnotated) continue;
            LinkedHashSet<Field> fields = null;
            for (Field field : c.getDeclaredFields()) {
                if (!Annotations.present(field, fieldAnnotatedClasses)) continue;
                if (fields == null) {
                    fields = new LinkedHashSet<Field>();
                }
                fields.add(field);
            }
            if (fields == null) continue;
            annotatedClass.put(c, fields);
        }
        return annotatedClass;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    public Set<URL> getResources() {
        return this.resources;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

