/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.reflect;

import com.orion.lang.define.collect.ConcurrentReferenceHashMap;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.collect.Lists;
import com.orion.lang.utils.reflect.Fields;
import com.orion.lang.utils.reflect.TypeInfer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Methods {
    protected static final String SETTER_PREFIX = "set";
    protected static final String GETTER_PREFIX = "get";
    protected static final String BOOLEAN_GETTER_PREFIX = "is";
    private static final Map<Class<?>, List<Method>> CLASS_SET_METHOD_CACHE = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private static final Map<Class<?>, List<Method>> CLASS_GET_METHOD_CACHE = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    private Methods() {
    }

    public static Method getGetterMethodByCache(Class<?> clazz, String field) {
        List<Method> methods = Methods.getGetterMethodsByCache(clazz);
        if (methods == null) {
            return null;
        }
        String methodName1 = GETTER_PREFIX + Strings.firstUpper(field);
        for (Method method : methods) {
            if (method.getParameterCount() != 0 || !method.getName().equals(methodName1)) continue;
            return method;
        }
        String methodName2 = BOOLEAN_GETTER_PREFIX + Strings.firstUpper(field);
        for (Method method : methods) {
            if (method.getParameterCount() != 0 || !method.getName().equals(methodName2)) continue;
            return method;
        }
        return null;
    }

    public static Method getSetterMethodByCache(Class<?> clazz, String field) {
        List<Method> methods = Methods.getSetterMethodsByCache(clazz);
        if (methods == null) {
            return null;
        }
        String methodName = SETTER_PREFIX + Strings.firstUpper(field);
        for (Method method : methods) {
            if (method.getParameterCount() != 1 || !method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static List<Method> getGetterMethodsByCache(Class<?> clazz) {
        List<Method> methodList = CLASS_GET_METHOD_CACHE.get(clazz);
        if (methodList == null) {
            methodList = Methods.getGetterMethods(clazz);
            CLASS_GET_METHOD_CACHE.put(clazz, methodList);
        }
        return methodList;
    }

    public static List<Method> getSetterMethodsByCache(Class<?> clazz) {
        List<Method> methodList = CLASS_SET_METHOD_CACHE.get(clazz);
        if (methodList == null) {
            methodList = Methods.getSetterMethods(clazz);
            CLASS_SET_METHOD_CACHE.put(clazz, methodList);
        }
        return methodList;
    }

    public static String getGetterMethodNameByField(Field field) {
        return Methods.getGetterMethodNameByFieldName(field.getName(), field.getType().equals(Boolean.TYPE));
    }

    public static String getGetterMethodNameByFieldName(String fieldName) {
        if (Strings.isBlank(fieldName)) {
            return null;
        }
        return GETTER_PREFIX + Strings.firstUpper(fieldName.trim());
    }

    public static String getGetterMethodNameByFieldName(String fieldName, boolean isBooleanClass) {
        if (Strings.isBlank(fieldName)) {
            return null;
        }
        return (isBooleanClass ? BOOLEAN_GETTER_PREFIX : GETTER_PREFIX) + Strings.firstUpper(fieldName.trim());
    }

    public static String getSetterMethodNameByField(Field field) {
        return SETTER_PREFIX + Strings.firstUpper(field.getName());
    }

    public static String getSetterMethodNameByFieldName(String fieldName) {
        if (Strings.isBlank(fieldName)) {
            return null;
        }
        return SETTER_PREFIX + Strings.firstUpper(fieldName.trim());
    }

    public static List<Method> getGetterMethods(Class<?> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            if ("getClass".equals(method.getName()) || Modifier.isStatic(method.getModifiers()) || method.getParameters().length != 0) continue;
            String name = method.getName();
            if (name.startsWith(GETTER_PREFIX) && name.length() != 3 && !method.getReturnType().equals(Void.TYPE)) {
                Methods.setAccessible(method);
                list.add(method);
                continue;
            }
            if (!method.getName().startsWith(BOOLEAN_GETTER_PREFIX) || name.length() == 2 || !method.getReturnType().equals(Boolean.TYPE)) continue;
            Methods.setAccessible(method);
            list.add(method);
        }
        return list;
    }

    public static List<Method> getSetterMethods(Class<?> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : clazz.getMethods()) {
            String name = method.getName();
            if (!name.startsWith(SETTER_PREFIX) || name.length() == 3 || Modifier.isStatic(method.getModifiers()) || method.getParameters().length != 1) continue;
            Methods.setAccessible(method);
            list.add(method);
        }
        return list;
    }

    public static List<Method> getGetterMethodsByField(Class<?> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        List<Field> fields = Fields.getFields(clazz);
        for (Field field : fields) {
            Method method;
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (field.getType().equals(Boolean.TYPE)) {
                String fieldName = Strings.firstUpper(field.getName());
                method = Methods.getAccessibleMethod(clazz, BOOLEAN_GETTER_PREFIX + fieldName, 0);
                if (method == null) {
                    method = Methods.getAccessibleMethod(clazz, GETTER_PREFIX + fieldName, 0);
                }
            } else {
                method = Methods.getAccessibleMethod(clazz, GETTER_PREFIX + Strings.firstUpper(field.getName()), 0);
            }
            if (method == null) continue;
            list.add(method);
        }
        return list;
    }

    public static List<Method> getSetterMethodsByField(Class<?> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        List<Field> fields = Fields.getFields(clazz);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String methodName = SETTER_PREFIX + Strings.firstUpper(field.getName());
            Method method = Methods.getAccessibleMethod(clazz, methodName, field.getType());
            if (method == null) continue;
            list.add(method);
        }
        return list;
    }

    public static Method getGetterMethodByField(Class<?> clazz, Field field) {
        Method method;
        if (field.getType().equals(Boolean.TYPE)) {
            String fieldName = Strings.firstUpper(field.getName());
            method = Methods.getAccessibleMethod(clazz, BOOLEAN_GETTER_PREFIX + fieldName, 0);
            if (method == null) {
                method = Methods.getAccessibleMethod(clazz, GETTER_PREFIX + fieldName, 0);
            }
        } else {
            String methodName = GETTER_PREFIX + Strings.firstUpper(field.getName());
            method = Methods.getAccessibleMethod(clazz, methodName, 0);
        }
        return method;
    }

    public static Method getGetterMethodByFieldName(Class<?> clazz, String fieldName) {
        if (Strings.isBlank(fieldName)) {
            return null;
        }
        fieldName = Strings.firstUpper(fieldName.trim());
        Method method = Methods.getAccessibleMethod(clazz, GETTER_PREFIX + fieldName, 0);
        if (method == null) {
            method = Methods.getAccessibleMethod(clazz, BOOLEAN_GETTER_PREFIX + fieldName, 0);
        }
        return method;
    }

    public static Method getSetterMethodByField(Class<?> clazz, Field field) {
        String methodName = SETTER_PREFIX + Strings.firstUpper(field.getName());
        return Methods.getAccessibleMethod(clazz, methodName, field.getType());
    }

    public static Method getSetterMethodByFieldName(Class<?> clazz, String fieldName) {
        if (Strings.isBlank(fieldName)) {
            return null;
        }
        fieldName = fieldName.trim();
        String methodName = SETTER_PREFIX + Strings.firstUpper(fieldName);
        return Methods.getAccessibleMethod(clazz, methodName, 1);
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Valid.notNull(clazz, "method class is null", new Object[0]);
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                Methods.setAccessible(method);
                return method;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, int argsNum) {
        Valid.notNull(clazz, "method class is null", new Object[0]);
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != argsNum) continue;
                Methods.setAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName) {
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                Methods.setAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static List<Method> getAccessibleMethods(Class<?> clazz, String methodName, int argsNum) {
        Valid.notNull(clazz, "method class is null", new Object[0]);
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] searchMethods;
            for (Method method : searchMethods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || method.getParameterTypes().length != argsNum) continue;
                Methods.setAccessible(method);
                methods.add(method);
            }
        }
        return methods;
    }

    public static List<Method> getAccessibleMethods(Class<?> clazz, String methodName) {
        Valid.notNull(clazz, "method class is null", new Object[0]);
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] searchMethods;
            for (Method method : searchMethods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                Methods.setAccessible(method);
                methods.add(method);
            }
        }
        return methods;
    }

    public static List<Method> getAccessibleMethods(Class<?> clazz) {
        Valid.notNull(clazz, "method class is null", new Object[0]);
        if (clazz.getSuperclass() != null) {
            List methodList = Stream.of(clazz.getDeclaredMethods()).filter(field -> !Modifier.isStatic(field.getModifiers())).peek(Methods::setAccessible).collect(Collectors.toCollection(ArrayList::new));
            Class<?> superClass = clazz.getSuperclass();
            Map methodMap = methodList.stream().collect(Collectors.toMap(Method::getName, Function.identity()));
            Methods.getAccessibleMethods(superClass).stream().filter(m -> !methodMap.containsKey(m.getName())).forEach(methodList::add);
            return methodList;
        }
        return new ArrayList<Method>();
    }

    public static Map<String, Method> getAccessibleMethodMap(Class<?> clazz) {
        List<Method> methodList = Methods.getAccessibleMethods(clazz);
        return Lists.isNotEmpty(methodList) ? methodList.stream().collect(Collectors.toMap(Method::getName, Function.identity())) : new HashMap<String, Method>();
    }

    public static void setAccessible(Method method) {
        Valid.notNull(method, "set accessible method class is null", new Object[0]);
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static List<Method> getStaticMethods(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        Method[] methods = clazz.getDeclaredMethods();
        return Arrays.stream(methods).filter(m -> Modifier.isStatic(m.getModifiers())).collect(Collectors.toList());
    }

    public static <E> E invokeGetter(Object obj, String fieldName) {
        Valid.notNull(obj, "invoke object is null", new Object[0]);
        Valid.notBlank(fieldName, "invoke getter field is null", new Object[0]);
        try {
            Field field = Fields.getAccessibleField(obj.getClass(), fieldName);
            if (field == null || !field.getType().equals(Boolean.TYPE)) {
                return Methods.invokeMethod(obj, GETTER_PREFIX + Strings.firstUpper(fieldName), null, (Object[])null);
            }
            return Methods.invokeMethod(obj, BOOLEAN_GETTER_PREFIX + Strings.firstUpper(fieldName), null, (Object[])null);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("invoke field: {} setter method error {}", fieldName, e.getMessage()), e);
        }
    }

    public static <E, R> R invokeSetter(Object obj, String fieldName, E value) {
        return (R)Methods.invokeMethod(obj, SETTER_PREFIX + Strings.firstUpper(fieldName), new Class[]{value.getClass()}, value);
    }

    @SafeVarargs
    public static <E, R> R invokeSetter(Object obj, String fieldSetterMethodName, E ... values) {
        Object[] objectArray;
        Class[] classArray;
        Valid.notNull(obj, "invoke object is null", new Object[0]);
        Valid.notBlank(fieldSetterMethodName, "invoke Setter Method is null", new Object[0]);
        String[] names = fieldSetterMethodName.split("\\.");
        if (names.length != Arrays1.length(values)) {
            throw Exceptions.argument("setting method and parameter length are inconsistent");
        }
        if (names.length == 1) {
            return (R)Methods.invokeMethod(obj, SETTER_PREFIX + Strings.firstUpper(names[0]), new Class[]{values[0].getClass()}, values[0]);
        }
        for (int i = 0; i < names.length - 1; ++i) {
            Object[] objectArray2;
            Class[] classArray2;
            E value = values[i];
            String string = names[i];
            if (value == null) {
                classArray2 = null;
            } else {
                Class[] classArray3 = new Class[1];
                classArray2 = classArray3;
                classArray3[0] = value.getClass();
            }
            if (value == null) {
                objectArray2 = null;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = values[i];
            }
            Methods.invokeMethod(obj, string, classArray2, objectArray2);
        }
        int end = names.length - 1;
        String string = names[end];
        if (values[end] == null) {
            classArray = null;
        } else {
            Class[] classArray4 = new Class[1];
            classArray = classArray4;
            classArray4[0] = values[end].getClass();
        }
        if (values[end] == null) {
            objectArray = null;
        } else {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = values[end];
        }
        return (R)Methods.invokeMethod(obj, string, classArray, objectArray);
    }

    public static <E, R> R invokeSetterInfer(Object obj, String fieldName, E value) {
        return (R)Methods.invokeMethodInfer(obj, SETTER_PREFIX + Strings.firstUpper(fieldName), value);
    }

    public static <E, R> R invokeSetterInfer(Object obj, Method method, E value) {
        return (R)Methods.invokeMethodInfer(obj, method, value);
    }

    public static <E> E invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object ... args) {
        Valid.notNull(obj, "invoker object is null", new Object[0]);
        Valid.notBlank(methodName, "invoke method is null", new Object[0]);
        Method method = Methods.getAccessibleMethod(obj.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw Exceptions.invoke(Strings.format("method {} not found in class {}", methodName, obj.getClass()));
        }
        try {
            return (E)method.invoke(obj, args);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("invoke method error: {}, class: {}, args: {}", methodName, obj.getClass(), Arrays.toString(args)), e);
        }
    }

    public static <E> E invokeMethod(Object obj, String methodName) {
        return Methods.invokeMethod(obj, methodName, (Object[])null);
    }

    public static <E> E invokeMethod(Object obj, Method method) {
        return Methods.invokeMethod(obj, method, (Object[])null);
    }

    public static <E> E invokeMethod(Object obj, String methodName, Object ... args) {
        Valid.notNull(obj, "invoker object is null", new Object[0]);
        Valid.notBlank(methodName, "invoke method is null", new Object[0]);
        Method method = Methods.getAccessibleMethod(obj.getClass(), methodName, Arrays1.length(args));
        if (method == null) {
            throw Exceptions.invoke(Strings.format("invoke method error: {} not found in class {}", methodName, obj.getClass().getName()));
        }
        try {
            return (E)method.invoke(obj, args);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("invoke method error: {}, class: {}, args: {}", methodName, obj.getClass().getName(), Arrays.toString(args)), e);
        }
    }

    public static <E> E invokeMethod(Object obj, Method method, Object ... args) {
        Valid.notNull(obj, "invoke object is null", new Object[0]);
        Valid.notNull(method, "invoke method is null", new Object[0]);
        try {
            Methods.setAccessible(method);
            return (E)method.invoke(obj, args);
        }
        catch (Exception e) {
            throw Exceptions.invoke(Strings.format("invoke method error: {}, class: {}, args: {}", method.getName(), obj.getClass().getName(), Arrays.toString(args)), e);
        }
    }

    public static <E> E invokeMethodInfer(Object obj, Method method, Object ... args) {
        Valid.notNull(obj, "invoke object is null", new Object[0]);
        Valid.notNull(method, "invoke method is null", new Object[0]);
        if (Arrays1.isEmpty(args)) {
            return Methods.invokeMethod(obj, method, (Object[])null);
        }
        return (E)TypeInfer.invokeInfer(obj, Lists.singleton(method), args);
    }

    public static <E> E invokeMethodInfer(Object obj, String methodName, Object ... args) {
        Valid.notNull(obj, "invoke object is null", new Object[0]);
        Valid.notBlank(methodName, "invoke method is null", new Object[0]);
        if (Arrays1.isEmpty(args)) {
            return Methods.invokeMethod(obj, methodName, (Object[])null);
        }
        int len = Arrays1.length(args);
        List<Method> methods = Methods.getAccessibleMethods(obj.getClass(), methodName, len);
        return (E)TypeInfer.invokeInfer(obj, methods, args);
    }
}

