/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.reflect;

import com.orion.lang.function.IGetter;
import com.orion.lang.function.ISetter;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.reflect.ByteCodes;
import com.orion.lang.utils.reflect.Classes;
import com.orion.lang.utils.reflect.Fields;
import com.orion.lang.utils.reflect.Methods;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class Lambdas {
    private static final String WRITE_REPLACE = "writeReplace";

    private Lambdas() {
    }

    public static SerializedLambda getSerializedLambda(Serializable serial) {
        try {
            Method method = serial.getClass().getDeclaredMethod(WRITE_REPLACE, new Class[0]);
            method.setAccessible(Boolean.TRUE);
            return (SerializedLambda)method.invoke((Object)serial, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getImplClassName(SerializedLambda lambda) {
        return lambda.getImplClass().replaceAll("/", ".");
    }

    public static <T> Class<T> getImplClass(SerializedLambda lambda) {
        return Classes.loadClass(Lambdas.getImplClassName(lambda));
    }

    public static <T, R> String getGetterFieldName(IGetter<T, R> getter) {
        return Lambdas.getFieldName(Lambdas.getSerializedLambda(getter));
    }

    public static <T, U> String getSetterFieldName(ISetter<T, U> setter) {
        return Lambdas.getFieldName(Lambdas.getSerializedLambda(setter));
    }

    public static String getFieldName(SerializedLambda lambda) {
        return Fields.getFieldNameByMethodName(lambda.getImplMethodName());
    }

    public static Field getField(SerializedLambda lambda) {
        Class clazz = Lambdas.getImplClass(lambda);
        String fieldName = Fields.getFieldNameByMethodName(lambda.getImplMethodName());
        return Fields.getAccessibleField(clazz, fieldName);
    }

    public static String getMethodName(SerializedLambda lambda) {
        return lambda.getImplMethodName();
    }

    public static Method getMethod(SerializedLambda lambda) {
        Class clazz = Lambdas.getImplClass(lambda);
        String signature = lambda.getImplMethodSignature();
        List<Method> methods = Methods.getAccessibleMethods(clazz, lambda.getImplMethodName());
        for (Method method : methods) {
            if (!signature.equals(ByteCodes.getMethodSignature(method))) continue;
            return method;
        }
        throw Exceptions.runtime("no such method in class: " + clazz + " method signature: " + signature);
    }
}

