/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class ByteCodes {
    private static final String VM_NAME = "java.vm.name";

    private ByteCodes() {
    }

    public static boolean isAndroid() {
        return ByteCodes.isAndroid(System.getProperty(VM_NAME));
    }

    public static boolean isAndroid(String vm) {
        return (vm = vm.toLowerCase()).contains("dalvik") || vm.contains("lemur");
    }

    public static String getMethodSignature(Method method) {
        Class<?>[] types;
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (Class<?> type : types = method.getParameterTypes()) {
            buf.append(ByteCodes.getClassSignature(type));
        }
        buf.append(")");
        buf.append(ByteCodes.getClassSignature(method.getReturnType()));
        return buf.toString();
    }

    public static String getClassSignature(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ByteCodes.getPrimitiveLetter(clazz);
        }
        if (clazz.isArray()) {
            return "[" + ByteCodes.getClassSignature(clazz.getComponentType());
        }
        return "L" + ByteCodes.getClassTypeName(clazz) + ";";
    }

    public static String getClassTypeName(Class<?> clazz) {
        if (clazz.isArray()) {
            return "[" + ByteCodes.getClassSignature(clazz.getComponentType());
        }
        if (!clazz.isPrimitive()) {
            return clazz.getName().replaceAll("\\.", "/");
        }
        return ByteCodes.getPrimitiveLetter(clazz);
    }

    public static String getPrimitiveLetter(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "I";
        }
        if (Void.TYPE.equals(type)) {
            return "V";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Z";
        }
        if (Character.TYPE.equals(type)) {
            return "C";
        }
        if (Byte.TYPE.equals(type)) {
            return "B";
        }
        if (Short.TYPE.equals(type)) {
            return "S";
        }
        if (Float.TYPE.equals(type)) {
            return "F";
        }
        if (Long.TYPE.equals(type)) {
            return "J";
        }
        if (Double.TYPE.equals(type)) {
            return "D";
        }
        throw new IllegalStateException("type: " + type.getCanonicalName() + " is not a primitive type");
    }

    public static Type checkPrimitiveArray(GenericArrayType genericArrayType) {
        Class ck;
        Type clz = genericArrayType;
        Type genericComponentType = genericArrayType.getGenericComponentType();
        String prefix = "[";
        while (genericComponentType instanceof GenericArrayType) {
            genericComponentType = ((GenericArrayType)genericComponentType).getGenericComponentType();
            prefix = prefix + prefix;
        }
        if (genericComponentType instanceof Class && (ck = (Class)genericComponentType).isPrimitive()) {
            try {
                if (ck == Boolean.TYPE) {
                    clz = Class.forName(prefix + "Z");
                } else if (ck == Character.TYPE) {
                    clz = Class.forName(prefix + "C");
                } else if (ck == Byte.TYPE) {
                    clz = Class.forName(prefix + "B");
                } else if (ck == Short.TYPE) {
                    clz = Class.forName(prefix + "S");
                } else if (ck == Integer.TYPE) {
                    clz = Class.forName(prefix + "I");
                } else if (ck == Long.TYPE) {
                    clz = Class.forName(prefix + "J");
                } else if (ck == Float.TYPE) {
                    clz = Class.forName(prefix + "F");
                } else if (ck == Double.TYPE) {
                    clz = Class.forName(prefix + "D");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clz;
    }
}

