/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.reflect;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Objects1;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.reflect.Classes;
import com.orion.lang.utils.reflect.Constructors;
import com.orion.lang.utils.reflect.Fields;
import com.orion.lang.utils.reflect.Methods;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanWrapper {
    private BeanWrapper() {
    }

    public static <T> Map<String, Object> toMap(T bean, String ... ignoreFields) {
        return BeanWrapper.toMap(bean, null, false, ignoreFields);
    }

    public static <T> Map<String, Object> toMap(T bean, boolean putNull, String ... ignoreFields) {
        return BeanWrapper.toMap(bean, null, putNull, ignoreFields);
    }

    public static <T> Map<String, Object> toMap(T bean, Map<String, String> fieldMapper, String ... ignoreFields) {
        return BeanWrapper.toMap(bean, fieldMapper, false, ignoreFields);
    }

    public static <T> Map<String, Object> toMap(T bean, Map<String, String> fieldMapper, boolean putNull, String ... ignoreFields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bean == null) {
            return map;
        }
        List<Method> getterMethods = Methods.getGetterMethodsByCache(bean.getClass());
        for (Method getterMethod : getterMethods) {
            String s;
            String fieldName = Fields.getFieldNameByMethodName(getterMethod.getName());
            if (fieldMapper != null && (s = fieldMapper.get(fieldName)) != null) {
                fieldName = s;
            }
            if (BeanWrapper.isIgnore(fieldName, ignoreFields)) continue;
            Object o = Methods.invokeMethod(bean, getterMethod);
            if (o == null) {
                if (!putNull) continue;
                map.put(fieldName, null);
                continue;
            }
            map.put(fieldName, o);
        }
        return map;
    }

    public static <T> Map<String, T> toMap(T[] values, Map<Integer, String> indexMapper) {
        return BeanWrapper.toMap(values, indexMapper, false);
    }

    public static <T> Map<String, T> toMap(T[] values, Map<Integer, String> indexMapper, boolean putNull) {
        HashMap<String, T> map = new HashMap<String, T>();
        if (values == null) {
            return map;
        }
        for (Map.Entry<Integer, String> entry : indexMapper.entrySet()) {
            Integer i = entry.getKey();
            if (i < values.length) {
                T value = values[i];
                if (value == null) {
                    if (!putNull) continue;
                    map.put(entry.getValue(), null);
                    continue;
                }
                map.put(entry.getValue(), value);
                continue;
            }
            if (!putNull) continue;
            map.put(entry.getValue(), null);
        }
        return map;
    }

    public static <T> T toBean(Map<?, ?> map, Class<T> clazz) {
        return BeanWrapper.toBean(map, null, clazz);
    }

    public static <T> T toBean(Map<?, ?> map, Map<String, ?> fieldMapper, Class<T> clazz) {
        T t = Constructors.newInstance(Constructors.getDefaultConstructorByCache(clazz));
        block2: for (Map.Entry<?, ?> entry : map.entrySet()) {
            List<Method> setterMethods = Methods.getSetterMethodsByCache(clazz);
            String key = Objects1.toString(entry.getKey());
            Map keyMap = null;
            if (fieldMapper != null) {
                Object field = fieldMapper.get(key);
                if (field instanceof String) {
                    key = (String)field;
                } else if (field instanceof Map) {
                    keyMap = (Map)field;
                }
            }
            String setterMethodName = Methods.getSetterMethodNameByFieldName(key);
            for (Method setterMethod : setterMethods) {
                Object value = entry.getValue();
                if (!setterMethod.getName().equals(setterMethodName)) continue;
                if (value == null) continue block2;
                Class<?> paramClass = setterMethod.getParameterTypes()[0];
                Class<?> valueClass = value.getClass();
                try {
                    if (Classes.isImplClass(paramClass, valueClass)) {
                        Methods.invokeMethod(t, setterMethod, value);
                        continue block2;
                    }
                    if (Classes.isImplClass(Map.class, valueClass) && !Classes.isImplClass(Map.class, paramClass)) {
                        Methods.invokeMethod(t, setterMethod, BeanWrapper.toBean((Map)value, keyMap, paramClass));
                        continue block2;
                    }
                    if (Classes.isImplClass(Map.class, paramClass) && !Classes.isImplClass(Map.class, valueClass)) {
                        Methods.invokeMethod(t, setterMethod, BeanWrapper.toMap(value, (Map<String, String>)keyMap, new String[0]));
                        continue block2;
                    }
                    Methods.invokeMethodInfer(t, setterMethod, value);
                }
                catch (Exception e) {
                    Exceptions.printStacks(e);
                }
                continue block2;
            }
        }
        return t;
    }

    public static <T> T toBean(Object[] values, Map<Integer, String> indexMapper, Class<T> clazz) {
        T t = Constructors.newInstance(Constructors.getDefaultConstructorByCache(clazz));
        for (Map.Entry<Integer, String> entry : indexMapper.entrySet()) {
            try {
                Class<?> valueClass;
                Method setterMethod;
                Integer index = entry.getKey();
                if (index >= values.length || (setterMethod = Methods.getSetterMethodByCache(clazz, entry.getValue())) == null) continue;
                Object[] valueArr = new Object[1];
                Object value = values[index];
                Class<?> paramClass = setterMethod.getParameterTypes()[0];
                if (Classes.isImplClass(paramClass, valueClass = value.getClass())) {
                    valueArr[0] = value;
                    Methods.invokeMethod(t, setterMethod, valueArr);
                    continue;
                }
                if (Classes.isImplClass(Map.class, valueClass) && !Classes.isImplClass(Map.class, paramClass)) {
                    valueArr[0] = BeanWrapper.toBean((Map)value, null, paramClass);
                    Methods.invokeMethod(t, setterMethod, valueArr);
                    continue;
                }
                if (Classes.isImplClass(Map.class, paramClass) && !Classes.isImplClass(Map.class, valueClass)) {
                    valueArr[0] = BeanWrapper.toMap(value, new String[0]);
                    Methods.invokeMethod(t, setterMethod, valueArr);
                    continue;
                }
                valueArr[0] = value;
                Methods.invokeMethodInfer(t, setterMethod, valueArr);
            }
            catch (Exception exception) {}
        }
        return t;
    }

    public static <R, T> T copyProperties(R source, Class<T> targetClass, String ... ignoreFields) {
        return BeanWrapper.copy(source, targetClass, null, ignoreFields);
    }

    public static <R, T> T copyProperties(R source, Class<T> targetClass, Map<String, String> fieldMapper, String ... ignoreFields) {
        return BeanWrapper.copy(source, targetClass, fieldMapper, ignoreFields);
    }

    public static <R, T> void copyProperties(R source, T target, String ... ignore) {
        BeanWrapper.copy(source, target, null, ignore);
    }

    public static <R, T> void copyProperties(R source, T target, Map<String, String> fieldMapper, String ... ignoreFields) {
        BeanWrapper.copy(source, target, fieldMapper, ignoreFields);
    }

    private static <R, T> T copy(R source, Class<T> targetClass, Map<String, String> fieldMapper, String[] ignoreFields) {
        Valid.notNull(source, "source object is null", new Object[0]);
        Valid.notNull(targetClass, "target class is null", new Object[0]);
        Constructor<T> constructor = Constructors.getDefaultConstructorByCache(targetClass);
        T target = Constructors.newInstance(constructor);
        BeanWrapper.copy(source, target, fieldMapper, ignoreFields);
        return target;
    }

    private static <R, T> void copy(R source, T target, Map<String, String> fieldMapper, String[] ignoreFields) {
        Valid.notNull(source, "source object is null", new Object[0]);
        Valid.notNull(target, "target object is null", new Object[0]);
        List<Method> sourceGetters = Methods.getGetterMethodsByCache(source.getClass());
        List<Method> targetSetters = Methods.getSetterMethodsByCache(target.getClass());
        block2: for (Method targetSetter : targetSetters) {
            String targetSetterName = targetSetter.getName();
            String targetFieldName = Strings.firstLower(targetSetterName.substring(3));
            if (BeanWrapper.isIgnore(targetFieldName, ignoreFields)) continue;
            String sourceFieldName = BeanWrapper.getFieldNameAlias(targetFieldName, fieldMapper);
            for (Method sourceGetter : sourceGetters) {
                if (!Objects1.eq(Fields.getFieldNameByMethodName(sourceGetter.getName()), sourceFieldName)) continue;
                try {
                    Object sourceValue = Methods.invokeMethod(source, sourceGetter);
                    if (sourceValue == null) continue block2;
                    Methods.invokeMethodInfer(target, targetSetter, sourceValue);
                    continue block2;
                }
                catch (Exception e) {
                    throw Exceptions.parse("could not copy source property " + sourceFieldName + " to target " + targetFieldName);
                }
            }
        }
    }

    private static boolean isIgnore(String name, String[] ignoreFields) {
        if (ignoreFields != null) {
            for (String ignore : ignoreFields) {
                if (!ignore.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static String getFieldNameAlias(String name, Map<String, String> fieldMapper) {
        if (fieldMapper != null) {
            for (Map.Entry<String, String> entry : fieldMapper.entrySet()) {
                if (!entry.getValue().equals(name)) continue;
                return entry.getKey();
            }
        }
        return name;
    }
}

