/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.random;

import com.orion.lang.utils.Systems;
import com.orion.lang.utils.Valid;
import java.util.regex.Pattern;

public class RndGenerator {
    private long seed;
    private final long originSeed;
    private final int bit;
    private final Pattern reg;

    public RndGenerator() {
        this((System.currentTimeMillis() >> 16 | (long)Systems.getProcessCode()) * 32L, 4);
    }

    public RndGenerator(long seed) {
        this(seed, 4);
    }

    public RndGenerator(int bit) {
        this((System.currentTimeMillis() >> 16 | (long)Systems.getProcessCode()) * 32L, bit);
    }

    public RndGenerator(long seed, int bit) {
        Valid.gte((seed + "").length(), bit, "bit len must less than or equal seed len", new Object[0]);
        this.seed = seed;
        this.originSeed = seed;
        this.bit = bit;
        this.reg = Pattern.compile("^1[0]{" + (bit - 1) + ",}$");
    }

    public long next() {
        int el;
        String bs = this.seed + "";
        this.seed *= this.seed;
        String as = this.seed + "";
        char c = as.charAt(el = as.length() - bs.length() >> 1);
        String ns = c == '0' ? "1" + as.substring(el + 1, bs.length() + el) : as.substring(el, bs.length() + el);
        this.seed = Long.parseLong(ns);
        if (this.reg.matcher(ns).matches()) {
            ns = this.originSeed + "";
            this.seed = this.originSeed;
        }
        int i = bs.length() - this.bit >> 1;
        return Long.parseLong(ns.substring(i, this.bit + i));
    }
}

