/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.orion.lang.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JackSons {
    private JackSons() {
    }

    public static ObjectMapper get() {
        return MapperInstance.objectMapper;
    }

    public static ObjectMapper set(ObjectMapper objectMapper) {
        return MapperInstance.objectMapper = objectMapper;
    }

    public static String toJson(Object bean) {
        if (bean == null) {
            return "";
        }
        try {
            return MapperInstance.objectMapper.writeValueAsString(bean);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static <T> T toBean(String json, Class<T> targetClass) {
        if (Strings.isEmpty(json)) {
            return null;
        }
        try {
            return (T)MapperInstance.objectMapper.readValue(json, targetClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        if (Strings.isEmpty(json)) {
            return new ArrayList();
        }
        try {
            return (List)MapperInstance.objectMapper.readValue(json, JackSons.getJavaType(List.class, clazz));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> Set<T> toSet(String json, Class<T> clazz) {
        if (Strings.isEmpty(json)) {
            return new HashSet();
        }
        try {
            return (Set)MapperInstance.objectMapper.readValue(json, JackSons.getJavaType(Set.class, clazz));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> ks, Class<V> vs) {
        if (Strings.isEmpty(json)) {
            return new HashMap(16);
        }
        try {
            return (Map)MapperInstance.objectMapper.readValue(json, JackSons.getJavaType(Map.class, ks, vs));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T toObject(String json, Class<?> rawClass, Class<?> ... genericClasses) {
        try {
            return (T)MapperInstance.objectMapper.readValue(json, JackSons.getJavaType(rawClass, genericClasses));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JavaType getJavaType(Class<?> rawClass, Class<?> ... genericClasses) {
        return MapperInstance.objectMapper.getTypeFactory().constructParametricType(rawClass, (Class[])genericClasses);
    }

    private static class MapperInstance {
        private static ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());

        private MapperInstance() {
        }
    }
}

