/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.orion.lang.utils.Strings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Gsons {
    private Gsons() {
    }

    public static Gson get() {
        return GsonInstance.gson;
    }

    public static Gson set(GsonBuilder builder) {
        return GsonInstance.gson = builder.create();
    }

    public static Gson set(Gson gson) {
        return GsonInstance.gson = gson;
    }

    public static String toJson(Object o) {
        if (o == null) {
            return "";
        }
        return GsonInstance.gson.toJson(o);
    }

    public static <T> T toBean(String json, Class<T> clazz) {
        if (Strings.isBlank(json)) {
            return null;
        }
        return (T)GsonInstance.gson.fromJson(json, clazz);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        if (Strings.isBlank(json)) {
            return new ArrayList();
        }
        return (List)GsonInstance.gson.fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType());
    }

    public static <T> Set<T> toSet(String json, Class<T> clazz) {
        if (Strings.isBlank(json)) {
            return new HashSet();
        }
        return (Set)GsonInstance.gson.fromJson(json, TypeToken.getParameterized(Set.class, (Type[])new Type[]{clazz}).getType());
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> keyClass, Class<V> valClass) {
        if (Strings.isBlank(json)) {
            return new HashMap();
        }
        return (Map)GsonInstance.gson.fromJson(json, TypeToken.getParameterized(Map.class, (Type[])new Type[]{keyClass, valClass}).getType());
    }

    public static <T> T toObject(String json, Class<?> rawClass, Class<?> ... genericClasses) {
        return (T)GsonInstance.gson.fromJson(json, TypeToken.getParameterized(rawClass, (Type[])genericClasses).getType());
    }

    private static class GsonInstance {
        private static Gson gson = new Gson();

        private GsonInstance() {
        }
    }
}

