/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.split;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.Callable;

public class FileSplit
implements Callable<String[]> {
    private static final int DEFAULT_SPLIT_BLOCK = 8;
    private final File file;
    private final int blockCount;
    private long blockSize;
    private int bufferSize;
    private boolean nothing;

    public FileSplit(String file) {
        this(new File(file), 8, 2048);
    }

    public FileSplit(File file) {
        this(file, 8, 2048);
    }

    public FileSplit(String file, int blockCount) {
        this(new File(file), blockCount, 2048);
    }

    public FileSplit(File file, int blockCount) {
        this(file, blockCount, 2048);
    }

    public FileSplit(String file, long blockSize) {
        this(new File(file), blockSize, 2048);
    }

    public FileSplit(File file, long blockSize) {
        this(file, blockSize, 2048);
    }

    public FileSplit(String file, int blockCount, int bufferSize) {
        this(new File(file), blockCount, bufferSize);
    }

    public FileSplit(String file, long blockSize, int bufferSize) {
        this(new File(file), blockSize, bufferSize);
    }

    public FileSplit(File file, int blockCount, int bufferSize) {
        if (blockCount < 2) {
            blockCount = 8;
        }
        this.blockCount = blockCount;
        if (bufferSize < 2048) {
            bufferSize = 2048;
        }
        this.bufferSize = bufferSize;
        if (file == null || !file.exists()) {
            throw Exceptions.runtime(Strings.format("file not found {}", file));
        }
        if (file.length() == 0L) {
            throw Exceptions.runtime(Strings.format("file is empty {}", file));
        }
        this.file = file;
        double size = (double)file.length() / (double)blockCount;
        this.blockSize = Double.compare(size, (int)size) == 0 ? (long)size : (long)size + 1L;
    }

    public FileSplit(File file, long blockSize, int bufferSize) {
        if (bufferSize < 2048) {
            bufferSize = 2048;
        }
        this.bufferSize = bufferSize;
        if (file == null || !file.exists() || file.length() == 0L) {
            throw Exceptions.runtime("file is illegal");
        }
        this.file = file;
        if (blockSize < 1024L) {
            blockSize = 1024L;
        }
        if (blockSize >= file.length()) {
            this.nothing = true;
        }
        this.blockSize = blockSize;
        int blockCount = (int)(file.length() / blockSize);
        if (file.length() % blockSize != 0L) {
            ++blockCount;
        }
        this.blockCount = blockCount;
    }

    @Override
    public String[] call() {
        if (this.nothing) {
            return new String[]{this.file.getAbsolutePath()};
        }
        String[] blockPaths = new String[this.blockCount];
        File df = new File(this.file.getAbsolutePath() + ".block");
        Files1.mkdirs(df);
        for (int i = 0; i < this.blockCount; ++i) {
            String splitFileName = df.getAbsolutePath() + "\\" + this.file.getName() + ".000" + (i + 1);
            Files1.touch(splitFileName);
            blockPaths[i] = splitFileName;
            this.randomReadToFile((long)i * this.blockSize, new File(splitFileName));
        }
        return blockPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void randomReadToFile(long offset, File writeFile) {
        RandomAccessFile accessFile = null;
        FileOutputStream outputStream = null;
        try {
            accessFile = new RandomAccessFile(this.file, "r");
            accessFile.seek(offset);
            if (accessFile.length() - offset < this.blockSize) {
                this.blockSize = accessFile.length() - offset;
            }
            Files1.touch(writeFile);
            outputStream = new FileOutputStream(writeFile);
            if (this.blockSize < (long)this.bufferSize) {
                this.bufferSize = (int)this.blockSize;
            }
            long times = this.blockSize / (long)this.bufferSize;
            long more = this.blockSize % (long)this.bufferSize;
            if (more != 0L) {
                ++times;
            } else {
                more = this.bufferSize;
            }
            byte[] buffer = new byte[this.bufferSize];
            int i = 0;
            while ((long)i < times - 1L) {
                outputStream.write(buffer, 0, accessFile.read(buffer));
                ++i;
            }
            buffer = new byte[(int)more];
            outputStream.write(buffer, 0, accessFile.read(buffer));
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                Exceptions.printStacks(e);
            }
            catch (Throwable throwable) {
                Streams.close(outputStream);
                Streams.close(accessFile);
                throw throwable;
            }
            Streams.close(outputStream);
            Streams.close(accessFile);
        }
        Streams.close(outputStream);
        Streams.close(accessFile);
    }
}

