/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.split;

import com.orion.lang.define.wrapper.Pair;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;

public class FileMerge
implements Callable<String> {
    private final File file;
    private final String[] blockFile;
    private final int bufferSize;

    public FileMerge(String file) {
        this(new File(file), 8192);
    }

    public FileMerge(String file, int bufferSize) {
        this(new File(file), bufferSize);
    }

    public FileMerge(File file) {
        this(file, 8192);
    }

    public FileMerge(File file, int bufferSize) {
        if (file == null || !file.isDirectory()) {
            throw Exceptions.runtime("the folder path is incorrect");
        }
        this.file = file;
        String[] cf = file.list();
        if (cf == null || cf.length == 0) {
            throw Exceptions.runtime("file block does not exist");
        }
        this.blockFile = cf;
        if (bufferSize < 8192) {
            bufferSize = 8192;
        }
        this.bufferSize = bufferSize;
    }

    @Override
    public String call() {
        Pair<String, List<String>> fl = this.shuffleFile(this.blockFile);
        try {
            return this.mergeFile(this.file.getAbsolutePath(), fl.getKey(), fl.getValue());
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private Pair<String, List<String>> shuffleFile(String[] files) {
        TreeMap<Integer, String> fm = new TreeMap<Integer, String>();
        for (String file : files) {
            int l = file.lastIndexOf(".");
            String blockIndex = file.substring(l + 1);
            if (!Strings.isNumber(blockIndex)) continue;
            fm.put(Integer.valueOf(blockIndex), file);
        }
        int last = 0;
        int i = 0;
        String filePath = "";
        ArrayList fileList = new ArrayList();
        for (Map.Entry is : fm.entrySet()) {
            if (i++ == 0) {
                last = (Integer)is.getKey();
                String ff = (String)is.getValue();
                filePath = ff.substring(0, ff.lastIndexOf("."));
            }
            if (last++ != (Integer)is.getKey()) {
                throw Exceptions.runtime("not found index: " + (last - 1) + " block file");
            }
            fileList.add(is.getValue());
        }
        return Pair.of(filePath, fileList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String mergeFile(String dir, String fileName, List<String> blocks) {
        String path = Files1.getPath(dir, fileName);
        try (OutputStream dist = Files1.openOutputStreamFast(path);){
            for (String block : blocks) {
                int read;
                FileInputStream in = Files1.openInputStream(Files1.getPath(dir, block));
                byte[] buffer = new byte[this.bufferSize];
                while ((read = in.read(buffer)) != -1) {
                    dist.write(buffer, 0, read);
                }
                Streams.close(in);
            }
            dist.flush();
            String string = path;
            return string;
        }
        catch (Exception e) {
            throw Exceptions.runtime("merge error: " + e.getMessage());
        }
    }
}

