/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.crypto;

import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.crypto.AES;
import com.orion.lang.utils.crypto.Keys;
import com.orion.lang.utils.crypto.enums.CipherAlgorithm;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import javax.crypto.SecretKey;

public class FileEncrypt
implements Callable<Boolean> {
    private final InputStream in;
    private final OutputStream out;
    private final String password;
    private final int bufferSize;
    private final boolean autoClose;

    public FileEncrypt(File file, File dest, String password) {
        this(file, dest, password, 8192);
    }

    public FileEncrypt(String file, String dest, String password) {
        this(file, dest, password, 8192);
    }

    public FileEncrypt(InputStream in, OutputStream out, String password) {
        this(in, out, password, 8192);
    }

    public FileEncrypt(String file, String dest, String password, int bufferSize) {
        this(new File(file), new File(dest), password, bufferSize);
    }

    public FileEncrypt(File file, File dest, String password, int bufferSize) {
        this.autoClose = true;
        this.password = password;
        this.bufferSize = bufferSize;
        Files1.touch(dest);
        this.in = Files1.openInputStreamSafe(file);
        this.out = Files1.openOutputStreamSafe(dest);
    }

    public FileEncrypt(InputStream in, OutputStream out, String password, int bufferSize) {
        this.autoClose = false;
        this.password = password;
        this.in = in;
        this.out = out;
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        SecretKey secretKey = Keys.generatorKey(this.password, CipherAlgorithm.AES);
        try {
            int read;
            byte[] bs = new byte[this.bufferSize];
            while ((read = this.in.read(bs)) != -1) {
                byte[] ebs = AES.encrypt(Arrays1.resize(bs, read), secretKey);
                this.out.write(ebs);
                this.out.write(10);
            }
            this.out.flush();
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Boolean bl = false;
            return bl;
        }
        finally {
            if (this.autoClose) {
                Streams.close(this.in);
                Streams.close(this.out);
            }
        }
    }
}

