/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.compress.mix;

import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.lang.utils.io.compress.BaseFileCompressor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class TarBz2Compressor
extends BaseFileCompressor {
    private TarArchiveOutputStream outputStream;

    public TarBz2Compressor() {
        this("tar.bz2");
    }

    public TarBz2Compressor(String suffix) {
        super(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCompress() throws Exception {
        try (BufferedOutputStream fileOut = new BufferedOutputStream(Files1.openOutputStreamFast(this.getAbsoluteCompressPath()));
             BZip2CompressorOutputStream bz2Out = new BZip2CompressorOutputStream((OutputStream)fileOut);){
            ArchiveEntry entity;
            this.outputStream = new TarArchiveOutputStream((OutputStream)bz2Out);
            for (Map.Entry fileEntity : this.compressFiles.entrySet()) {
                entity = this.outputStream.createArchiveEntry((File)fileEntity.getValue(), (String)fileEntity.getKey());
                this.outputStream.putArchiveEntry(entity);
                try (InputStream in = Files1.openInputStreamFast((File)fileEntity.getValue());){
                    Streams.transfer(in, (OutputStream)this.outputStream);
                }
                this.outputStream.closeArchiveEntry();
                super.notify((String)fileEntity.getKey());
            }
            for (Map.Entry fileEntity : this.compressStreams.entrySet()) {
                entity = new TarArchiveEntry((String)fileEntity.getKey());
                entity.setSize((long)((InputStream)fileEntity.getValue()).available());
                this.outputStream.putArchiveEntry(entity);
                Streams.transfer((InputStream)fileEntity.getValue(), (OutputStream)this.outputStream);
                this.outputStream.closeArchiveEntry();
                super.notify((String)fileEntity.getKey());
            }
            this.outputStream.finish();
        }
        finally {
            Streams.close((AutoCloseable)this.outputStream);
        }
    }

    public TarArchiveOutputStream getCloseable() {
        return this.outputStream;
    }
}

