/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.compress.bz2;

import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.lang.utils.io.compress.BaseFileCompressor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class Bz2Compressor
extends BaseFileCompressor {
    private BZip2CompressorOutputStream outputStream;
    private File compressFile;
    private InputStream compressInputStream;
    private OutputStream compressOutputStream;

    public Bz2Compressor() {
        this("bz2");
    }

    public Bz2Compressor(String suffix) {
        super(suffix);
    }

    @Override
    public void addFile(String file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(File file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(String name, String file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(String name, File file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFilePrefix(String prefix, String file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFilePrefix(String prefix, File file) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(String name, byte[] bs) {
        this.unsupportedOperation();
    }

    @Override
    public void addFile(String name, InputStream in) {
        this.unsupportedOperation();
    }

    public void setCompressFile(String file) {
        Valid.notBlank(file, "file is null", new Object[0]);
        this.setCompressFile(new File(file));
    }

    public void setCompressFile(File file) {
        Valid.notNull(file, "file is null", new Object[0]);
        Valid.isTrue(Files1.isFile(file), "compress file must be a normal file", new Object[0]);
        this.compressFile = file;
        this.setFileName(file.getName());
    }

    public void setCompressFile(byte[] bs) {
        this.compressInputStream = Streams.toInputStream(bs);
    }

    public void setCompressFile(InputStream in) {
        this.compressInputStream = in;
    }

    public void setCompressOutputStream(OutputStream compressOutputStream) {
        this.compressOutputStream = compressOutputStream;
    }

    @Override
    public void compress() throws Exception {
        Valid.isFalse(this.compressFile == null && this.compressInputStream == null, "bzip2 compress file just support compress one file", new Object[0]);
        this.doCompress();
    }

    @Override
    public void doCompress() throws Exception {
        InputStream in = null;
        try {
            this.outputStream = this.compressOutputStream != null ? new BZip2CompressorOutputStream(this.compressOutputStream) : new BZip2CompressorOutputStream(Files1.openOutputStreamFast(new File(this.getAbsoluteCompressPath())));
            in = this.compressInputStream != null ? this.compressInputStream : Files1.openInputStreamFast(this.compressFile);
            Streams.transfer(in, (OutputStream)this.outputStream);
            super.notify("");
        }
        catch (Throwable throwable) {
            Streams.close((AutoCloseable)this.outputStream);
            if (this.compressInputStream == null) {
                Streams.close(in);
            }
            throw throwable;
        }
        Streams.close((AutoCloseable)this.outputStream);
        if (this.compressInputStream == null) {
            Streams.close(in);
        }
    }

    public BZip2CompressorOutputStream getCloseable() {
        return this.outputStream;
    }
}

