/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io.compress;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.io.compress.zip.ZipCompressor;
import com.orion.lang.utils.io.compress.zip.ZipDecompressor;
import java.io.File;

public class Compresses {
    private Compresses() {
    }

    public static void zip(String dir, String target) {
        Compresses.zip(new File(dir), target);
    }

    public static void zip(File dir, String target) {
        try {
            ZipCompressor c = new ZipCompressor();
            c.addFile(dir);
            c.setAbsoluteCompressPath(target);
            c.compress();
        }
        catch (Exception e) {
            throw Exceptions.runtime("compress file error", e);
        }
    }

    public static void unzip(String target, String unzipDir) {
        Compresses.unzip(new File(target), new File(unzipDir));
    }

    public static void unzip(File target, File unzipDir) {
        try {
            ZipDecompressor c = new ZipDecompressor();
            c.setDecompressFile(target);
            c.setDecompressTargetPath(unzipDir);
            c.decompress();
        }
        catch (Exception e) {
            throw Exceptions.runtime("decompress file error", e);
        }
    }
}

