/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io;

import com.orion.lang.define.iterator.ByteArrayIterator;
import com.orion.lang.define.iterator.LineIterator;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.crypto.Signatures;
import com.orion.lang.utils.crypto.enums.HashDigest;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public class Streams {
    private Streams() {
    }

    public static void close(AutoCloseable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void flush(Flushable f) {
        try {
            if (f != null) {
                f.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return Streams.toBufferedReader(reader, 8192);
    }

    public static BufferedReader toBufferedReader(Reader reader, int bufferSize) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        return new BufferedReader(reader, bufferSize);
    }

    public static BufferedWriter toBufferedWriter(Writer writer) {
        return Streams.toBufferedWriter(writer, 8192);
    }

    public static BufferedWriter toBufferedWriter(Writer writer, int bufferSize) {
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        return new BufferedWriter(writer, bufferSize);
    }

    public static int transfer(RandomAccessFile access, OutputStream output) throws IOException {
        long count = Streams.transferLarge(access, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long transferLarge(RandomAccessFile access, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        long count = 0L;
        int n = 0;
        while ((n = access.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static int transfer(InputStream input, OutputStream output) throws IOException {
        long count = Streams.transferLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long transferLarge(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        long count = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void transfer(InputStream input, Writer output) throws IOException {
        Streams.transfer((Reader)new InputStreamReader(input), output);
    }

    public static void transfer(InputStream input, Writer output, String charset) throws IOException {
        if (charset == null) {
            Streams.transfer(input, output);
        } else {
            Streams.transfer((Reader)new InputStreamReader(input, charset), output);
        }
    }

    public static int transfer(Reader input, Writer output) throws IOException {
        long count = Streams.transferLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long transferLarge(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[8192];
        long count = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void transfer(Reader input, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        Streams.transfer(input, (Writer)out);
        out.flush();
    }

    public static void transfer(Reader input, OutputStream output, String charset) throws IOException {
        if (charset == null) {
            Streams.transfer(input, output);
        } else {
            OutputStreamWriter out = new OutputStreamWriter(output, charset);
            Streams.transfer(input, (Writer)out);
            out.flush();
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Streams.transfer(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Streams.transfer(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input, String charset) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Streams.transfer(input, output, charset);
        return output.toByteArray();
    }

    public static char[] toCharArray(InputStream is) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        Streams.transfer(is, (Writer)output);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream is, String charset) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        Streams.transfer(is, output, charset);
        return output.toCharArray();
    }

    public static char[] toCharArray(Reader input) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        Streams.transfer(input, (Writer)sw);
        return sw.toCharArray();
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        Streams.transfer(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(InputStream input, String charset) throws IOException {
        StringWriter sw = new StringWriter();
        Streams.transfer(input, sw, charset);
        return sw.toString();
    }

    public static String toString(Reader input) throws IOException {
        StringWriter sw = new StringWriter();
        Streams.transfer(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(byte[] input) throws IOException {
        return new String(input);
    }

    public static String toString(byte[] input, String charset) throws IOException {
        if (charset == null) {
            return new String(input);
        }
        return new String(input, charset);
    }

    public static InputStream toInputStream(byte[] bs) {
        return new ByteArrayInputStream(bs);
    }

    public static InputStream toInputStream(byte[] bs, int off, int len) {
        return new ByteArrayInputStream(bs, off, len);
    }

    public static InputStream toInputStream(String input) {
        return new ByteArrayInputStream(Strings.bytes(input));
    }

    public static InputStream toInputStream(String input, String charset) {
        byte[] bytes = charset != null ? Strings.bytes(input, charset) : Strings.bytes(input);
        return new ByteArrayInputStream(bytes);
    }

    public static OutputStream toOutputStream(byte[] bs) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(bs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public static OutputStream toOutputStream(byte[] bs, int off, int len) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(bs, off, len);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public static OutputStream toOutputStream(String input) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(Strings.bytes(input));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public static OutputStream toOutputStream(String input, String charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(charset != null ? Strings.bytes(input, charset) : Strings.bytes(input));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public static String md5(InputStream in) {
        return Streams.sign(in, HashDigest.MD5);
    }

    public static String sha1(InputStream in) {
        return Streams.sign(in, HashDigest.SHA1);
    }

    public static String sha224(InputStream in) {
        return Streams.sign(in, HashDigest.SHA224);
    }

    public static String sha256(InputStream in) {
        return Streams.sign(in, HashDigest.SHA256);
    }

    public static String sha384(InputStream in) {
        return Streams.sign(in, HashDigest.SHA256);
    }

    public static String sha512(InputStream in) {
        return Streams.sign(in, HashDigest.SHA512);
    }

    public static String sign(InputStream in, HashDigest type) {
        try {
            int length;
            MessageDigest m = type.getMessageDigest();
            byte[] buffer = new byte[8192];
            while ((length = in.read(buffer)) != -1) {
                m.update(buffer, 0, length);
            }
            return Signatures.toHex(m.digest());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void lineConsumer(InputStream in, Consumer<String> c) throws IOException {
        Streams.lineConsumer(new InputStreamReader(in), 8192, c);
    }

    public static void lineConsumer(InputStream in, String charset, Consumer<String> c) throws IOException {
        if (charset == null) {
            Streams.lineConsumer(in, c);
            return;
        }
        Streams.lineConsumer(new InputStreamReader(in, charset), 8192, c);
    }

    public static void lineConsumer(Reader reader, Consumer<String> c) throws IOException {
        Streams.lineConsumer(reader, 8192, c);
    }

    public static void lineConsumer(Reader reader, int bufferSize, Consumer<String> c) throws IOException {
        String line;
        Valid.notNull(reader, "reader is null", new Object[0]);
        BufferedReader bufferedReader = Streams.toBufferedReader(reader, bufferSize);
        while ((line = bufferedReader.readLine()) != null) {
            c.accept(line);
        }
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static LineIterator lineIterator(InputStream input) {
        return new LineIterator(new InputStreamReader(input));
    }

    public static LineIterator lineIterator(InputStream input, String charset) throws IOException {
        return new LineIterator(new InputStreamReader(input, charset));
    }

    public static void byteArrayConsumer(InputStream input, byte[] buffer, IntConsumer consumer) throws IOException {
        int read;
        while ((read = input.read(buffer)) != -1) {
            consumer.accept(read);
        }
    }

    public static ByteArrayIterator byteArrayIterator(InputStream input, byte[] buffer) {
        return new ByteArrayIterator(input, buffer);
    }
}

