/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.io;

import com.orion.lang.function.FileFilter;
import com.orion.lang.id.UUIds;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Systems;
import com.orion.lang.utils.crypto.enums.HashDigest;
import com.orion.lang.utils.io.FileAttribute;
import com.orion.lang.utils.io.Streams;
import com.orion.lang.utils.math.Numbers;
import com.orion.lang.utils.regexp.Matches;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Files1 {
    private static final String IO_TEMP_DIR = File.separator + ".orion" + File.separator + ".temp" + File.separator;
    public static final String SEPARATOR = "/";
    public static final String WINDOWS_SEPARATOR = "\\";
    private static final String WINDOWS_SEPARATOR_REPLICE = Matcher.quoteReplacement("\\");
    private static final String WINDOWS_SEPARATOR_REG = "\\\\+";
    private static final String LINUX_SEPARATOR_REG = "/+";
    private static final String[] SIZE_UNIT = new String[]{"K", "KB", "M", "MB", "G", "GB", "T", "TB", "B"};
    private static final long[] SIZE_UNIT_EFFECT = new long[]{1000L, 1024L, 1000000L, 0x100000L, 1000000000L, 0x40000000L, 1000000000000L, 0x10000000000L, 1L};

    private Files1() {
    }

    public static File newFile(String parent, String file) {
        return new File(Files1.getPath(parent), file);
    }

    public static File newFile(String file) {
        return new File(Files1.getPath(file));
    }

    public static FileAttribute getAttribute(String file) {
        return Files1.getAttribute(Paths.get(file, new String[0]));
    }

    public static FileAttribute getAttribute(File file) {
        return Files1.getAttribute(Paths.get(file.getAbsolutePath(), new String[0]));
    }

    public static FileAttribute getAttribute(URI file) {
        return Files1.getAttribute(Paths.get(file));
    }

    public static FileAttribute getAttribute(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try {
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            return new FileAttribute(file, attr);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean isExecutable(String file) {
        return new File(file).canExecute();
    }

    public static boolean isExecutable(File file) {
        return file.canExecute();
    }

    public static boolean isExecutable(Path file) {
        return Files.isExecutable(file);
    }

    public static boolean setExecutable(String file, boolean exec) {
        return new File(file).setExecutable(exec);
    }

    public static boolean setExecutable(File file, boolean exec) {
        return file.setExecutable(exec);
    }

    public static boolean setExecutable(Path file, boolean exec) {
        return file.toFile().setExecutable(exec);
    }

    public static boolean isReadable(String file) {
        return new File(file).canRead();
    }

    public static boolean isReadable(File file) {
        return file.canRead();
    }

    public static boolean isReadable(Path file) {
        return Files.isReadable(file);
    }

    public static boolean setReadable(String file, boolean readable) {
        return new File(file).setReadable(readable);
    }

    public static boolean setReadable(File file, boolean readable) {
        return file.setReadable(readable);
    }

    public static boolean setReadable(Path file, boolean readable) {
        return file.toFile().setReadable(readable);
    }

    public static boolean isWritable(String file) {
        return new File(file).canWrite();
    }

    public static boolean isWritable(File file) {
        return file.canWrite();
    }

    public static boolean isWritable(Path file) {
        return Files.isWritable(file);
    }

    public static boolean setWritable(String file, boolean writable) {
        return new File(file).setWritable(writable);
    }

    public static boolean setWritable(File file, boolean writable) {
        return file.setWritable(writable);
    }

    public static boolean setWritable(Path file, boolean writable) {
        return file.toFile().setWritable(writable);
    }

    public static boolean isHidden(String file) {
        return new File(file).isHidden();
    }

    public static boolean isHidden(File file) {
        return file.isHidden();
    }

    public static boolean isHidden(Path file) {
        try {
            return Files.isHidden(file);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static boolean isFile(String file) {
        return Files1.isFile(new File(file));
    }

    public static boolean isFile(File file) {
        return file.exists() && file.isFile();
    }

    public static boolean isFile(Path file) {
        return Files.isRegularFile(file, new LinkOption[0]);
    }

    public static boolean isDirectory(String file) {
        return Files1.isDirectory(new File(file));
    }

    public static boolean isDirectory(File file) {
        return file.exists() && file.isDirectory();
    }

    public static boolean isDirectory(Path file) {
        return Files.isDirectory(file, new LinkOption[0]);
    }

    public static boolean isSymbolicLink(String file) {
        return Files.isSymbolicLink(Paths.get(file, new String[0]));
    }

    public static boolean isSymbolicLink(File file) {
        return Files.isSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0]));
    }

    public static boolean isSymbolicLink(Path file) {
        return Files.isSymbolicLink(file);
    }

    public static Path getSymbolicLink(String file) {
        try {
            return Files.readSymbolicLink(Paths.get(file, new String[0]));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static File getSymbolicLink(File file) {
        try {
            return Files.readSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0])).toFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Path getSymbolicLink(Path file) {
        try {
            return Files.readSymbolicLink(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static boolean createLink(String source, String link) {
        return Files1.createLink(Paths.get(source, new String[0]), Paths.get(link, new String[0]));
    }

    public static boolean createLink(File source, File link) {
        return Files1.createLink(Paths.get(source.getAbsolutePath(), new String[0]), Paths.get(link.getAbsolutePath(), new String[0]));
    }

    public static boolean createLink(Path source, Path link) {
        try {
            Files.createDirectories(link.getParent(), new java.nio.file.attribute.FileAttribute[0]);
            Files.createLink(link, source);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean createSymbolLink(String source, String link) {
        return Files1.createSymbolLink(Paths.get(source, new String[0]), Paths.get(link, new String[0]));
    }

    public static boolean createSymbolLink(File source, File link) {
        return Files1.createSymbolLink(Paths.get(source.getAbsolutePath(), new String[0]), Paths.get(link.getAbsolutePath(), new String[0]));
    }

    public static boolean createSymbolLink(Path source, Path link) {
        try {
            Files.createDirectories(link.getParent(), new java.nio.file.attribute.FileAttribute[0]);
            Files.createSymbolicLink(link, source, new java.nio.file.attribute.FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getOwner(String file) {
        return Files1.getOwner(Paths.get(file, new String[0]));
    }

    public static String getOwner(File file) {
        return Files1.getOwner(Paths.get(file.getAbsolutePath(), new String[0]));
    }

    public static String getOwner(Path file) {
        try {
            return Files.getOwner(file, new LinkOption[0]).getName();
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static long getSize(String file) {
        return Files1.getSize(new File(file));
    }

    public static long getSize(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                return file.length();
            }
            long size = 0L;
            List<File> files = Files1.listFiles(file, true);
            for (File f : files) {
                size += f.length();
            }
            return size;
        }
        return 0L;
    }

    public static String getSize(long size) {
        String unit;
        double s;
        if (size / (SIZE_UNIT_EFFECT[1] * SIZE_UNIT_EFFECT[1] * SIZE_UNIT_EFFECT[1]) > 0L) {
            s = (double)size / (double)(SIZE_UNIT_EFFECT[1] * SIZE_UNIT_EFFECT[1] * SIZE_UNIT_EFFECT[1]);
            unit = " GB";
        } else if (size / (SIZE_UNIT_EFFECT[1] * SIZE_UNIT_EFFECT[1]) > 0L) {
            s = (double)size / (double)(SIZE_UNIT_EFFECT[1] * SIZE_UNIT_EFFECT[1]);
            unit = " MB";
        } else if (size / SIZE_UNIT_EFFECT[1] > 0L) {
            s = (double)size / (double)SIZE_UNIT_EFFECT[1];
            unit = " KB";
        } else {
            return size + " B";
        }
        return Numbers.setScale(s, 1) + unit;
    }

    public static long getByteSize(String size) {
        if (Strings.isBlank(size)) {
            return 0L;
        }
        int effectIndex = -1;
        int unitLen = 0;
        size = size.toUpperCase();
        for (int i = 0; i < SIZE_UNIT.length; ++i) {
            if (!size.endsWith(SIZE_UNIT[i])) continue;
            effectIndex = i;
            unitLen = SIZE_UNIT[i].length();
            break;
        }
        if (effectIndex == -1) {
            return 0L;
        }
        double d = Double.parseDouble(size.substring(0, size.length() - unitLen).trim());
        return (long)(d * (double)SIZE_UNIT_EFFECT[effectIndex]);
    }

    public static boolean resourceToFile(InputStream source, File file) throws IOException {
        return Files1.resourceToFile(source, file, null);
    }

    public static boolean resourceToFile(InputStream source, File file, String charset) throws IOException {
        FileOutputStream out;
        AutoCloseable writer;
        block11: {
            boolean needInit = false;
            if (!file.exists() || !file.isFile()) {
                needInit = true;
            }
            if (!needInit) {
                try {
                    if (source != null && file.length() != (long)source.available()) {
                        needInit = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (needInit && source == null) {
                return false;
            }
            writer = null;
            out = null;
            if (Files1.touch(file, charset)) break block11;
            boolean bl = false;
            Streams.close(source);
            Streams.close(writer);
            Streams.close(out);
            return bl;
        }
        try {
            out = new FileOutputStream(file, false);
            Streams.transfer(source, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Streams.close(source);
                Streams.close(writer);
                Streams.close(out);
                throw throwable;
            }
        }
        Streams.close(source);
        Streams.close(writer);
        Streams.close(out);
        return true;
    }

    public static String streamToFile(InputStreamReader reader, File file) {
        return Files1.streamToFile(reader, file, null);
    }

    public static String streamToFile(InputStreamReader reader, File file, String charset) {
        Files1.touch(file);
        OutputStreamWriter writer = null;
        try {
            int read;
            writer = charset == null ? new OutputStreamWriter(Files1.openOutputStream(file)) : new OutputStreamWriter((OutputStream)Files1.openOutputStream(file), charset);
            char[] cs = new char[8192];
            while ((read = reader.read(cs)) != -1) {
                writer.write(cs, 0, read);
            }
            writer.flush();
        }
        catch (Exception e) {
            try {
                throw Exceptions.ioRuntime(e);
            }
            catch (Throwable throwable) {
                Streams.close(writer);
                throw throwable;
            }
        }
        Streams.close(writer);
        return file.getAbsolutePath();
    }

    public static String streamToFile(InputStream in, File file) {
        Files1.touch(file);
        try (FileOutputStream out = Files1.openOutputStream(file);){
            int read;
            byte[] bs = new byte[8192];
            while ((read = in.read(bs)) != -1) {
                ((OutputStream)out).write(bs, 0, read);
            }
            out.flush();
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
        return file.getAbsolutePath();
    }

    public static void mergeFile(List<String> sources, String target) {
        Files1.mergeFile(Files1.toFiles(sources), new File(target));
    }

    public static void mergeFile(List<File> sources, File target) {
        if (!target.exists() || !target.isFile()) {
            Files1.touch(target);
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            for (File source : sources) {
                int read;
                in = Files1.openInputStream(source);
                out = new FileOutputStream(target, true);
                byte[] bytes = new byte[8192];
                while ((read = ((InputStream)in).read(bytes)) != -1) {
                    ((OutputStream)out).write(bytes, 0, read);
                }
                Streams.close(in);
                in = null;
            }
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
        finally {
            Streams.close(in);
            Streams.close(out);
        }
    }

    public static void mergeFile(String source, String target) {
        Files1.mergeFile(new File(source), new File(target));
    }

    public static void mergeFile(File source, File target) {
        FileOutputStream out = null;
        try (FileInputStream in = Files1.openInputStream(source);){
            int read;
            out = new FileOutputStream(target, true);
            byte[] bytes = new byte[8192];
            while ((read = ((InputStream)in).read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            out.flush();
        }
        catch (Exception e) {
            try {
                throw Exceptions.ioRuntime(e);
            }
            catch (Throwable throwable) {
                Streams.close(out);
                throw throwable;
            }
        }
        Streams.close(out);
    }

    public static void copyDir(String source, String target) {
        Files1.copyDir(new File(source), new File(target), true);
    }

    public static void copyDir(File source, File target) {
        Files1.copyDir(source, target, true);
    }

    public static void copyDir(String source, String target, boolean includeSourceDirName) {
        Files1.copyDir(new File(source), new File(target), includeSourceDirName);
    }

    public static void copyDir(File source, File target, boolean includeSourceDirName) {
        if (includeSourceDirName) {
            Files1.doCopyDir(source, new File(target, source.getName()));
        } else {
            Files1.doCopyDir(source, target);
        }
    }

    private static void doCopyDir(File source, File target) {
        if (!target.exists() || !target.isDirectory()) {
            target.mkdirs();
        }
        File[] files = source.listFiles();
        String sourceName = source.getName();
        if (files == null) {
            return;
        }
        for (File file : files) {
            File targetFile = new File(target.getAbsolutePath() + SEPARATOR + file.getName());
            if (file.isDirectory()) {
                Files1.doCopyDir(file, targetFile);
                continue;
            }
            Files1.copy(file, targetFile);
        }
    }

    public static void copy(String source, String target) {
        Files1.copy(new File(source), new File(target));
    }

    public static void copy(File source, File target) {
        try (FileChannel inc = Files1.openInputStream(source).getChannel();
             FileChannel outc = Files1.openOutputStream(target).getChannel();){
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            while (inc.read(buffer) != -1) {
                buffer.flip();
                outc.write(buffer);
                buffer.clear();
            }
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static boolean touch(String file) {
        return Files1.touch(new File(file), null, false);
    }

    public static boolean touch(File file) {
        return Files1.touch(file, null, false);
    }

    public static boolean touch(Path file) {
        return Files1.touch(file, null, false);
    }

    public static boolean touch(String file, String charset) {
        return Files1.touch(new File(file), charset, false);
    }

    public static boolean touch(File file, String charset) {
        return Files1.touch(file, charset, false);
    }

    public static boolean touch(Path file, String charset) {
        return Files1.touch(file, charset, false);
    }

    public static boolean touch(String file, boolean clean) {
        return Files1.touch(new File(file), null, clean);
    }

    public static boolean touch(File file, boolean clean) {
        return Files1.touch(file, null, clean);
    }

    public static boolean touch(Path file, boolean clean) {
        return Files1.touch(file, null, clean);
    }

    public static boolean touch(String file, String charset, boolean clean) {
        return Files1.touch(new File(file), charset, clean);
    }

    public static boolean touch(File file, String charset, boolean clean) {
        block23: {
            File dir = file.getParentFile();
            boolean create = false;
            if (!dir.exists()) {
                if (!dir.mkdirs()) {
                    return false;
                }
                create = true;
            } else if (!file.exists() || !file.isFile()) {
                create = true;
            }
            if (create) {
                try {
                    if (charset != null) {
                        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)Files1.openOutputStream(file), charset);){
                            w.write(" ");
                            break block23;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }
                    return file.createNewFile();
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (clean) {
                return Files1.cleanFile(file);
            }
        }
        return true;
    }

    public static boolean touch(Path file, String charset, boolean clean) {
        block24: {
            Path dir = file.getParent();
            boolean create = false;
            if (!Files.exists(dir, new LinkOption[0])) {
                try {
                    Files.createDirectories(dir, new java.nio.file.attribute.FileAttribute[0]);
                    create = true;
                }
                catch (IOException e) {
                    return false;
                }
            } else if (!Files.isRegularFile(file, new LinkOption[0])) {
                create = true;
            }
            if (create) {
                try {
                    if (charset != null) {
                        try (OutputStreamWriter w = new OutputStreamWriter(Files1.openOutputStreamFast(file), charset);){
                            w.write("");
                            break block24;
                        }
                        catch (IOException e) {
                            return false;
                        }
                    }
                    Files.createFile(file, new java.nio.file.attribute.FileAttribute[0]);
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (clean) {
                return Files1.cleanFile(file);
            }
        }
        return true;
    }

    public static String getTempFilePath() {
        return Systems.HOME_DIR + IO_TEMP_DIR + UUIds.random32() + ".temp";
    }

    public static File touchTempFile() {
        File file = new File(Files1.getTempFilePath());
        Files1.touch(file);
        return file;
    }

    public static File touchTempFile(boolean exitDelete) {
        File file = new File(Files1.getTempFilePath());
        Files1.touch(file);
        if (exitDelete) {
            file.deleteOnExit();
        }
        return file;
    }

    public static File touchOnDelete(String path) {
        File file = new File(path);
        Files1.touchOnDelete(file);
        return file;
    }

    public static void touchOnDelete(File file) {
        Files1.touch(file);
        file.deleteOnExit();
    }

    public static boolean mv(String file, File target) {
        return new File(file).renameTo(target);
    }

    public static boolean mv(File file, File target) {
        return file.renameTo(target);
    }

    public static boolean mv(Path file, Path target) {
        try {
            Files.move(file, target, new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean mv(String file, String name) {
        return Files1.mv(new File(file), name);
    }

    public static boolean mv(File file, String name) {
        return file.renameTo(new File(file.getParent(), name));
    }

    public static boolean mv(Path file, String name) {
        try {
            Files.move(file, file.getParent().resolve(name), new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean mkdirs(String path) {
        return new File(path).mkdirs();
    }

    public static boolean mkdirs(File path) {
        return path.mkdirs();
    }

    public static boolean mkdirs(Path path) {
        try {
            Files.createDirectories(path, new java.nio.file.attribute.FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean delete(String file) {
        return Files1.delete(new File(file));
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return Files1.deleteFile(file);
        }
        return Files1.deleteDir(file);
    }

    public static boolean delete(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return true;
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            return Files1.deleteDir(file);
        }
        return Files1.deleteFile(file);
    }

    public static boolean deleteDir(String path) {
        return Files1.deleteDir(new File(path));
    }

    public static boolean deleteDir(File path) {
        if (!path.exists()) {
            return true;
        }
        List<File> files = Files1.listFiles(path, true, true);
        for (File f : files) {
            if (f.isDirectory()) {
                Files1.deleteDir(f);
                continue;
            }
            Files1.deleteFile(f);
        }
        return path.delete();
    }

    public static boolean deleteDir(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return true;
        }
        try {
            Files.list(path).forEach(f -> {
                if (Files.isDirectory(f, new LinkOption[0])) {
                    Files1.deleteDir(f);
                } else {
                    try {
                        Files.delete(f);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            Files.delete(path);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean deleteFile(String file) {
        return Files1.deleteFile(new File(file));
    }

    public static boolean deleteFile(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static boolean deleteFile(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return true;
        }
        try {
            Files.delete(file);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean deleteBigFile(String file) {
        return Files1.deleteBigFile(new File(file));
    }

    public static boolean deleteBigFile(File file) {
        Files1.cleanFile(file);
        return file.delete();
    }

    public static boolean cleanFile(String file) {
        return Files1.cleanFile(new File(file));
    }

    public static boolean cleanFile(File file) {
        if (!file.exists()) {
            return true;
        }
        try (FileWriter fw = new FileWriter(file);){
            fw.write("");
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean cleanFile(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return true;
        }
        try {
            Files.write(file, new byte[0], new OpenOption[0]);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static Date getModifyTime(File file) {
        return new Date(file.lastModified());
    }

    public static Date getModifyTime(String file) {
        return new Date(new File(file).lastModified());
    }

    public static boolean isEmpty(File file) {
        return file.length() == 0L;
    }

    public static boolean isEmpty(String file) {
        return new File(file).length() == 0L;
    }

    public static String getFileLineSeparator(String file) {
        return Files1.getFileLineSeparator(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String getFileLineSeparator(File file) {
        block10: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            r = null;
                            r = new RandomAccessFile(file, "r");
                            length = r.length();
                            if (length != 0L) break block6;
                            var4_4 = "\n";
                            Streams.close(r);
                            return var4_4;
                        }
                        if (length < 2L) ** GOTO lbl29
                        r.seek(length - 2L);
                        bs = new byte[2];
                        r.read(bs);
                        if (bs[0] != 13 || bs[1] != 10) break block7;
                        var5_7 = "\r\n";
                        Streams.close(r);
                        return var5_7;
                    }
                    if (bs[1] != 13) break block8;
                    var5_8 = "\r";
                    Streams.close(r);
                    return var5_8;
                }
                try {
                    break block9;
lbl29:
                    // 1 sources

                    if (length != 1L) break block9;
                    r.seek(length - 1L);
                    if (r.read() != 13) break block9;
                    var4_6 = "\r";
                }
                catch (IOException var2_3) {
                    Streams.close(r);
                    break block10;
                }
                catch (Throwable var6_9) {
                    Streams.close(r);
                    throw var6_9;
                }
                Streams.close(r);
                return var4_6;
            }
            Streams.close(r);
        }
        return "\n";
    }

    public static String getFileEndLineSeparator(String file) {
        return Files1.getFileEndLineSeparator(new File(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileEndLineSeparator(File file) {
        try (RandomAccessFile r = new RandomAccessFile(file, "r");){
            long length = r.length();
            if (length == 0L) {
                String string = "\n";
                return string;
            }
            if (length >= 2L) {
                r.seek(length - 2L);
                byte[] bs = new byte[2];
                r.read(bs);
                if (bs[0] == 13 && bs[1] == 10) {
                    String string = "\r\n";
                    return string;
                }
                if (bs[1] == 13) {
                    String string = "\r";
                    return string;
                }
                if (bs[1] != 10) return null;
                String string = "\n";
                return string;
            }
            if (length != 1L) return null;
            r.seek(length - 1L);
            int read = r.read();
            if (read == 13) {
                String string = "\r";
                return string;
            }
            if (read != 10) return null;
            String string = "\n";
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasEndLineSeparator(String file) {
        return Files1.hasEndLineSeparator(new File(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasEndLineSeparator(File file) {
        try (RandomAccessFile r = new RandomAccessFile(file, "r");){
            long length = r.length();
            if (length == 0L) {
                boolean bl = true;
                return bl;
            }
            if (length < 1L) return false;
            r.seek(length - 1L);
            int s = r.read();
            if (s != 13) {
                if (s != 10) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static int countLines(String file) {
        return Files1.countLines(new File(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int countLines(File file) {
        try (LineNumberReader rf = new LineNumberReader(new InputStreamReader(Files1.openInputStream(file)));){
            rf.skip(file.length());
            int n = rf.getLineNumber();
            return n;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public static FileInputStream openInputStreamSafe(String file) {
        return Files1.openInputStreamSafe(new File(file));
    }

    public static FileInputStream openInputStreamSafe(File file) {
        try {
            return Files1.openInputStream(file);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static FileInputStream openInputStream(String file) throws IOException {
        return Files1.openInputStream(new File(file));
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw Exceptions.io("file '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw Exceptions.io("file '" + file + "' cannot be read");
            }
        } else {
            throw Exceptions.io("file '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStreamSafe(String file) {
        return Files1.openOutputStreamSafe(new File(file), false);
    }

    public static FileOutputStream openOutputStreamSafe(File file) {
        return Files1.openOutputStreamSafe(file, false);
    }

    public static FileOutputStream openOutputStreamSafe(String file, boolean append) {
        return Files1.openOutputStreamSafe(new File(file), append);
    }

    public static FileOutputStream openOutputStreamSafe(File file, boolean append) {
        try {
            return Files1.openOutputStream(file, append);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static FileOutputStream openOutputStream(String file) throws IOException {
        return Files1.openOutputStream(new File(file), false);
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        return Files1.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(String file, boolean append) throws IOException {
        return Files1.openOutputStream(new File(file), append);
    }

    public static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw Exceptions.io("file '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw Exceptions.io("file '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw Exceptions.io("file '" + file + "' could not be created");
            }
        }
        if (append) {
            return new FileOutputStream(file, true);
        }
        return new FileOutputStream(file);
    }

    public static RandomAccessFile openRandomAccessSafe(String file, String mode) {
        return Files1.openRandomAccessSafe(new File(file), mode);
    }

    public static RandomAccessFile openRandomAccessSafe(File file, String mode) {
        try {
            return Files1.openRandomAccess(file, mode);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static RandomAccessFile openRandomAccess(String file, String mode) throws IOException {
        return Files1.openRandomAccess(new File(file), mode);
    }

    public static RandomAccessFile openRandomAccess(File file, String mode) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw Exceptions.io("file '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw Exceptions.io("file '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw Exceptions.io("file '" + file + "' could not be created");
            }
        }
        return new RandomAccessFile(file, mode);
    }

    public static InputStream openInputStreamFastSafe(String file) {
        try {
            return Files1.openInputStreamFast(Paths.get(file, new String[0]));
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static InputStream openInputStreamFastSafe(File file) {
        try {
            return Files1.openInputStreamFast(Paths.get(file.getAbsolutePath(), new String[0]));
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static InputStream openInputStreamFastSafe(Path file) {
        try {
            return Files1.openInputStreamFast(file);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static InputStream openInputStreamFast(String file) throws IOException {
        return Files1.openInputStreamFast(Paths.get(file, new String[0]));
    }

    public static InputStream openInputStreamFast(File file) throws IOException {
        return Files1.openInputStreamFast(Paths.get(file.getAbsolutePath(), new String[0]));
    }

    public static InputStream openInputStreamFast(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                throw Exceptions.io("file '" + file + "' exists but is a directory");
            }
            if (!Files.isReadable(file)) {
                throw Exceptions.io("file '" + file + "' cannot be read");
            }
        } else {
            throw Exceptions.io("file '" + file + "' does not exist");
        }
        return Files.newInputStream(file, new OpenOption[0]);
    }

    public static OutputStream openOutputStreamFastSafe(String file) {
        try {
            return Files1.openOutputStreamFast(Paths.get(file, new String[0]), false);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static OutputStream openOutputStreamFastSafe(File file) {
        try {
            return Files1.openOutputStreamFast(Paths.get(file.getAbsolutePath(), new String[0]), false);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static OutputStream openOutputStreamFastSafe(Path file) {
        try {
            return Files1.openOutputStreamFast(file, false);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static OutputStream openOutputStreamFastSafe(String file, boolean append) {
        try {
            return Files1.openOutputStreamFast(Paths.get(file, new String[0]), append);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static OutputStream openOutputStreamFastSafe(File file, boolean append) {
        try {
            return Files1.openOutputStreamFast(Paths.get(file.getAbsolutePath(), new String[0]), append);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static OutputStream openOutputStreamFastSafe(Path file, boolean append) {
        try {
            return Files1.openOutputStreamFast(file, append);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static OutputStream openOutputStreamFast(String file) throws IOException {
        return Files1.openOutputStreamFast(Paths.get(file, new String[0]), false);
    }

    public static OutputStream openOutputStreamFast(File file) throws IOException {
        return Files1.openOutputStreamFast(Paths.get(file.getAbsolutePath(), new String[0]), false);
    }

    public static OutputStream openOutputStreamFast(Path file) throws IOException {
        return Files1.openOutputStreamFast(file, false);
    }

    public static OutputStream openOutputStreamFast(String file, boolean append) throws IOException {
        return Files1.openOutputStreamFast(Paths.get(file, new String[0]), append);
    }

    public static OutputStream openOutputStreamFast(File file, boolean append) throws IOException {
        return Files1.openOutputStreamFast(Paths.get(file.getAbsolutePath(), new String[0]), append);
    }

    public static OutputStream openOutputStreamFast(Path file, boolean append) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                throw Exceptions.io("file '" + file + "' exists but is a directory");
            }
            if (!Files.isWritable(file)) {
                throw Exceptions.io("file '" + file + "' cannot be written to");
            }
        } else {
            Path parent = file.getParent();
            if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new java.nio.file.attribute.FileAttribute[0]);
            }
            if (append) {
                Files.createFile(file, new java.nio.file.attribute.FileAttribute[0]);
            }
        }
        if (append) {
            return Files.newOutputStream(file, StandardOpenOption.APPEND);
        }
        return Files.newOutputStream(file, new OpenOption[0]);
    }

    public static URL toUrl(Path path) {
        return Files1.toUrl(path.toFile());
    }

    public static URL toUrl(String file) {
        return Files1.toUrl(new File(file));
    }

    public static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (Exception e) {
            throw Exceptions.runtime("file to url error", e);
        }
    }

    public static URI toUri(Path path) {
        return Files1.toUri(path.toFile());
    }

    public static URI toUri(String file) {
        return Files1.toUri(new File(file));
    }

    public static URI toUri(File file) {
        return file.toURI();
    }

    public static List<String> toPaths(List<File> files) {
        ArrayList<String> list = new ArrayList<String>();
        for (File file : files) {
            list.add(file.getAbsolutePath());
        }
        return list;
    }

    public static String[] toPaths(File[] files) {
        int len = files.length;
        String[] ss = new String[len];
        for (int i = 0; i < len; ++i) {
            ss[i] = files[i].getAbsolutePath();
        }
        return ss;
    }

    public static List<File> toFiles(List<String> files) {
        ArrayList<File> list = new ArrayList<File>();
        for (String file : files) {
            list.add(new File(file));
        }
        return list;
    }

    public static File[] toFiles(String[] files) {
        int len = files.length;
        File[] ss = new File[len];
        for (int i = 0; i < len; ++i) {
            ss[i] = new File(files[i]);
        }
        return ss;
    }

    public static List<URL> toUrls(List<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            urls.add(Files1.toUrl(file));
        }
        return urls;
    }

    public static URL[] toUrls(File[] files) {
        int len = files.length;
        URL[] urls = new URL[len];
        for (int i = 0; i < len; ++i) {
            urls[i] = Files1.toUrl(files[i]);
        }
        return urls;
    }

    public static List<URI> toUris(List<File> files) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (File file : files) {
            uris.add(Files1.toUri(file));
        }
        return uris;
    }

    public static URI[] toUris(File[] files) {
        int len = files.length;
        URI[] uris = new URI[len];
        for (int i = 0; i < len; ++i) {
            uris[i] = Files1.toUri(files[i]);
        }
        return uris;
    }

    public static String getRootPath(String path) {
        if (Strings.isBlank(path)) {
            return System.getProperty(Systems.HOME_DIR);
        }
        if ((path = path.trim()).startsWith(WINDOWS_SEPARATOR) || path.startsWith(SEPARATOR)) {
            return Files1.replacePath(Systems.HOME_DIR + path);
        }
        return Files1.replacePath(Systems.HOME_DIR + File.separator + path);
    }

    public static String getRootPathFile(String path, String file) {
        path = Files1.getRootPath(path);
        if (!((file = file.trim()).startsWith(WINDOWS_SEPARATOR) || file.startsWith(SEPARATOR) || path.endsWith(WINDOWS_SEPARATOR) || path.endsWith(SEPARATOR))) {
            path = path + SEPARATOR + file;
        }
        return Files1.replacePath(path);
    }

    public static String replacePath(String path) {
        if (WINDOWS_SEPARATOR.equals(File.separator) && WINDOWS_SEPARATOR.equals((path = path.replaceAll(LINUX_SEPARATOR_REG, WINDOWS_SEPARATOR_REPLICE)).substring(0, 1))) {
            path = path.substring(1);
        }
        if (SEPARATOR.equals(File.separator)) {
            path = path.replaceAll(WINDOWS_SEPARATOR_REG, SEPARATOR);
        }
        return path;
    }

    public static boolean isWindowsPath(String path) {
        return Matches.isWindowsPath(path);
    }

    public static boolean isLinuxPath(String path) {
        return Matches.isLinuxPath(path);
    }

    public static boolean isPath(String path) {
        return Matches.isWindowsPath(path) || Matches.isLinuxPath(path);
    }

    public static String getSuffix(File file) {
        return Files1.getSuffix(file.getName());
    }

    public static String getSuffix(String file) {
        int i = file.lastIndexOf(".");
        if (i == -1) {
            return "";
        }
        return file.substring(i + 1);
    }

    public static String getFileName(String file) {
        if ((file = Files1.getPath(file)).equals(SEPARATOR)) {
            return SEPARATOR;
        }
        String[] paths = file.split(SEPARATOR);
        return paths[paths.length - 1];
    }

    public static String getFileName(File file) {
        return file.getName();
    }

    public static String getParentPath(String file) {
        String[] paths = Files1.getPath(file).split(SEPARATOR);
        StringBuilder sb = new StringBuilder();
        int len = paths.length - 1;
        for (int i = 0; i < len; ++i) {
            sb.append(paths[i]).append(SEPARATOR);
        }
        return sb.toString();
    }

    public static String getParentPath(File file) {
        return file.getParent();
    }

    public static List<String> getParentPaths(String file) {
        StringBuilder sb;
        file = Files1.getPath(file);
        String[] paths = file.split(SEPARATOR);
        ArrayList<String> list = new ArrayList<String>();
        if (paths[0].contains(":")) {
            sb = new StringBuilder(paths[0] + SEPARATOR);
            paths[0] = null;
        } else {
            sb = new StringBuilder(SEPARATOR);
        }
        int len = paths.length - 1;
        for (int i = 0; i < len; ++i) {
            String path = paths[i];
            if (Strings.isBlank(path)) continue;
            list.add(sb.append(path).toString());
            sb.append(SEPARATOR);
        }
        return list;
    }

    public static List<String> getParentPaths(File file) {
        return Files1.getParentPaths(file.getAbsolutePath());
    }

    public static String getPath(String parent, String path) {
        return Files1.getPath(parent + SEPARATOR + path);
    }

    public static String getPath(String path) {
        return path.replaceAll(WINDOWS_SEPARATOR_REG, SEPARATOR).replaceAll(LINUX_SEPARATOR_REG, SEPARATOR);
    }

    public static String getWindowsPath(String path) {
        return path.replaceAll(WINDOWS_SEPARATOR_REG, WINDOWS_SEPARATOR_REPLICE).replaceAll(LINUX_SEPARATOR_REG, WINDOWS_SEPARATOR_REPLICE);
    }

    public static String normalize(String path) {
        String p;
        String pre;
        String separator;
        String[] paths = path.split(":");
        if (paths.length == 1) {
            separator = SEPARATOR;
            pre = SEPARATOR;
            p = paths[0];
        } else {
            separator = WINDOWS_SEPARATOR;
            pre = paths[0] + ":" + WINDOWS_SEPARATOR;
            p = paths[1];
        }
        StringBuilder sb = new StringBuilder(pre);
        String[] ps = Files1.getPath(p).split(SEPARATOR);
        for (int i = 0; i < ps.length; ++i) {
            String s = ps[i];
            if (Strings.isBlank(s) || ".".equals(s)) continue;
            if ("..".equals(s)) {
                sb.delete(Files1.getParentPath(sb.toString()).length(), sb.length());
                continue;
            }
            if (i == ps.length - 1) {
                sb.append(s);
                continue;
            }
            sb.append(s).append(separator);
        }
        int len = sb.length();
        if (len > 1 && sb.charAt(len - 1) == '/') {
            return sb.deleteCharAt(len - 1).toString();
        }
        return sb.toString();
    }

    public static boolean isNormalize(String path) {
        String[] ps = Files1.getPath(path).split(SEPARATOR);
        for (int i = 0; i < ps.length; ++i) {
            String s = ps[i];
            if (".".equals(s)) {
                return false;
            }
            if (!"..".equals(s)) continue;
            return false;
        }
        return true;
    }

    public static String getPathPrefix(String path) {
        String[] paths = Files1.getPath(path).split(":");
        if (paths.length == 1) {
            return SEPARATOR;
        }
        return paths[0] + ":\\";
    }

    public static String omitPath(String path, int length) {
        return Files1.omitPath(path, length, "...");
    }

    public static String omitPath(String path, int length, String omit) {
        path = Files1.getPath(path);
        String prefix = Files1.getPathPrefix(path);
        String lastPath = path.substring(path.lastIndexOf(SEPARATOR));
        if (lastPath.length() > length + omit.length()) {
            return prefix + omit + lastPath.substring(0, length) + omit;
        }
        if (lastPath.length() == length) {
            return prefix + omit + lastPath.substring(0, length);
        }
        String firstPath = path.substring(0, path.length() - lastPath.length());
        if (firstPath.length() > (length -= lastPath.length()) + omit.length()) {
            return path.substring(0, length) + omit + lastPath;
        }
        return path;
    }

    public static int permission10to8(int permission) {
        return Integer.parseInt(new BigInteger(permission + "", 8).toString(10));
    }

    public static int permission8to10(int permission) {
        return Integer.parseInt(new BigInteger(permission + "", 10).toString(8));
    }

    public static String permission10toString(int permission) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        for (char c : chars = String.valueOf(permission).toCharArray()) {
            int per = Integer.parseInt(c + "");
            if ((per & 4) == 0) {
                sb.append('-');
            } else {
                sb.append('r');
            }
            if ((per & 2) == 0) {
                sb.append('-');
            } else {
                sb.append('w');
            }
            if ((per & 1) == 0) {
                sb.append('-');
                continue;
            }
            sb.append('x');
        }
        return sb.toString();
    }

    public static int permissionStringTo10(String permission) {
        StringBuilder res = new StringBuilder();
        char[] chars = permission.toCharArray();
        int length = chars.length;
        if (length % 3 != 0) {
            return -1;
        }
        for (int i = 0; i < length / 3; ++i) {
            int single = 0;
            block6: for (int j = 0; j < 3; ++j) {
                char per = chars[i * 3 + j];
                switch (per) {
                    case 'r': {
                        single += 4;
                        continue block6;
                    }
                    case 'w': {
                        single += 2;
                        continue block6;
                    }
                    case 'x': {
                        ++single;
                        continue block6;
                    }
                }
            }
            res.append(single);
        }
        return Integer.parseInt(res.toString());
    }

    public static String md5(File file) {
        return Files1.sign(file, HashDigest.MD5);
    }

    public static String md5(String file) {
        return Files1.sign(new File(file), HashDigest.MD5);
    }

    public static String sha1(File file) {
        return Files1.sign(file, HashDigest.SHA1);
    }

    public static String sha1(String file) {
        return Files1.sign(new File(file), HashDigest.SHA1);
    }

    public static String sha224(File file) {
        return Files1.sign(file, HashDigest.SHA224);
    }

    public static String sha224(String file) {
        return Files1.sign(new File(file), HashDigest.SHA224);
    }

    public static String sha256(File file) {
        return Files1.sign(file, HashDigest.SHA256);
    }

    public static String sha256(String file) {
        return Files1.sign(new File(file), HashDigest.SHA256);
    }

    public static String sha384(File file) {
        return Files1.sign(file, HashDigest.SHA384);
    }

    public static String sha384(String file) {
        return Files1.sign(new File(file), HashDigest.SHA384);
    }

    public static String sha512(File file) {
        return Files1.sign(file, HashDigest.SHA512);
    }

    public static String sha512(String file) {
        return Files1.sign(new File(file), HashDigest.SHA512);
    }

    public static String sign(String file, HashDigest type) {
        return Files1.sign(new File(file), type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sign(File file, HashDigest type) {
        if (file == null) return null;
        if (!file.exists()) return null;
        if (!file.isFile()) {
            return null;
        }
        try (FileInputStream in = Files1.openInputStream(file);){
            String string = Streams.sign(in, type);
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<File> listDirs(String path) {
        return Files1.listDirs(new File(path), false);
    }

    public static List<File> listDirs(File path) {
        return Files1.listDirs(path, false);
    }

    public static List<File> listDirs(String path, boolean child) {
        return Files1.listDirs(new File(path), child);
    }

    public static List<File> listDirs(File path, boolean child) {
        ArrayList<File> list = new ArrayList<File>();
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                list.add(file);
                if (!child) continue;
                list.addAll(Files1.listDirs(file, true));
            }
        }
        return list;
    }

    public static List<File> listFiles(File path) {
        return Files1.listFiles(path, false, false);
    }

    public static List<File> listFiles(String path) {
        return Files1.listFiles(new File(path), false, false);
    }

    public static List<File> listFiles(String path, boolean child) {
        return Files1.listFiles(new File(path), child, false);
    }

    public static List<File> listFiles(File path, boolean child) {
        return Files1.listFiles(path, child, false);
    }

    public static List<File> listFiles(String path, boolean child, boolean dir) {
        return Files1.listFiles(new File(path), child, dir);
    }

    public static List<File> listFiles(File path, boolean child, boolean dir) {
        ArrayList<File> list = new ArrayList<File>();
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    list.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                if (dir) {
                    list.add(file);
                }
                if (!child) continue;
                list.addAll(Files1.listFiles(file, true, dir));
            }
        }
        return list;
    }

    public static List<File> listFilesSuffix(String dirPath, String suffix) {
        return Files1.listFilesSuffix(new File(dirPath), suffix, false, false);
    }

    public static List<File> listFilesSuffix(String dirPath, String suffix, boolean child) {
        return Files1.listFilesSuffix(new File(dirPath), suffix, child, false);
    }

    public static List<File> listFilesSuffix(String dirPath, String suffix, boolean child, boolean dir) {
        return Files1.listFilesSuffix(new File(dirPath), suffix, child, dir);
    }

    public static List<File> listFilesSuffix(File dirPath, String suffix) {
        return Files1.listFilesSuffix(dirPath, suffix, false, false);
    }

    public static List<File> listFilesSuffix(File dirPath, String suffix, boolean child) {
        return Files1.listFilesSuffix(dirPath, suffix, child, false);
    }

    public static List<File> listFilesSuffix(File dirPath, String suffix, boolean child, boolean dir) {
        return Files1.listFilesSearch(dirPath, FileFilter.suffix(suffix), child, dir);
    }

    public static List<File> listFilesMatch(String dirPath, String name) {
        return Files1.listFilesMatch(new File(dirPath), name, false, false);
    }

    public static List<File> listFilesMatch(String dirPath, String name, boolean child) {
        return Files1.listFilesMatch(new File(dirPath), name, child, false);
    }

    public static List<File> listFilesMatch(String dirPath, String name, boolean child, boolean dir) {
        return Files1.listFilesMatch(new File(dirPath), name, child, dir);
    }

    public static List<File> listFilesMatch(File dirPath, String name) {
        return Files1.listFilesMatch(dirPath, name, false, false);
    }

    public static List<File> listFilesMatch(File dirPath, String name, boolean child) {
        return Files1.listFilesMatch(dirPath, name, child, false);
    }

    public static List<File> listFilesMatch(File dirPath, String name, boolean child, boolean dir) {
        return Files1.listFilesSearch(dirPath, FileFilter.match(name), child, dir);
    }

    public static List<File> listFilesPattern(String dirPath, Pattern pattern) {
        return Files1.listFilesPattern(new File(dirPath), pattern, false, false);
    }

    public static List<File> listFilesPattern(String dirPath, Pattern pattern, boolean child) {
        return Files1.listFilesPattern(new File(dirPath), pattern, child, false);
    }

    public static List<File> listFilesPattern(String dirPath, Pattern pattern, boolean child, boolean dir) {
        return Files1.listFilesPattern(new File(dirPath), pattern, child, dir);
    }

    public static List<File> listFilesPattern(File dirPath, Pattern pattern) {
        return Files1.listFilesPattern(dirPath, pattern, false, false);
    }

    public static List<File> listFilesPattern(File dirPath, Pattern pattern, boolean child) {
        return Files1.listFilesPattern(dirPath, pattern, child, false);
    }

    public static List<File> listFilesPattern(File dirPath, Pattern pattern, boolean child, boolean dir) {
        return Files1.listFilesSearch(dirPath, FileFilter.pattern(pattern), child, dir);
    }

    public static List<File> listFilesFilter(String dirPath, FileFilter filter) {
        return Files1.listFilesFilter(new File(dirPath), filter, false, false);
    }

    public static List<File> listFilesFilter(String dirPath, FileFilter filter, boolean child) {
        return Files1.listFilesFilter(new File(dirPath), filter, child, false);
    }

    public static List<File> listFilesFilter(String dirPath, FileFilter filter, boolean child, boolean dir) {
        return Files1.listFilesFilter(new File(dirPath), filter, child, dir);
    }

    public static List<File> listFilesFilter(File dirPath, FileFilter filter) {
        return Files1.listFilesFilter(dirPath, filter, false, false);
    }

    public static List<File> listFilesFilter(File dirPath, FileFilter filter, boolean child) {
        return Files1.listFilesFilter(dirPath, filter, child, false);
    }

    public static List<File> listFilesFilter(File dirPath, FileFilter filter, boolean child, boolean dir) {
        return Files1.listFilesSearch(dirPath, filter, child, dir);
    }

    private static List<File> listFilesSearch(File dirPath, FileFilter filter, boolean child, boolean dir) {
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dirPath.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean isDir = file.isDirectory();
                if ((!isDir || dir) && filter.accept(file, file.getName())) {
                    list.add(file);
                }
                if (!isDir || !child) continue;
                list.addAll(Files1.listFilesSearch(file, filter, true, dir));
            }
        }
        return list;
    }
}

