/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.ext.dom;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.ext.dom.DomBeanWrapper;
import com.orion.lang.utils.ext.dom.DomNode;
import com.orion.lang.utils.ext.dom.DomParser;
import com.orion.lang.utils.ext.dom.DomStream;
import com.orion.lang.utils.ext.dom.DomSupport;
import com.orion.lang.utils.io.Files1;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class DomExt {
    private final SAXReader reader = new SAXReader();
    private final Document document;

    public DomExt(File file) {
        try {
            this.document = this.reader.read((InputStream)Files1.openInputStreamSafe(file));
        }
        catch (Exception e) {
            throw Exceptions.parse(e);
        }
    }

    public DomExt(String xml) {
        this(DomSupport.toDocument(xml));
    }

    public DomExt(InputStream in) {
        try {
            this.document = this.reader.read(in);
        }
        catch (Exception e) {
            throw Exceptions.parse(e);
        }
    }

    public DomExt(Document document) {
        this.document = document;
    }

    public static DomExt of(File file) {
        return new DomExt(file);
    }

    public static DomExt of(String xml) {
        return new DomExt(xml);
    }

    public static DomExt of(InputStream in) {
        return new DomExt(in);
    }

    public static DomExt of(Document document) {
        return new DomExt(document);
    }

    public DomStream stream() {
        return new DomStream(this.document.getRootElement());
    }

    public Element parse(String formula) {
        return new DomParser(this.document.getRootElement(), formula).getElement();
    }

    public String parseValue(String formula) {
        return new DomParser(this.document.getRootElement(), formula).getElementValue();
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getRootElement() {
        return this.document.getRootElement();
    }

    public Map<String, List<Element>> getRootElements() {
        return DomSupport.getElements(this.document.getRootElement());
    }

    public Map<String, Object> toMap() {
        return this.toMap((Class)null);
    }

    public Map<String, Object> toMap(Class<?> mapClass) {
        return DomBeanWrapper.toMap(this.document.getRootElement(), mapClass);
    }

    public Map<String, Object> toMap(String formula) {
        return this.toMap(formula, null);
    }

    public Map<String, Object> toMap(String formula, Class<?> mapClass) {
        Element element = new DomParser(this.document.getRootElement(), formula).getElement();
        return DomBeanWrapper.toMap(element, mapClass);
    }

    public <T> T toBean(Class<T> clazz) {
        return this.toBean(clazz, null);
    }

    public <T> T toBean(Class<T> clazz, Map<String, Object> convertMapper) {
        return DomBeanWrapper.toBean(this.document.getRootElement(), clazz, convertMapper);
    }

    public <T> T toBean(String formula, Class<T> clazz) {
        return this.toBean(formula, clazz, null);
    }

    public <T> T toBean(String formula, Class<T> clazz, Map<String, Object> convertMapper) {
        Element element = new DomParser(this.document.getRootElement(), formula).getElement();
        return DomBeanWrapper.toBean(element, clazz, convertMapper);
    }

    public Map<String, DomNode> toDomNode() {
        return DomBeanWrapper.toDomNode(this.document.getRootElement());
    }

    public Map<String, DomNode> toDomNode(String formula) {
        Element element = new DomParser(this.document.getRootElement(), formula).getElement();
        return DomBeanWrapper.toDomNode(element);
    }

    public DomExt cleanComment() {
        DomSupport.cleanComment(this.document.getRootElement());
        return this;
    }

    public String toXml() {
        return this.document.asXML();
    }

    public String format() {
        return DomSupport.format(this.document);
    }

    public String format(OutputFormat format) {
        return DomSupport.format(this.document, format);
    }

    public String toString() {
        return this.document.asXML();
    }
}

