/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.ext.dom;

import com.orion.lang.utils.Exceptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DomElement
implements Serializable {
    private String name;
    private Map<String, String> attributes;
    private List<DomElement> childNode;
    private String value;
    private boolean cdata;

    public DomElement(String name) {
        this(name, null);
    }

    public DomElement(String name, String value) {
        this.name = name;
        this.value = value;
        this.cdata = false;
    }

    public String getName() {
        return this.name;
    }

    public DomElement setName(String name) {
        this.name = name;
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public DomElement addAttributes(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        this.attributes.put(key, value);
        return this;
    }

    public DomElement setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public DomElement newChildNode(String name) {
        if (this.value != null) {
            throw Exceptions.argument("value is not null");
        }
        if (this.childNode == null) {
            this.childNode = new ArrayList<DomElement>();
        }
        DomElement domElement = new DomElement(name);
        this.childNode.add(domElement);
        return domElement;
    }

    public List<DomElement> getChildNode() {
        return this.childNode;
    }

    public DomElement addChildNode(DomElement child) {
        if (this.value != null) {
            throw Exceptions.argument("value is not null");
        }
        if (this.childNode == null) {
            this.childNode = new ArrayList<DomElement>();
        }
        this.childNode.add(child);
        return this;
    }

    public DomElement setChildNode(List<DomElement> childNode) {
        if (this.value != null) {
            throw Exceptions.argument("value is not null");
        }
        this.childNode = childNode;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public DomElement setValue(String value) {
        if (this.childNode != null) {
            throw Exceptions.argument("childNode is not null");
        }
        this.value = value;
        return this;
    }

    public DomElement cdata() {
        this.cdata = true;
        return this;
    }

    public boolean isCdata() {
        return this.cdata;
    }
}

