/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.ext;

import com.orion.lang.define.collect.MutableHashMap;
import com.orion.lang.define.collect.MutableHashSet;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class PropertiesExt {
    private Properties properties = new Properties();

    public PropertiesExt() {
    }

    public PropertiesExt(Map<?, ?> map) {
        map.forEach((? super K k, ? super V v) -> this.properties.put(k.toString(), v.toString()));
    }

    public PropertiesExt(String path) {
        this(new File(path));
    }

    public PropertiesExt(File file) {
        this(Files1.openInputStreamSafe(file), true);
    }

    public PropertiesExt(InputStream in) {
        this(in, false);
    }

    public PropertiesExt(InputStream in, boolean close) {
        try {
            this.properties.load(in);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
        finally {
            if (close) {
                Streams.close(in);
            }
        }
    }

    public static PropertiesExt loadSystem() {
        return new PropertiesExt(System.getProperties());
    }

    public String getValue(String key) {
        return this.properties.getProperty(key);
    }

    public String getValue(String key, String def) {
        return this.properties.getProperty(key, def);
    }

    public MutableHashMap<Object, Object> getValues() {
        return new MutableHashMap<Object, Object>(this.properties);
    }

    public MutableHashSet<Object> getKeys() {
        return new MutableHashSet<Object>(this.properties.keySet());
    }

    public PropertiesExt setValue(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public PropertiesExt setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public void writeToFile(File file) throws IOException {
        Files1.touch(file);
        this.properties.store(Files1.openOutputStream(file), "#");
    }

    public void writeToXml(File file) throws IOException {
        Files1.touch(file);
        this.properties.storeToXML(Files1.openOutputStream(file), "#");
    }

    public void writeToXml(File file, String charset) throws IOException {
        Files1.touch(file);
        this.properties.storeToXML((OutputStream)Files1.openOutputStream(file), "#", charset);
    }

    public PropertiesExt storeSystem() {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            System.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return this;
    }

    public void forEach(BiConsumer<Object, Object> action) {
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)action);
    }
}

