/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.crypto.symmetric;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.codec.Base64s;
import com.orion.lang.utils.crypto.enums.CipherAlgorithm;
import com.orion.lang.utils.crypto.enums.PaddingMode;
import com.orion.lang.utils.crypto.enums.WorkingMode;
import com.orion.lang.utils.crypto.symmetric.BaseSymmetric;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class ParamSymmetric
extends BaseSymmetric {
    private final AlgorithmParameterSpec paramSpec;
    private byte[] aad;

    public ParamSymmetric(CipherAlgorithm cipherAlgorithm, WorkingMode workingMode, SecretKey secretKey, AlgorithmParameterSpec paramSpec) {
        this(cipherAlgorithm, workingMode, PaddingMode.PKCS5_PADDING, secretKey, paramSpec);
    }

    public ParamSymmetric(CipherAlgorithm cipherAlgorithm, WorkingMode workingMode, PaddingMode paddingMode, SecretKey secretKey, AlgorithmParameterSpec paramSpec) {
        super(cipherAlgorithm, workingMode, paddingMode, secretKey);
        this.paramSpec = Valid.notNull(paramSpec, "paramSpec is null", new Object[0]);
    }

    public void setAad(String aad) {
        this.aad = Strings.bytes(aad);
    }

    public void setAad(byte[] aad) {
        this.aad = aad;
    }

    @Override
    public byte[] encrypt(byte[] plain) {
        try {
            Cipher cipher = super.getCipher();
            cipher.init(1, (Key)this.secretKey, this.paramSpec);
            if (this.aad != null) {
                cipher.updateAAD(this.aad);
            }
            return Base64s.encode(cipher.doFinal(this.zeroPadding(plain, cipher.getBlockSize())));
        }
        catch (Exception e) {
            throw Exceptions.encrypt("encrypt data error", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] text) {
        try {
            Cipher cipher = super.getCipher();
            cipher.init(2, (Key)this.secretKey, this.paramSpec);
            if (this.aad != null) {
                cipher.updateAAD(this.aad);
            }
            return this.clearZeroPadding(cipher.doFinal(Base64s.decode(text)));
        }
        catch (Exception e) {
            throw Exceptions.encrypt("decrypt data error", e);
        }
    }
}

