/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.crypto.symmetric;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.codec.Base64s;
import com.orion.lang.utils.crypto.enums.CipherAlgorithm;
import com.orion.lang.utils.crypto.enums.PaddingMode;
import com.orion.lang.utils.crypto.enums.WorkingMode;
import com.orion.lang.utils.crypto.symmetric.BaseSymmetric;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class EcbSymmetric
extends BaseSymmetric {
    public EcbSymmetric(CipherAlgorithm algorithm, SecretKey secretKey) {
        this(algorithm, PaddingMode.PKCS5_PADDING, secretKey);
    }

    public EcbSymmetric(CipherAlgorithm algorithm, PaddingMode paddingMode, SecretKey secretKey) {
        super(algorithm, WorkingMode.ECB, paddingMode, secretKey);
    }

    @Override
    public byte[] encrypt(byte[] plain) {
        try {
            Cipher cipher = super.getCipher();
            cipher.init(1, this.secretKey);
            return Base64s.encode(cipher.doFinal(this.zeroPadding(plain, cipher.getBlockSize())));
        }
        catch (Exception e) {
            throw Exceptions.encrypt("encrypt data error", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] text) {
        try {
            Cipher cipher = super.getCipher();
            cipher.init(2, this.secretKey);
            return this.clearZeroPadding(cipher.doFinal(Base64s.decode(text)));
        }
        catch (Exception e) {
            throw Exceptions.encrypt("decrypt data error", e);
        }
    }
}

