/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.crypto.symmetric;

import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.crypto.enums.CipherAlgorithm;
import com.orion.lang.utils.crypto.enums.PaddingMode;
import com.orion.lang.utils.crypto.enums.WorkingMode;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public abstract class BaseSymmetric {
    protected CipherAlgorithm algorithm;
    protected WorkingMode workingMode;
    protected PaddingMode paddingMode;
    protected SecretKey secretKey;

    protected BaseSymmetric(CipherAlgorithm cipherAlgorithm, WorkingMode workingMode, PaddingMode paddingMode, SecretKey secretKey) {
        this.algorithm = Valid.notNull(cipherAlgorithm, "cipherAlgorithm is null", new Object[0]);
        this.workingMode = Valid.notNull(workingMode, "workingMode is null", new Object[0]);
        this.paddingMode = Valid.notNull(paddingMode, "paddingMode is null", new Object[0]);
        this.secretKey = Valid.notNull(secretKey, "secretKey is null", new Object[0]);
    }

    public byte[] encrypt(String plain) {
        return this.encrypt(Strings.bytes(plain));
    }

    public String encryptAsString(String plain) {
        return new String(this.encrypt(Strings.bytes(plain)));
    }

    public String encryptAsString(byte[] plain) {
        return new String(this.encrypt(plain));
    }

    public abstract byte[] encrypt(byte[] var1);

    public byte[] decrypt(String text) {
        return this.decrypt(Strings.bytes(text));
    }

    public String decryptAsString(String text) {
        return new String(this.decrypt(Strings.bytes(text)));
    }

    public String decryptAsString(byte[] text) {
        return new String(this.decrypt(text));
    }

    public abstract byte[] decrypt(byte[] var1);

    public boolean verify(String plain, String text) {
        try {
            return plain.equals(this.decryptAsString(text));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verify(byte[] plain, byte[] text) {
        try {
            return Arrays.equals(plain, this.decrypt(text));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Cipher getCipher() {
        return this.algorithm.getCipher(this.workingMode, this.paddingMode);
    }

    protected byte[] clearZeroPadding(byte[] bytes) {
        if (!PaddingMode.ZERO_PADDING.equals((Object)this.paddingMode)) {
            return bytes;
        }
        int f = bytes.length;
        for (int i = 0; i < f; ++i) {
            if (bytes[i] != 0) continue;
            f = i;
            break;
        }
        if (f == bytes.length) {
            return bytes;
        }
        byte[] res = new byte[f];
        System.arraycopy(bytes, 0, res, 0, f);
        return res;
    }

    protected byte[] zeroPadding(byte[] bytes, int blockSize) {
        if (!PaddingMode.ZERO_PADDING.equals((Object)this.paddingMode)) {
            return bytes;
        }
        if (bytes.length % blockSize == 0) {
            return bytes;
        }
        int newSize = (bytes.length / blockSize + 1) * blockSize;
        byte[] res = new byte[newSize];
        System.arraycopy(bytes, 0, res, 0, bytes.length);
        return res;
    }

    public CipherAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public WorkingMode getWorkingMode() {
        return this.workingMode;
    }

    public PaddingMode getPaddingMode() {
        return this.paddingMode;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }
}

