/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.crypto.enums;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import java.security.MessageDigest;

public enum HashDigest {
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA224("SHA-224"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512");

    private final String digest;

    private HashDigest(String digest) {
        this.digest = digest;
    }

    public String getDigest() {
        return this.digest;
    }

    public MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.digest);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public static MessageDigest getMessageDigest(String digest) {
        HashDigest[] values;
        if (Strings.isBlank(digest)) {
            return null;
        }
        for (HashDigest value : values = HashDigest.values()) {
            if (!value.getDigest().equalsIgnoreCase(digest.trim())) continue;
            return value.getMessageDigest();
        }
        return null;
    }
}

