/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.crypto;

import com.orion.lang.utils.crypto.enums.WorkingMode;
import com.orion.lang.utils.crypto.symmetric.SymmetricBuilder;
import javax.crypto.SecretKey;

public class SM4 {
    private SM4() {
    }

    public static String encrypt(String s, String key) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.ECB).generatorSecretKey(key).buildEcb().encryptAsString(s);
    }

    public static String encrypt(String s, SecretKey key) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.ECB).secretKey(key).buildEcb().encryptAsString(s);
    }

    public static byte[] encrypt(byte[] s, byte[] key) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.ECB).secretKey(key).buildEcb().encrypt(s);
    }

    public static byte[] encrypt(byte[] s, SecretKey key) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.ECB).secretKey(key).buildEcb().encrypt(s);
    }

    public static String encrypt(String s, String key, String iv) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.CBC).generatorSecretKey(key).ivSpec(iv).buildParam().encryptAsString(s);
    }

    public static String encrypt(String s, SecretKey key, String iv) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.CBC).secretKey(key).ivSpec(iv).buildParam().encryptAsString(s);
    }

    public static byte[] encrypt(byte[] s, byte[] key, byte[] iv) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.CBC).secretKey(key).ivSpec(iv).buildParam().encrypt(s);
    }

    public static byte[] encrypt(byte[] s, SecretKey key, byte[] iv) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.CBC).secretKey(key).ivSpec(iv).buildParam().encrypt(s);
    }

    public static String decrypt(String s, String key) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.ECB).generatorSecretKey(key).buildEcb().decryptAsString(s);
    }

    public static String decrypt(String s, SecretKey key) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.ECB).secretKey(key).buildEcb().decryptAsString(s);
    }

    public static byte[] decrypt(byte[] s, byte[] key) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.ECB).secretKey(key).buildEcb().decrypt(s);
    }

    public static byte[] decrypt(byte[] s, SecretKey key) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.ECB).secretKey(key).buildEcb().decrypt(s);
    }

    public static String decrypt(String s, String key, String iv) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.CBC).generatorSecretKey(key).ivSpec(iv).buildParam().decryptAsString(s);
    }

    public static String decrypt(String s, SecretKey key, String iv) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.CBC).secretKey(key).ivSpec(iv).buildParam().decryptAsString(s);
    }

    public static byte[] decrypt(byte[] s, byte[] key, byte[] iv) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.CBC).secretKey(key).ivSpec(iv).buildParam().decrypt(s);
    }

    public static byte[] decrypt(byte[] s, SecretKey key, byte[] iv) {
        return SymmetricBuilder.sm4().workingMode(WorkingMode.CBC).secretKey(key).ivSpec(iv).buildParam().decrypt(s);
    }
}

