/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.collect;

import com.orion.lang.define.collect.FixedDeque;
import com.orion.lang.define.collect.FixedQueue;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.collect.Collections;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.function.Supplier;

public class Queues
extends Collections {
    private Queues() {
    }

    public static <E> Queue<E> newQueue() {
        return new ConcurrentLinkedQueue();
    }

    public static <E> Queue<E> newQueue(Collection<E> c) {
        return new ConcurrentLinkedQueue<E>(c);
    }

    public static <E> Deque<E> newDeque() {
        return new ConcurrentLinkedDeque();
    }

    public static <E> Deque<E> newDeque(Collection<E> c) {
        return new ConcurrentLinkedDeque<E>(c);
    }

    public static <E> Queue<E> newLimitQueue(int size) {
        return new FixedQueue(size);
    }

    public static <E> Deque<E> newLimitDeque(int size) {
        return new FixedDeque(size);
    }

    public static <E> Queue<E> def(Queue<E> q) {
        return q == null ? new ConcurrentLinkedQueue() : q;
    }

    public static <E> Deque<E> def(Deque<E> d) {
        return d == null ? new ConcurrentLinkedDeque() : d;
    }

    public static <E> Queue<E> def(Queue<E> q, Queue<E> def) {
        return q == null ? def : q;
    }

    public static <E> Deque<E> def(Deque<E> d, Deque<E> def) {
        return d == null ? def : d;
    }

    public static <E> Queue<E> def(Queue<E> q, Supplier<Queue<E>> def) {
        return q == null ? def.get() : q;
    }

    public static <E> Deque<E> def(Deque<E> d, Supplier<Deque<E>> def) {
        return d == null ? def.get() : d;
    }

    @SafeVarargs
    public static <E> Queue<E> of(E ... e) {
        return new ConcurrentLinkedQueue<E>(Arrays.asList(e));
    }

    @SafeVarargs
    public static <E> Deque<E> ofd(E ... e) {
        return new ConcurrentLinkedDeque<E>(Arrays.asList(e));
    }

    @SafeVarargs
    public static <E, V> Queue<E> of(Function<V, E> f, V ... e) {
        Valid.notNull(f, "convert function is null", new Object[0]);
        ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue<E>();
        int length = Arrays1.length(e);
        for (int i = 0; i < length; ++i) {
            q.add(f.apply(e[i]));
        }
        return q;
    }

    @SafeVarargs
    public static <E, V> Deque<E> ofd(Function<V, E> f, V ... e) {
        Valid.notNull(f, "convert function is null", new Object[0]);
        ConcurrentLinkedDeque<E> q = new ConcurrentLinkedDeque<E>();
        int length = Arrays1.length(e);
        for (int i = 0; i < length; ++i) {
            q.add(f.apply(e[i]));
        }
        return q;
    }

    public static <E, V> Queue<E> map(Queue<V> l, Function<V, E> f) {
        Valid.notNull(f, "convert function is null", new Object[0]);
        ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue<E>();
        if (Queues.isEmpty(l)) {
            return q;
        }
        for (Object v : l) {
            q.add(f.apply(v));
        }
        return q;
    }

    public static <E, V> Deque<E> map(Deque<V> l, Function<V, E> f) {
        Valid.notNull(f, "convert function is null", new Object[0]);
        ConcurrentLinkedDeque<E> q = new ConcurrentLinkedDeque<E>();
        if (Queues.isEmpty(l)) {
            return q;
        }
        for (V v : l) {
            q.add(f.apply(v));
        }
        return q;
    }

    public static <E> Queue<E> as(Iterator<E> iterator) {
        ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue<E>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                q.add(iterator.next());
            }
        }
        return q;
    }

    public static <E> Deque<E> asd(Iterator<E> iterator) {
        ConcurrentLinkedDeque<E> q = new ConcurrentLinkedDeque<E>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                q.add(iterator.next());
            }
        }
        return q;
    }

    public static <E> Queue<E> as(Enumeration<E> iterator) {
        ConcurrentLinkedQueue<E> q = new ConcurrentLinkedQueue<E>();
        if (iterator != null) {
            while (iterator.hasMoreElements()) {
                q.add(iterator.nextElement());
            }
        }
        return q;
    }

    public static <E> Deque<E> asd(Enumeration<E> iterator) {
        ConcurrentLinkedDeque<E> q = new ConcurrentLinkedDeque<E>();
        if (iterator != null) {
            while (iterator.hasMoreElements()) {
                q.add(iterator.nextElement());
            }
        }
        return q;
    }
}

