/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.collect;

import com.orion.lang.utils.Strings;
import com.orion.lang.utils.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class Collections {
    protected Collections() {
    }

    public static <E> Collection<E> newSynchronizedCollection(Collection<E> c) {
        return java.util.Collections.synchronizedCollection(c);
    }

    public static <E> Collection<E> unmodified(Collection<E> c) {
        return java.util.Collections.unmodifiableCollection(c);
    }

    public static String join(Collection<?> c) {
        return Collections.join(c, ",", "", "");
    }

    public static String join(Collection<?> c, String split) {
        return Collections.join(c, split, "", "");
    }

    public static String join(Collection<?> c, String split, String open, String end) {
        int size = Collections.size(c);
        open = Strings.def(open);
        end = Strings.def(end);
        split = Strings.def(split);
        if (size == 0) {
            return open + end;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(open);
        Iterator<?> iterator = c.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (++i == size) continue;
            sb.append(split).append(" ");
        }
        return sb.append(end).toString();
    }

    public static <E> Stream<E> stream(Collection<E> c) {
        return Collections.isEmpty(c) ? Stream.empty() : c.stream();
    }

    public static <E> void forEach(Collection<E> c, Consumer<? super E> action) {
        if (Collections.isEmpty(c)) {
            return;
        }
        c.forEach(action);
    }

    public static int size(Collection<?> c) {
        return c == null ? 0 : c.size();
    }

    public static boolean isEmpty(Collection<?> c) {
        return Collections.size(c) == 0;
    }

    public static boolean isNotEmpty(Collection<?> c) {
        return !Collections.isEmpty(c);
    }

    public static boolean isAllEmpty(Collection<?> ... cs) {
        if (cs == null) {
            return true;
        }
        for (Collection<?> c : cs) {
            if (Collections.isEmpty(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneEmpty(Collection<?> ... cs) {
        if (cs == null) {
            return false;
        }
        for (Collection<?> c : cs) {
            if (!Collections.isEmpty(c)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean contains(Collection<E> c, E e) {
        if (Collections.isEmpty(c)) {
            return false;
        }
        return c.contains(e);
    }

    public static <E> boolean containsAll(Collection<E> c, Collection<E> e) {
        if (Collections.isEmpty(c)) {
            return false;
        }
        return c.containsAll(e);
    }

    public static void compact(Collection<?> c) {
        if (Collections.size(c) == 0) {
            return;
        }
        while (c.remove(null)) {
        }
    }

    public static void exclude(Collection<?> c, Object ... es) {
        if (Collections.size(c) == 0) {
            return;
        }
        Set<Object> e = Sets.of(es);
        for (Object o : e) {
            while (c.remove(o)) {
            }
        }
    }

    public static <E> Set<E> inter(Collection<E> c1, Collection<E> c2) {
        if (Collections.isEmpty(c1) || Collections.isEmpty(c2)) {
            return new HashSet();
        }
        HashSet<E> r = new HashSet<E>(c1);
        r.retainAll(c2);
        return r;
    }

    public static <E> Set<E> union(Collection<E> c1, Collection<E> c2) {
        if (Collections.isEmpty(c1) && Collections.isEmpty(c2)) {
            return new HashSet();
        }
        if (Collections.isEmpty(c1) && !Collections.isEmpty(c2)) {
            return new HashSet<E>(c2);
        }
        if (Collections.isEmpty(c2) && !Collections.isEmpty(c1)) {
            return new HashSet<E>(c1);
        }
        HashSet<E> r = new HashSet<E>(c1);
        r.addAll(c2);
        return r;
    }

    public static <E> Set<E> diff(Collection<E> c1, Collection<E> c2) {
        return Collections.diff(c1, c2, false);
    }

    public static <E> Set<E> diffAll(Collection<E> c1, Collection<E> c2) {
        return Collections.diff(c1, c2, true);
    }

    public static <E> Set<E> diff(Collection<E> c1, Collection<E> c2, boolean diffAll) {
        if (Collections.isEmpty(c2) && Collections.isEmpty(c1)) {
            return new HashSet();
        }
        if (Collections.isEmpty(c2) && !Collections.isEmpty(c1)) {
            return new HashSet<E>(c1);
        }
        if (Collections.isEmpty(c1) && !Collections.isEmpty(c2)) {
            return new HashSet<E>(c2);
        }
        HashSet<E> r = new HashSet<E>(c1);
        if (diffAll) {
            HashSet<E> i = new HashSet<E>(c1);
            r.addAll(c2);
            i.retainAll(c2);
            r.removeAll(i);
        } else {
            r.removeAll(c2);
        }
        return r;
    }

    public static <E> void fill(List<E> list, E value) {
        Collections.fill(list, value, 0, Collections.size(list) - 1);
    }

    public static <E> void fill(List<E> list, E value, int start) {
        Collections.fill(list, value, start, Collections.size(list) - 1);
    }

    public static <E> void fill(List<E> list, E value, int start, int end) {
        int size = Collections.size(list);
        if (size != 0 && size > start && size > end && start != end && start >= 0 && end > 0) {
            for (int i = start; i < end + 1; ++i) {
                list.set(i, value);
            }
        }
    }

    public static <T> T min(Collection<? extends T> c) {
        Iterator<T> i = c.iterator();
        T cn = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (((Comparable)next).compareTo(cn) >= 0) continue;
            cn = next;
        }
        return cn;
    }

    public static <T> T min(Collection<? extends T> c, Comparator<? super T> comp) {
        if (comp == null) {
            return Collections.min(c);
        }
        Iterator<T> i = c.iterator();
        T cn = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (comp.compare(next, cn) >= 0) continue;
            cn = next;
        }
        return cn;
    }

    public static <T> T max(Collection<? extends T> c) {
        Iterator<T> i = c.iterator();
        T cn = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (((Comparable)next).compareTo(cn) <= 0) continue;
            cn = next;
        }
        return cn;
    }

    public static <T> T max(Collection<? extends T> c, Comparator<? super T> comp) {
        if (comp == null) {
            return Collections.max(c);
        }
        Iterator<T> i = c.iterator();
        T cn = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (comp.compare(next, cn) <= 0) continue;
            cn = next;
        }
        return cn;
    }

    public static <E> E first(Collection<E> c) {
        if (Collections.size(c) == 0) {
            return null;
        }
        return c.iterator().next();
    }

    public static <E> E last(Collection<E> c) {
        E e;
        if (Collections.size(c) == 0) {
            return null;
        }
        if (c instanceof List) {
            List list = (List)c;
            return list.get(list.size() - 1);
        }
        Iterator<E> iterator = c.iterator();
        do {
            e = iterator.next();
        } while (iterator.hasNext());
        return e;
    }

    public static <E> Collection<E> distinct(Collection<E> c, Function<E, ?> keyGetter) {
        HashMap map = new HashMap(16);
        for (E e : c) {
            map.put(keyGetter.apply(e), e);
        }
        return map.values();
    }
}

