/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.check;

import java.util.zip.Checksum;

public class CRC8
implements Checksum {
    private final short init;
    private final short[] crcTable;
    private short value;

    public CRC8(int polynomial) {
        this(polynomial, 0);
    }

    public CRC8(int polynomial, short init) {
        this.value = this.init = init;
        this.crcTable = new short[256];
        for (int dividend = 0; dividend < 256; ++dividend) {
            int remainder = dividend;
            for (int bit = 0; bit < 8; ++bit) {
                if ((remainder & 1) != 0) {
                    remainder = remainder >>> 1 ^ polynomial;
                    continue;
                }
                remainder >>>= 1;
            }
            this.crcTable[dividend] = (short)remainder;
        }
    }

    @Override
    public void update(byte[] b, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            int data = b[offset + i] ^ this.value;
            this.value = (short)(this.crcTable[data & 0xFF] ^ this.value << 8);
        }
    }

    @Override
    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    @Override
    public void update(int b) {
        this.update(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public long getValue() {
        return this.value & 0xFF;
    }

    @Override
    public void reset() {
        this.value = this.init;
    }
}

