/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils.awt;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.codec.Base64s;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class Images {
    private Images() {
    }

    public static BufferedImage copy(BufferedImage img) {
        return Images.copy(img, img.getType());
    }

    public static BufferedImage copy(BufferedImage img, int imageType) {
        BufferedImage newImage = new BufferedImage(img.getWidth(), img.getHeight(), imageType);
        Graphics2D g = newImage.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return newImage;
    }

    public static BufferedImage resize(BufferedImage img, int width, int height) {
        return Images.resize(img, width, height, 0, 0);
    }

    public static BufferedImage resize(BufferedImage img, int width, int height, int x, int y) {
        BufferedImage newImage = new BufferedImage(width, height, img.getType());
        Graphics2D g = newImage.createGraphics();
        g.drawImage((Image)img, x, y, null);
        g.dispose();
        return newImage;
    }

    public static void setAntiAliasing(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static BufferedImage getTransparentImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2d = image.createGraphics();
        image = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
        g2d.dispose();
        return image;
    }

    public static BufferedImage getRadiusImage(BufferedImage image, int radius) {
        return Images.getRadiusImage(image, radius, radius);
    }

    public static BufferedImage getRadiusImage(BufferedImage image, float arcw, float arch) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage transparentImage = Images.getTransparentImage(width, height);
        Graphics2D g2d = transparentImage.createGraphics();
        Images.setAntiAliasing(g2d);
        g2d.setClip(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, arcw, arch));
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return transparentImage;
    }

    public static BufferedImage getImage(String path) {
        try {
            return ImageIO.read(new File(path));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static BufferedImage getImage(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static BufferedImage getImage(byte[] bs) {
        try {
            return ImageIO.read(Streams.toInputStream(bs));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static BufferedImage getImage(InputStream in) {
        try {
            return ImageIO.read(in);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static BufferedImage getImageBase64(String base64) {
        try {
            return ImageIO.read(Streams.toInputStream(Base64s.img64Decode(base64)));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static BufferedImage getImageBase64(byte[] bs) {
        try {
            return ImageIO.read(Streams.toInputStream(Base64s.decode(bs)));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static BufferedImage getImageByIcons(byte[] bs) {
        return Images.getImageByIcons(new ImageIcon(bs));
    }

    public static BufferedImage getImageByIcons(InputStream in) throws IOException {
        return Images.getImageByIcons(new ImageIcon(Streams.toByteArray(in)));
    }

    public static BufferedImage getImageByIcons(String base64) {
        return Images.getImageByIcons(new ImageIcon(Base64s.img64Decode(base64)));
    }

    public static BufferedImage getImageByIcons(ImageIcon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        g.drawImage(icon.getImage(), 0, 0, null);
        g.dispose();
        return bufferedImage;
    }

    public static int[] getSize(BufferedImage img) {
        return new int[]{img.getWidth(null), img.getHeight(null)};
    }

    public static byte[] getBytes(BufferedImage img) {
        return Images.getBytes(img, "png");
    }

    public static byte[] getBytes(BufferedImage img, String format) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, format, stream);
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static void write(BufferedImage img, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)img, "png", out);
    }

    public static void write(BufferedImage img, String format, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)img, format, out);
    }

    public static void write(BufferedImage img, String path) throws IOException {
        Files1.touch(path);
        ImageIO.write((RenderedImage)img, "png", new File(path));
    }

    public static void write(BufferedImage img, String format, String path) throws IOException {
        Files1.touch(path);
        ImageIO.write((RenderedImage)img, format, new File(path));
    }

    public static void write(BufferedImage img, File file) throws IOException {
        Files1.touch(file);
        ImageIO.write((RenderedImage)img, "png", file);
    }

    public static void write(BufferedImage img, String format, File file) throws IOException {
        Files1.touch(file);
        ImageIO.write((RenderedImage)img, format, file);
    }

    public static String base64Encode(BufferedImage img) {
        return Images.base64Encode(img, "png");
    }

    public static String base64Encode(BufferedImage img, String format) {
        return Base64s.img64Encode(Images.getBytes(img, format), format);
    }

    public static String base64Encode(byte[] bs) {
        return Base64s.img64Encode(bs);
    }

    public static String base64Encode(byte[] bs, String type) {
        return Base64s.img64Encode(bs, type);
    }

    public static byte[] base64Decode(String s) {
        return Base64s.img64Decode(s);
    }
}

