/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils;

import com.orion.lang.able.IHttpResponse;
import com.orion.lang.define.wrapper.HttpWrapper;
import com.orion.lang.define.wrapper.RpcWrapper;
import com.orion.lang.utils.Arrays1;
import com.orion.lang.utils.Compares;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Objects1;
import com.orion.lang.utils.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;

public abstract class Valid {
    private static final String VALID_NOT_EQUAL = "the validated objects not equal";
    private static final String VALID_IS_EQUAL = "the validated objects is equal";
    private static final String VALID_NOT_COMPARE = "the validated objects not compare";
    private static final String VALID_IS_COMPARE = "the validated objects is compare";
    private static final String VALID_NOT_LT = "the validated objects not less than";
    private static final String VALID_NOT_LT_EQ = "the validated objects not less than or equal";
    private static final String VALID_NOT_GT = "the validated objects not greater than";
    private static final String VALID_NOT_GT_EQ = "the validated objects not greater than or equal";
    private static final String VALID_IS_FALSE = "the validated expression is false";
    private static final String VALID_IS_TRUE = "the validated expression is true";
    private static final String VALID_IS_NULL = "the validated object is null";
    private static final String VALID_NOT_ARRAY = "the validated object not in array";
    private static final String VALID_NOT_COLLECTION = "the validated object not in collection";
    private static final String VALID_NOT_IN_ARRAY = "the validated object in array";
    private static final String VALID_NOT_IN_COLLECTION = "the validated object in collection";
    private static final String VALID_ARRAY_IS_EMPTY = "the validated array is empty";
    private static final String VALID_COLLECTION_IS_EMPTY = "the validated collection is empty";
    private static final String VALID_MAP_IS_EMPTY = "the validated map is empty";
    private static final String VALID_STRING_IS_EMPTY = "the validated string is empty";
    private static final String VALID_STRING_IS_BLANK = "the validated string is blank";
    private static final String VALID_STRING_NOT_NUMBER = "the validated string not numbers";
    private static final String VALID_STRING_NOT_INTEGER = "the validated string not integer";
    private static final String VALID_STRING_NOT_DOUBLE = "the validated string sequence not double";
    private static final String VALID_ARRAY_INDEX = "the validated array index is invalid: {}";
    private static final String VALID_COLLECTION_INDEX = "the validated collection index is invalid: {}";
    private static final String VALID_ARRAY_CONTENTS_NULL = "the validated array contains null element";
    private static final String VALID_COLLECTION_CONTENTS_NULL = "the validated collection contains null element";
    private static final String VALID_STRING_NOT_MATCH = "the string {} not match the pattern {}";
    private static final String VALID_STRING_MATCH = "the string {} match the pattern {}";
    private static final String VALID_VALUE_IS_ZERO = "the validated value is zero";
    private static final String VALID_VALUE_IS_NAN = "the validated value is not a number";
    private static final String VALID_VALUE_NOT_IN_RANGE = "the value {} is not in the specified inclusive range of {} to {}";
    private static final String VALID_VALUE_IN_RANGE = "the value {} in the specified inclusive range of {} to {}";
    private static final String VALID_STRING_LENGTH = "the validated value length is not equal {}";
    private static final String VALID_STRING_LENGTH_IN = "the validated value length is not in {} of {}";
    private static final String VALID_LENGTH_NOT_GT = "the validated value length is not greater than {}";
    private static final String VALID_LENGTH_NOT_GT_EQ = "the validated value length is not greater than or equal {}";
    private static final String VALID_LENGTH_NOT_LT = "the validated value length is not less than {}";
    private static final String VALID_LENGTH_NOT_LT_EQ = "the validated value length is not less than or equal {}";
    private static final String VALID_NOT_INSTANCE = "expected type: {}, actual: {}";
    private static final String HTTP_WRAPPER_NOT_OK = "http wrapper not ok. code: {}, message: {}";
    private static final String RPC_WRAPPER_NOT_SUCCESS = "rpc wrapper not success. code: {}, message: {}";
    private static final String HTTP_REQ_NOT_OK = "http request not success. code: {}, url: {}";

    public static void eq(Object o1, Object o2) {
        Valid.eq(o1, o2, VALID_NOT_EQUAL, new Object[0]);
    }

    public static void eq(Object o1, Object o2, String message, Object ... values) {
        Valid.notNull(o1);
        if (!Objects1.eq(o1, o2)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
    }

    public static void neq(Object o1, Object o2) {
        Valid.neq(o1, o2, VALID_IS_EQUAL, new Object[0]);
    }

    public static void neq(Object o1, Object o2, String message, Object ... values) {
        Valid.notNull(o1);
        if (Objects1.eq(o1, o2)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
    }

    public static <T extends Comparable<T>> void compare(T t1, T t2) {
        Valid.compare(t1, t2, VALID_NOT_COMPARE, new Object[0]);
    }

    public static <T extends Comparable<T>> void compare(T t1, T t2, String message, Object ... values) {
        Valid.notNull(t1);
        Valid.notNull(t2);
        if (t1.compareTo(t2) != 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
    }

    public static <T extends Comparable<T>> void notCompare(T t1, T t2) {
        Valid.notCompare(t1, t2, VALID_IS_COMPARE, new Object[0]);
    }

    public static <T extends Comparable<T>> void notCompare(T t1, T t2, String message, Object ... values) {
        Valid.notNull(t1);
        Valid.notNull(t2);
        if (t1.compareTo(t2) == 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
    }

    public static <T> void compare(T t1, T t2, Comparator<T> comparator) {
        Valid.compare(t1, t2, comparator, VALID_NOT_COMPARE, new Object[0]);
    }

    public static <T> void compare(T t1, T t2, Comparator<T> comparator, String message, Object ... values) {
        Valid.notNull(comparator);
        if (comparator.compare(t1, t2) != 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
    }

    public static <T> void notCompare(T t1, T t2, Comparator<T> comparator) {
        Valid.notCompare(t1, t2, comparator, VALID_IS_COMPARE, new Object[0]);
    }

    public static <T> void notCompare(T t1, T t2, Comparator<T> comparator, String message, Object ... values) {
        Valid.notNull(comparator);
        if (comparator.compare(t1, t2) == 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
    }

    public static <T extends Comparable<T>> T lt(T value, T refer) {
        return Valid.lt(value, refer, VALID_NOT_LT, new Object[0]);
    }

    public static <T extends Comparable<T>> T lt(T value, T refer, String message, Object ... values) {
        Valid.notNull(value);
        Valid.notNull(refer);
        if (value.compareTo(refer) >= 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static <T extends Comparable<T>> T lte(T value, T refer) {
        return Valid.lte(value, refer, VALID_NOT_LT_EQ, new Object[0]);
    }

    public static <T extends Comparable<T>> T lte(T value, T refer, String message, Object ... values) {
        Valid.notNull(value);
        Valid.notNull(refer);
        if (value.compareTo(refer) > 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static <T extends Comparable<T>> T gt(T value, T refer) {
        return Valid.gt(value, refer, VALID_NOT_GT, new Object[0]);
    }

    public static <T extends Comparable<T>> T gt(T value, T refer, String message, Object ... values) {
        Valid.notNull(value);
        Valid.notNull(refer);
        if (value.compareTo(refer) <= 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static <T extends Comparable<T>> T gte(T value, T refer) {
        return Valid.gte(value, refer, VALID_NOT_GT_EQ, new Object[0]);
    }

    public static <T extends Comparable<T>> T gte(T value, T refer, String message, Object ... values) {
        Valid.notNull(value);
        Valid.notNull(refer);
        if (value.compareTo(refer) < 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static boolean isTrue(BooleanSupplier s) {
        return Valid.isTrue(s, VALID_IS_FALSE, new Object[0]);
    }

    public static boolean isTrue(BooleanSupplier s, String message, Object ... values) {
        Valid.notNull(s);
        if (!s.getAsBoolean()) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return true;
    }

    public static boolean isTrue(boolean expression) {
        return Valid.isTrue(expression, VALID_IS_FALSE, new Object[0]);
    }

    public static boolean isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return true;
    }

    public static boolean isFalse(BooleanSupplier s) {
        return Valid.isFalse(s, VALID_IS_TRUE, new Object[0]);
    }

    public static boolean isFalse(BooleanSupplier s, String message, Object ... values) {
        Valid.notNull(s);
        if (s.getAsBoolean()) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return false;
    }

    public static boolean isFalse(boolean expression) {
        return Valid.isFalse(expression, VALID_IS_TRUE, new Object[0]);
    }

    public static boolean isFalse(boolean expression, String message, Object ... values) {
        if (expression) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return false;
    }

    public static <T> T notNull(T object) {
        return Valid.notNull(object, VALID_IS_NULL, new Object[0]);
    }

    public static <T> T notNull(T object, String message, Object ... values) {
        if (object == null) {
            throw Exceptions.nullArgument(Strings.format(message, values));
        }
        return object;
    }

    @SafeVarargs
    public static <T> T in(T t, T ... arr) {
        return Valid.in(t, arr, VALID_NOT_ARRAY, new Object[0]);
    }

    public static <T> T in(T t, T[] arr, String message, Object ... values) {
        Valid.notNull(t);
        Valid.notEmpty(arr);
        if (!Arrays1.contains(arr, t)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return t;
    }

    public static <T> T in(T t, Collection<? extends T> c) {
        return Valid.in(t, c, VALID_NOT_COLLECTION, new Object[0]);
    }

    public static <T> T in(T t, Collection<? extends T> c, String message, Object ... values) {
        Valid.notNull(t);
        Valid.notEmpty(c);
        if (!c.contains(t)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return t;
    }

    @SafeVarargs
    public static <T> T notIn(T t, T ... arr) {
        return Valid.notIn(t, arr, VALID_NOT_IN_ARRAY, new Object[0]);
    }

    public static <T> T notIn(T t, T[] arr, String message, Object ... values) {
        Valid.notNull(t);
        Valid.notEmpty(arr);
        if (Arrays1.contains(arr, t)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return t;
    }

    public static <T> T notIn(T t, Collection<? extends T> c) {
        return Valid.notIn(t, c, VALID_NOT_IN_COLLECTION, new Object[0]);
    }

    public static <T> T notIn(T t, Collection<? extends T> c, String message, Object ... values) {
        Valid.notNull(t);
        Valid.notEmpty(c);
        if (c.contains(t)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return t;
    }

    public static <T> T[] notEmpty(T[] array) {
        return Valid.notEmpty(array, VALID_ARRAY_IS_EMPTY, new Object[0]);
    }

    public static <T> T[] notEmpty(T[] array, String message, Object ... values) {
        if (array == null) {
            throw Exceptions.nullArgument(Strings.format(message, values));
        }
        if (array.length == 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return array;
    }

    public static <T extends Collection<?>> T notEmpty(T collection) {
        return Valid.notEmpty(collection, VALID_COLLECTION_IS_EMPTY, new Object[0]);
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message, Object ... values) {
        if (collection == null) {
            throw Exceptions.nullArgument(Strings.format(message, values));
        }
        if (collection.isEmpty()) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return collection;
    }

    public static <T extends Map<?, ?>> T notEmpty(T map) {
        return Valid.notEmpty(map, VALID_MAP_IS_EMPTY, new Object[0]);
    }

    public static <T extends Map<?, ?>> T notEmpty(T map, String message, Object ... values) {
        if (map == null) {
            throw Exceptions.nullArgument(Strings.format(message, values));
        }
        if (map.isEmpty()) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return map;
    }

    public static String notEmpty(String s) {
        return Valid.notEmpty(s, VALID_STRING_IS_EMPTY, new Object[0]);
    }

    public static String notEmpty(String s, String message, Object ... values) {
        if (s == null) {
            throw Exceptions.nullArgument(Strings.format(message, values));
        }
        if (s.length() == 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static String notBlank(String s) {
        return Valid.notBlank(s, VALID_STRING_IS_BLANK, new Object[0]);
    }

    public static String notBlank(String s, String message, Object ... values) {
        if (Strings.isBlank(s)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static String isNumber(String s) {
        return Valid.isNumber(s, VALID_STRING_NOT_NUMBER, new Object[0]);
    }

    public static String isNumber(String s, String message, Object ... values) {
        if (!Strings.isNumber(s)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static String isInteger(String s) {
        return Valid.isInteger(s, VALID_STRING_NOT_INTEGER, new Object[0]);
    }

    public static String isInteger(String s, String message, Object ... values) {
        if (!Strings.isInteger(s)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static String isDouble(String s) {
        return Valid.isNumber(s, VALID_STRING_NOT_DOUBLE, new Object[0]);
    }

    public static String isDouble(String s, String message, Object ... values) {
        if (!Strings.isDouble(s)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static <T> T validIndex(T[] array, int index) {
        return Valid.validIndex(array, index, VALID_ARRAY_INDEX, index);
    }

    public static <T> T validIndex(T[] array, int index, String message, Object ... values) {
        Valid.notNull(array);
        if (index < 0 || index >= array.length) {
            throw Exceptions.indexArgument(Strings.format(message, values));
        }
        return array[index];
    }

    public static <T extends Collection<?>> void validIndex(T collection, int index) {
        Valid.validIndex(collection, index, VALID_COLLECTION_INDEX, index);
    }

    public static <T extends Collection<?>> void validIndex(T collection, int index, String message, Object ... values) {
        Valid.notNull(collection);
        if (index < 0 || index >= collection.size()) {
            throw Exceptions.indexArgument(Strings.format(message, values));
        }
    }

    public static <T> T[] noNullElements(T[] array) {
        return Valid.noNullElements(array, VALID_ARRAY_CONTENTS_NULL, new Object[0]);
    }

    public static <T> T[] noNullElements(T[] array, String message, Object ... values) {
        Valid.notNull(array);
        for (T t : array) {
            if (t != null) continue;
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return array;
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable) {
        return Valid.noNullElements(iterable, VALID_COLLECTION_CONTENTS_NULL, new Object[0]);
    }

    public static <T extends Iterable<?>> T noNullElements(T iterable, String message, Object ... values) {
        Valid.notNull(iterable);
        int i = 0;
        Iterator<?> it = iterable.iterator();
        while (it.hasNext()) {
            if (it.next() == null) {
                throw Exceptions.invalidArgument(Strings.format(message, values));
            }
            ++i;
        }
        return iterable;
    }

    public static String isMatches(String input, String pattern) {
        return Valid.notMatches(input, pattern, VALID_STRING_NOT_MATCH, input, pattern);
    }

    public static String isMatches(String input, String pattern, String message, Object ... values) {
        if (!Pattern.matches(pattern, input)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return input;
    }

    public static String notMatches(String input, String pattern) {
        return Valid.notMatches(input, pattern, VALID_STRING_MATCH, input, pattern);
    }

    public static String notMatches(String input, String pattern, String message, Object ... values) {
        if (Pattern.matches(pattern, input)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return input;
    }

    public static int notZero(int value) {
        return Valid.notZero(value, VALID_VALUE_IS_ZERO, new Object[0]);
    }

    public static int notZero(int value, String message, Object ... values) {
        if (value == 0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static long notZero(long value) {
        return Valid.notZero(value, VALID_VALUE_IS_ZERO, new Object[0]);
    }

    public static long notZero(long value, String message, Object ... values) {
        if (value == 0L) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static double notZero(double value) {
        return Valid.notZero(value, VALID_VALUE_IS_ZERO, new Object[0]);
    }

    public static double notZero(double value, String message, Object ... values) {
        if (value == 0.0) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static BigDecimal notZero(BigDecimal value) {
        return Valid.notZero(value, VALID_VALUE_IS_ZERO, new Object[0]);
    }

    public static BigDecimal notZero(BigDecimal value, String message, Object ... values) {
        Valid.notNull(value);
        Valid.notCompare(BigDecimal.ZERO, value, message, values);
        return value;
    }

    public static BigInteger notZero(BigInteger value) {
        return Valid.notZero(value, VALID_VALUE_IS_ZERO, new Object[0]);
    }

    public static BigInteger notZero(BigInteger value, String message, Object ... values) {
        Valid.notNull(value);
        Valid.notCompare(BigInteger.ZERO, value, message, values);
        return value;
    }

    public static double notNaN(float value) {
        return Valid.notNaN(value, VALID_VALUE_IS_NAN, new Object[0]);
    }

    public static double notNaN(float value, String message, Object ... values) {
        if (Float.isNaN(value)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static double notNaN(double value) {
        return Valid.notNaN(value, VALID_VALUE_IS_NAN, new Object[0]);
    }

    public static double notNaN(double value, String message, Object ... values) {
        if (Double.isNaN(value)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static <T extends Comparable<T>> T inRange(T value, T start, T end) {
        return Valid.inRange(value, start, end, VALID_VALUE_NOT_IN_RANGE, value, start, end);
    }

    public static <T extends Comparable<T>> T inRange(T value, T start, T end, String message, Object ... values) {
        Valid.notNull(value);
        Valid.notNull(start);
        Valid.notNull(end);
        if (!Compares.inRange(value, start, end)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static <T extends Comparable<T>> T notInRange(T value, T start, T end) {
        return Valid.notInRange(start, end, value, VALID_VALUE_IN_RANGE, value, start, end);
    }

    public static <T extends Comparable<T>> T notInRange(T value, T start, T end, String message, Object ... values) {
        Valid.notNull(value);
        Valid.notNull(start);
        Valid.notNull(end);
        if (Compares.inRange(value, start, end)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return value;
    }

    public static String validLength(String s, int length) {
        return Valid.validLength(s, length, VALID_STRING_LENGTH, length);
    }

    public static String validLength(String s, int length, String message, Object ... values) {
        Valid.notNull(s);
        if (s.length() != length) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static String validLengthIn(String s, int start, int end) {
        return Valid.validLengthIn(s, start, end, VALID_STRING_LENGTH_IN, start, end);
    }

    public static String validLengthIn(String s, int start, int end, String message, Object ... values) {
        Valid.notNull(s);
        if (!Compares.inRange(s.length(), start, end)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static String validLengthGt(String s, int length) {
        return Valid.validLengthGt(s, length, VALID_LENGTH_NOT_GT, length);
    }

    public static String validLengthGt(String s, int length, String message, Object ... values) {
        Valid.notNull(s);
        if (s.length() <= length) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static String validLengthGte(String s, int length) {
        return Valid.validLengthGte(s, length, VALID_LENGTH_NOT_GT_EQ, length);
    }

    public static String validLengthGte(String s, int length, String message, Object ... values) {
        Valid.notNull(s);
        if (s.length() < length) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static String validLengthLt(String s, int length) {
        return Valid.validLengthLt(s, length, VALID_LENGTH_NOT_LT, length);
    }

    public static String validLengthLt(String s, int length, String message, Object ... values) {
        Valid.notNull(s);
        if (s.length() >= length) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static String validLengthLte(String s, int length) {
        return Valid.validLengthLte(s, length, VALID_LENGTH_NOT_LT_EQ, length);
    }

    public static String validLengthLte(String s, int length, String message, Object ... values) {
        Valid.notNull(s);
        if (s.length() > length) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return s;
    }

    public static <T> T isInstanceOf(Object obj, Class<T> type) {
        if (!type.isInstance(obj)) {
            throw Exceptions.invalidArgument(Strings.format(VALID_NOT_INSTANCE, type.getName(), obj == null ? "null" : obj.getClass().getName()));
        }
        return type.cast(obj);
    }

    public static <T> T isInstanceOf(Object obj, Class<T> type, String message, Object ... values) {
        if (!type.isInstance(obj)) {
            throw Exceptions.invalidArgument(Strings.format(message, values));
        }
        return type.cast(obj);
    }

    public static <T> T validWrapper(HttpWrapper<T> wrapper) {
        Valid.notNull(wrapper);
        Valid.isTrue(wrapper.isOk(), HTTP_WRAPPER_NOT_OK, wrapper.getCode(), wrapper.getMsg());
        return wrapper.getData();
    }

    public static <T> T validWrapper(RpcWrapper<T> wrapper) {
        Valid.notNull(wrapper);
        Valid.isTrue(wrapper.isSuccess(), RPC_WRAPPER_NOT_SUCCESS, wrapper.getCode(), wrapper.getMsg());
        return wrapper.getData();
    }

    public static <T extends IHttpResponse> T validHttpOk(T resp) {
        Valid.notNull(resp);
        int code = resp.getCode();
        if (code < 200 || code >= 300) {
            String url = resp.getUrl();
            throw Exceptions.httpRequest(url, Strings.format(HTTP_REQ_NOT_OK, code, url));
        }
        return resp;
    }
}

