/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.utils;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.reflect.Fields;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Enums {
    private Enums() {
    }

    public static boolean isEnum(Class<?> clazz) {
        Valid.notNull(clazz);
        return clazz.isEnum();
    }

    public static boolean isEnum(Object obj) {
        Valid.notNull(obj);
        return obj.getClass().isEnum();
    }

    public static String toString(Enum<?> e) {
        return e != null ? e.name() : null;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, int index) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        return (E)(index < enumConstants.length ? enumConstants[index] : null);
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, int index, E def) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        return (E)(index < enumConstants.length ? enumConstants[index] : def);
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String value) {
        return Enum.valueOf(enumClass, value);
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String value, E def) {
        if (enumClass == null || Strings.isBlank(value)) {
            return def;
        }
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static <E extends Enum<?>> E valueOf(Class<E> enumClass, Object value, Method method) {
        Enum[] es;
        for (Enum e : es = (Enum[])enumClass.getEnumConstants()) {
            Object v;
            try {
                method.setAccessible(true);
                v = method.invoke((Object)e, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e1) {
                throw Exceptions.runtime("no such method");
            }
            if (value instanceof Number && v instanceof Number && new BigDecimal(String.valueOf(value)).compareTo(new BigDecimal(String.valueOf(v))) == 0) {
                return (E)e;
            }
            if (!Objects.equals(v, value)) continue;
            return (E)e;
        }
        return null;
    }

    public static List<String> getNames(Class<? extends Enum<?>> clazz) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (enums == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>(enums.length);
        for (Enum<?> e : enums) {
            list.add(e.name());
        }
        return list;
    }

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> enumClass) {
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            map.put(e.name(), e);
        }
        return map;
    }

    public static <E extends Enum<E>> boolean contains(Class<E> enumClass, String val) {
        return Enums.getEnumMap(enumClass).containsKey(val);
    }

    public static boolean equalsIgnoreCase(Enum<?> e, String val) {
        return Strings.ignoreEq(Enums.toString(e), val);
    }

    public static boolean equals(Enum<?> e, String val) {
        return Strings.eq(Enums.toString(e), val);
    }

    public static List<String> getFields(Class<? extends Enum<?>> clazz) {
        return Fields.getFields(clazz).stream().filter(field -> !field.getType().isEnum()).filter(field -> !field.getName().contains("$VALUES")).filter(field -> !"ordinal".equals(field.getName())).map(Field::getName).collect(Collectors.toList());
    }

    public static Map<String, Object> getFieldValues(Class<? extends Enum<?>> clazz, String fieldName) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (enums == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(enums.length);
        for (Enum<?> e : enums) {
            map.put(e.name(), Fields.getFieldValue(e, fieldName));
        }
        return map;
    }
}

