/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.support.progress;

import com.orion.lang.support.progress.Progress;
import java.util.concurrent.atomic.AtomicLong;

public class ByteTransferProgress
implements Progress {
    protected long start;
    protected volatile AtomicLong current = new AtomicLong();
    protected long end;
    protected long startTime;
    protected long endTime;
    protected volatile boolean error;
    protected volatile boolean done;
    protected Runnable callback;

    public ByteTransferProgress(long end) {
        this(0L, end);
    }

    public ByteTransferProgress(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public ByteTransferProgress callback(Runnable callback) {
        this.callback = callback;
        return this;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setCurrent(long current) {
        this.current = new AtomicLong(current);
    }

    @Override
    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void reset() {
        this.start = 0L;
        this.startTime = 0L;
    }

    public void accept(long read) {
        this.current.addAndGet(read);
    }

    public void startTime(long startTime) {
        this.startTime = startTime;
    }

    public void endTime(long endTime) {
        this.endTime = endTime;
    }

    @Override
    public void finish() {
        this.finish(false);
    }

    @Override
    public void finish(boolean error) {
        if (this.done) {
            return;
        }
        this.endTime = System.currentTimeMillis();
        this.done = true;
        this.error = error;
        if (this.callback != null) {
            this.callback.run();
        }
    }

    @Override
    public double getProgress() {
        if (this.done && !this.error) {
            return 1.0;
        }
        if (this.end == 0L) {
            return 0.0;
        }
        return (double)this.current.get() / (double)this.end;
    }

    public long usedTime() {
        return this.endTime - this.startTime;
    }

    public long getStart() {
        return this.start;
    }

    public long getCurrent() {
        return this.current.get();
    }

    public long getEnd() {
        return this.end;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isError() {
        return this.error;
    }
}

