/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.id;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class UUIds {
    private static final String STR_BASE = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final char[] DIGITS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final Map<Character, Integer> DIGIT_MAP = new HashMap<Character, Integer>();
    private static final int MIN_RADIX = 2;
    private static final int MAX_RADIX;

    private UUIds() {
    }

    public static String random() {
        return UUID.randomUUID().toString();
    }

    public static String random32() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String random19() {
        UUID uuid = UUID.randomUUID();
        return UUIds.digits(uuid.getMostSignificantBits() >> 32, 8) + UUIds.digits(uuid.getMostSignificantBits() >> 16, 4) + UUIds.digits(uuid.getMostSignificantBits(), 4) + UUIds.digits(uuid.getLeastSignificantBits() >> 48, 4) + UUIds.digits(uuid.getLeastSignificantBits(), 12);
    }

    public static String random15() {
        return UUIDMaker.generate();
    }

    public static long random15Long() {
        return UUIds.toNumber(UUIds.random15(), 10);
    }

    public static String randomBase64() {
        UUID uuid = UUID.randomUUID();
        byte[] byUuid = new byte[16];
        long least = uuid.getLeastSignificantBits();
        long most = uuid.getMostSignificantBits();
        UUIds.long2bytes(most, byUuid, 0);
        UUIds.long2bytes(least, byUuid, 8);
        return Base64.getEncoder().encodeToString(byUuid);
    }

    private static void long2bytes(long value, byte[] bytes, int offset) {
        for (int i = 7; i > -1; --i) {
            bytes[offset++] = (byte)(value >> 8 * i & 0xFFL);
        }
    }

    private static long toNumber(String s, int radix) {
        Valid.notNull(s, "number is null", new Object[0]);
        if (radix < 2) {
            throw Exceptions.numberFormat("radix " + radix + " less than MIN_RADIX");
        }
        if (radix > MAX_RADIX) {
            throw Exceptions.numberFormat("radix " + radix + " greater than MAX_RADIX");
        }
        boolean negative = false;
        int i = 0;
        int len = s.length();
        long result = 0L;
        long limit = -9223372036854775807L;
        if (len <= 0) {
            throw UUIds.swap(s);
        }
        char firstChar = s.charAt(0);
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
            } else if (firstChar != '+') {
                throw UUIds.swap(s);
            }
            if (len == 1) {
                throw UUIds.swap(s);
            }
            ++i;
        }
        long multmin = limit / (long)radix;
        while (i < len) {
            Integer digit;
            if ((digit = DIGIT_MAP.get(Character.valueOf(s.charAt(i++)))) == null || digit < 0 || result < multmin) {
                throw UUIds.swap(s);
            }
            if ((result *= (long)radix) < limit + (long)digit.intValue()) {
                throw UUIds.swap(s);
            }
            result -= (long)digit.intValue();
        }
        return negative ? result : -result;
    }

    private static String toString(long num, int radix) {
        boolean negative;
        if (radix < 2 || radix > MAX_RADIX) {
            radix = 10;
        }
        if (radix == 10) {
            return Long.toString(num);
        }
        int size = 65;
        int charPos = 64;
        char[] buf = new char[65];
        boolean bl = negative = num < 0L;
        if (!negative) {
            num = -num;
        }
        while (num <= (long)(-radix)) {
            buf[charPos--] = DIGITS[(int)(-(num % (long)radix))];
            num /= (long)radix;
        }
        buf[charPos] = DIGITS[(int)(-num)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return UUIds.toString(hi | val & hi - 1L, MAX_RADIX).substring(1);
    }

    private static NumberFormatException swap(String s) {
        return Exceptions.numberFormat("for input string: " + s);
    }

    static {
        for (int i = 0; i < DIGITS.length; ++i) {
            DIGIT_MAP.put(Character.valueOf(DIGITS[i]), i);
        }
        MAX_RADIX = DIGITS.length;
    }

    private static class UUIDMaker {
        private static final String STR = "0123456789abcdefghijklmnopqrstuvwxyz";
        private static final int PIX_LEN = "0123456789abcdefghijklmnopqrstuvwxyz".length();
        private static volatile int pixOne = 0;
        private static volatile int pixTwo = 0;
        private static volatile int pixThree = 0;
        private static volatile int pixFour = 0;

        private UUIDMaker() {
        }

        private static synchronized String generate() {
            String hexString = Long.toHexString(System.currentTimeMillis());
            if (++pixFour == PIX_LEN) {
                pixFour = 0;
                if (++pixThree == PIX_LEN) {
                    pixThree = 0;
                    if (++pixTwo == PIX_LEN) {
                        pixTwo = 0;
                        if (++pixOne == PIX_LEN) {
                            pixOne = 0;
                        }
                    }
                }
            }
            return hexString + STR.charAt(pixOne) + STR.charAt(pixTwo) + STR.charAt(pixThree) + STR.charAt(pixFour);
        }
    }
}

