/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.function.select;

import com.orion.lang.function.select.Branch;
import com.orion.lang.utils.Exceptions;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Selector<P, R> {
    private final P param;
    private boolean selected;
    private Function<P, R> factory;

    public Selector(P param) {
        this.param = param;
    }

    public Selector(Supplier<P> supplier) {
        this.param = supplier.get();
    }

    public static <P, R> Selector<P, R> of(P param) {
        return new Selector<P, R>(param);
    }

    public static <P, R> Selector<P, R> of(Supplier<P> supplier) {
        return new Selector<P, R>(supplier);
    }

    public Selector<P, R> test(Branch<P, R> branch) {
        boolean miss;
        if (!this.selected && (miss = branch.tester().test(this.param))) {
            this.selected = true;
            this.factory = branch.factory();
        }
        return this;
    }

    public R get() {
        if (!this.selected) {
            throw Exceptions.noSuchElement("missed branch");
        }
        return this.factory.apply(this.param);
    }

    public R or(Function<P, R> function) {
        return this.selected ? this.factory.apply(this.param) : function.apply(this.param);
    }

    public R orGet(Supplier<R> supplier) {
        return this.selected ? this.factory.apply(this.param) : supplier.get();
    }

    public R orElse(R r) {
        return this.selected ? this.factory.apply(this.param) : r;
    }

    public <E extends Throwable> R orThrow(Supplier<? extends E> supplier) throws E {
        if (!this.selected) {
            throw (Throwable)supplier.get();
        }
        return this.factory.apply(this.param);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void ifPresent(Consumer<R> consumer) {
        if (this.selected) {
            consumer.accept(this.factory.apply(this.param));
        }
    }
}

