/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.wrapper;

import com.orion.lang.utils.Objects1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class GroupList<E> {
    private final Collection<E> list;

    public GroupList(Collection<E> list) {
        this.list = list;
    }

    public static <E> GroupList<E> of(Collection<E> list) {
        return new GroupList<E>(list);
    }

    public <V> List<E> group(Function<E, V> mapping, V value) {
        ArrayList<E> groupList = new ArrayList<E>();
        for (E v : this.list) {
            if (v == null || !Objects1.eq(value, mapping.apply(v))) continue;
            groupList.add(v);
        }
        return groupList;
    }

    public <V> List<E> group(Function<E, V> mapping, Predicate<V> f) {
        ArrayList<E> groupList = new ArrayList<E>();
        for (E v : this.list) {
            V apply;
            if (v == null || !f.test(apply = mapping.apply(v))) continue;
            groupList.add(v);
        }
        return groupList;
    }

    public <V> Map<V, List<E>> group(Function<E, V> mapping) {
        LinkedHashMap<Object, List> map = new LinkedHashMap<Object, List>();
        for (E v : this.list) {
            if (v == null) continue;
            V apply = mapping.apply(v);
            List vs = map.computeIfAbsent(apply, k -> new ArrayList());
            vs.add(v);
        }
        return map;
    }
}

