/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.thread;

import com.orion.lang.able.Buildable;
import com.orion.lang.utils.Valid;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadFactoryBuilder
implements Buildable<ThreadFactory> {
    private String prefix;
    private ClassLoader classLoader;
    private boolean daemon;
    private int priority = 5;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private ThreadGroup group;

    public static ThreadFactoryBuilder create() {
        return new ThreadFactoryBuilder();
    }

    public ThreadFactoryBuilder setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ThreadFactoryBuilder setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ThreadFactoryBuilder setPriority(int priority) {
        Valid.gte(priority, 1, "priority must greater than or eq 1", new Object[0]);
        Valid.lte(priority, 10, "priority must less than or eq 10", new Object[0]);
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadFactoryBuilder setGroup(String groupName) {
        this.group = new ThreadGroup(groupName);
        return this;
    }

    public ThreadFactoryBuilder setGroup(ThreadGroup group) {
        this.group = group;
        return this;
    }

    @Override
    public ThreadFactory build() {
        return ThreadFactoryBuilder.build(this);
    }

    private static ThreadFactory build(ThreadFactoryBuilder builder) {
        String namePrefix = builder.prefix;
        Thread.UncaughtExceptionHandler handler = builder.uncaughtExceptionHandler;
        AtomicLong count = namePrefix == null ? null : new AtomicLong();
        return r -> {
            Thread thread = builder.group == null ? new Thread(r) : new Thread(builder.group, r);
            if (namePrefix != null) {
                thread.setName(namePrefix + count.getAndIncrement());
            }
            if (builder.classLoader != null) {
                thread.setContextClassLoader(builder.classLoader);
            }
            thread.setDaemon(builder.daemon);
            thread.setPriority(builder.priority);
            if (handler != null) {
                thread.setUncaughtExceptionHandler(handler);
            }
            return thread;
        };
    }
}

