/*
 * Decompiled with CFR 0.152.
 */
package com.orion.lang.define.thread;

import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger counter;
    private final String prefix;
    private ClassLoader classLoader;
    private boolean daemon;
    private int priority;
    private ThreadGroup group;
    private Thread.UncaughtExceptionHandler handler;

    public NamedThreadFactory(String prefix) {
        this.prefix = Strings.def(prefix);
        this.counter = new AtomicInteger();
        this.priority = 5;
    }

    public NamedThreadFactory setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public NamedThreadFactory setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public NamedThreadFactory setPriority(int priority) {
        Valid.gte(priority, 1, "priority must greater than or eq 1", new Object[0]);
        Valid.lte(priority, 10, "priority must less than or eq 10", new Object[0]);
        this.priority = priority;
        return this;
    }

    public NamedThreadFactory setHandler(Thread.UncaughtExceptionHandler handler) {
        this.handler = handler;
        return this;
    }

    public NamedThreadFactory setGroup(String groupName) {
        this.group = new ThreadGroup(groupName);
        return this;
    }

    public NamedThreadFactory setGroup(ThreadGroup group) {
        this.group = group;
        return this;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = this.group == null ? new Thread(r) : new Thread(this.group, r);
        thread.setName(this.prefix + this.counter.getAndIncrement());
        if (this.classLoader != null) {
            thread.setContextClassLoader(this.classLoader);
        }
        thread.setDaemon(this.daemon);
        thread.setPriority(this.priority);
        if (this.handler != null) {
            thread.setUncaughtExceptionHandler(this.handler);
        }
        return thread;
    }
}

